/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.util.Key;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.log4j.Logger;

public class DSSFileSystemView
implements FileSystemView {
    private static final String SPACE_ESCAPE = "__SPACE__";
    private static final Set<String> METHOD_NAMES = new HashSet<String>(Arrays.asList("tryToGetExperiment", "listDataSetsByExperimentID"));
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DSSFileSystemView.class);
    private final String sessionToken;
    private final IServiceForDataStoreServer service;
    private final IGeneralInformationService generalInfoService;
    private FtpFile workingDirectory;
    private final IFtpPathResolverRegistry pathResolverRegistry;

    DSSFileSystemView(String sessionToken, IServiceForDataStoreServer service, IGeneralInformationService generalInfoService, IFtpPathResolverRegistry pathResolverRegistry) throws FtpException {
        this.sessionToken = sessionToken;
        this.service = (IServiceForDataStoreServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IServiceForDataStoreServer.class}, (InvocationHandler)new ServiceInvocationHandler(service));
        this.generalInfoService = generalInfoService;
        this.pathResolverRegistry = pathResolverRegistry;
        this.workingDirectory = this.getHomeDirectory();
    }

    public boolean changeWorkingDirectory(String path) throws FtpException {
        FtpFile ftpFile = this.getFile(path);
        if (ftpFile != null && ftpFile.isDirectory()) {
            this.workingDirectory = ftpFile;
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    public FtpFile getFile(String path) throws FtpException {
        return this.getFile(path, new Cache(SystemTimeProvider.SYSTEM_TIME_PROVIDER));
    }

    public FtpFile getFile(String path, Cache cache) throws FtpException {
        String normalizedPath = this.normalizePath(path);
        if (this.workingDirectory != null && this.workingDirectory.getAbsolutePath().equals(normalizedPath)) {
            return this.workingDirectory;
        }
        try {
            FtpPathResolverContext context = new FtpPathResolverContext(this.sessionToken, this.service, this.generalInfoService, this.pathResolverRegistry, cache);
            return this.pathResolverRegistry.resolve(normalizedPath, context);
        }
        catch (RuntimeException rex) {
            Exception realThrowable = CheckedExceptionTunnel.unwrapIfNecessary((Exception)rex);
            String message = String.format("Error while resolving FTP path '%s' : %s", path, realThrowable.getMessage());
            operationLog.error((Object)message);
            throw new FtpException(message, (Throwable)realThrowable);
        }
    }

    private String normalizePath(String path) throws FtpException {
        String fullPath = path.trim();
        if (fullPath.startsWith("./")) {
            fullPath = fullPath.substring(2);
        }
        if (!fullPath.startsWith("/")) {
            String absolutePath = this.workingDirectory.getAbsolutePath();
            if (!absolutePath.endsWith("/")) {
                absolutePath = String.valueOf(absolutePath) + "/";
            }
            fullPath = String.valueOf(absolutePath) + fullPath;
        }
        try {
            URI uri = new URI(fullPath.replaceAll(" ", SPACE_ESCAPE));
            String normalizedPath = uri.normalize().toString();
            normalizedPath = normalizedPath.replaceAll("/*$", "");
            normalizedPath = normalizedPath.replaceAll("/+", "/");
            normalizedPath = normalizedPath.replaceAll(SPACE_ESCAPE, " ");
            return StringUtils.isBlank((String)normalizedPath) ? "/" : normalizedPath;
        }
        catch (Exception ex) {
            throw new FtpException("Cannot parse path " + fullPath, (Throwable)ex);
        }
    }

    public FtpFile getHomeDirectory() throws FtpException {
        return this.getFile("/");
    }

    public FtpFile getWorkingDirectory() throws FtpException {
        return this.workingDirectory;
    }

    public boolean isRandomAccessible() throws FtpException {
        return true;
    }

    private final class ServiceInvocationHandler
    implements InvocationHandler {
        private final Map<Key, Object> cache = new HashMap<Key, Object>();
        private final IServiceForDataStoreServer openbisService;

        private ServiceInvocationHandler(IServiceForDataStoreServer service) {
            this.openbisService = service;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (METHOD_NAMES.contains(method.getName())) {
                Key key = new Key(args);
                Object result = this.cache.get(key);
                if (result == null) {
                    result = this.invoke(method, args);
                    this.cache.put(key, result);
                }
                return result;
            }
            return this.invoke(method, args);
        }

        private Object invoke(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
            return method.invoke((Object)this.openbisService, args);
        }
    }
}

