/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFolder;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.IExperimentChildrenLister;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ftpserver.ftplet.FtpFile;

public class ExperimentFolderResolver
implements IFtpPathResolver {
    private final IExperimentChildrenLister childLister;

    public ExperimentFolderResolver(IExperimentChildrenLister childLister) {
        this.childLister = childLister;
    }

    @Override
    public boolean canResolve(String path) {
        int nestedLevels = StringUtils.countMatches((String)path, (String)"/");
        return nestedLevels == 3;
    }

    @Override
    public FtpFile resolve(final String path, final FtpPathResolverContext resolverContext) {
        return new AbstractFtpFolder(path){

            @Override
            public List<FtpFile> unsafeListFiles() {
                return ExperimentFolderResolver.this.listChildrenNames(path, resolverContext);
            }
        };
    }

    private List<FtpFile> listChildrenNames(String expIdentifier, FtpPathResolverContext context) {
        ExperimentIdentifier identifier;
        String sessionToken;
        IServiceForDataStoreServer service = context.getService();
        List<Experiment> experiments = service.listExperiments(sessionToken = context.getSessionToken(), Collections.singletonList(identifier = new ExperimentIdentifierFactory(expIdentifier).createIdentifier()), new ExperimentFetchOptions());
        if (experiments == null || experiments.isEmpty()) {
            return Collections.emptyList();
        }
        return this.childLister.listExperimentChildrenPaths(experiments.get(0), expIdentifier, context);
    }
}

