/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFolder;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ftpserver.ftplet.FtpFile;

public class ProjectFolderResolver
implements IFtpPathResolver {
    @Override
    public boolean canResolve(String path) {
        int nestedLevels = StringUtils.countMatches((String)path, (String)"/");
        return nestedLevels == 2;
    }

    @Override
    public FtpFile resolve(final String path, final FtpPathResolverContext resolverContext) {
        return new AbstractFtpFolder(path){

            @Override
            public List<FtpFile> unsafeListFiles() {
                List experiments = ProjectFolderResolver.this.listExperiments(path, resolverContext);
                ArrayList<FtpFile> result = new ArrayList<FtpFile>();
                for (Experiment experiment : experiments) {
                    String childPath = String.valueOf(path) + "/" + experiment.getCode();
                    FtpFile childFile = resolverContext.getResolverRegistry().resolve(childPath, resolverContext);
                    result.add(childFile);
                }
                return result;
            }
        };
    }

    private List<Experiment> listExperiments(String projectIdentifier, FtpPathResolverContext context) {
        IServiceForDataStoreServer service = context.getService();
        String sessionToken = context.getSessionToken();
        ProjectIdentifier identifier = new ProjectIdentifierFactory(projectIdentifier).createIdentifier();
        return service.listExperimentsForProjects(sessionToken, Collections.singletonList(identifier), new ExperimentFetchOptions());
    }
}

