/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDatastorePlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IReportingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractTableModelReportingPlugin
extends AbstractDatastorePlugin
implements IReportingPluginTask {
    private static final long serialVersionUID = 1L;

    protected AbstractTableModelReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    public ReportingPluginType getReportingPluginType() {
        return ReportingPluginType.TABLE_MODEL;
    }

    @Override
    public LinkModel createLink(DatasetDescription dataset) {
        throw new IllegalArgumentException("The method createLink is not supported by TABLE_MODEL tasks");
    }

    @Override
    public TableModel createAggregationReport(Map<String, Object> parameters, DataSetProcessingContext context) {
        throw new IllegalArgumentException("The method createAggregationReport is not supported by TABLE_MODEL tasks");
    }

    public static String convertTableToCsvString(TableModel table) throws IOException {
        StringWriter writer = new StringWriter();
        CsvWriter csvWriter = new CsvWriter((Writer)writer, ',');
        List<TableModelColumnHeader> headers = table.getHeader();
        String[] stringArray = new String[headers.size()];
        int i = 0;
        while (i < stringArray.length) {
            stringArray[i] = headers.get(i).getTitle();
            ++i;
        }
        csvWriter.writeRecord(stringArray);
        List<TableModelRow> rows = table.getRows();
        for (TableModelRow row : rows) {
            List<ISerializableComparable> values = row.getValues();
            int i2 = 0;
            while (i2 < stringArray.length) {
                stringArray[i2] = values.get(i2).toString();
                ++i2;
            }
            csvWriter.writeRecord(stringArray);
        }
        return writer.toString();
    }
}

