/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.MailService;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IEmailSender;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetAndPathInfoDBConsistencyChecker;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.List;
import java.util.Properties;

public class DataSetAndPathInfoDBConsistencyCheckProcessingPlugin
implements IProcessingPluginTask {
    private static final long serialVersionUID = 1L;
    private transient IHierarchicalContentProvider fileProvider;
    private transient IHierarchicalContentProvider pathInfoProvider;

    public DataSetAndPathInfoDBConsistencyCheckProcessingPlugin(Properties properties, File storeRoot) {
    }

    public DataSetAndPathInfoDBConsistencyCheckProcessingPlugin(IHierarchicalContentProvider fileProvider, IHierarchicalContentProvider pathInfoProvider) {
        this.fileProvider = fileProvider;
        this.pathInfoProvider = pathInfoProvider;
    }

    @Override
    public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        DataSetAndPathInfoDBConsistencyChecker checker = new DataSetAndPathInfoDBConsistencyChecker(this.fileProvider, this.pathInfoProvider);
        checker.check(datasets);
        String report = checker.createReport();
        IEmailSender mailSender = new MailService(context.getMailClient(), context.getUserEmailOrNull()).createEmailSender();
        mailSender.withSubject("File system and path info DB consistency check report");
        mailSender.withBody(report);
        mailSender.send();
        return checker.getStatus();
    }
}

