/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HierarchicalContentUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentNodeVisitor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import java.util.List;

public class HierarchicalContentTraverseUtil {
    public static void traverse(IHierarchicalContentProvider provider, String dataSetCode, IHierarchicalContentNodeVisitor visitor) {
        IHierarchicalContent content = null;
        try {
            content = provider.asContent(dataSetCode);
            HierarchicalContentTraverseUtil.visit(content.getRootNode(), visitor);
        }
        finally {
            if (content != null) {
                content.close();
            }
        }
    }

    private static void visit(IHierarchicalContentNode node, IHierarchicalContentNodeVisitor visitor) {
        visitor.visit(node);
        if (node.isDirectory()) {
            List<IHierarchicalContentNode> children = node.getChildNodes();
            HierarchicalContentUtils.sortNodes(children);
            for (IHierarchicalContentNode child : children) {
                HierarchicalContentTraverseUtil.visit(child, visitor);
            }
        }
    }
}

