/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.screening.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.api.RpcServiceInterfaceVersionDTO;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.ConcatenatedFileOutputStreamWriter;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.common.api.server.RpcServiceNameServer;
import ch.systemsx.cisd.openbis.common.io.ConcatenatedContentInputStream;
import ch.systemsx.cisd.openbis.common.io.HierarchicalContentNodeBasedHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.dss.etl.AbsoluteImageReference;
import ch.systemsx.cisd.openbis.dss.etl.HCSImageDatasetLoaderFactory;
import ch.systemsx.cisd.openbis.dss.etl.IImagingDatasetLoader;
import ch.systemsx.cisd.openbis.dss.etl.IImagingLoaderStrategy;
import ch.systemsx.cisd.openbis.dss.etl.ImagingLoaderStrategyFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDssServiceRpc;
import ch.systemsx.cisd.openbis.dss.generic.server.IStreamRepository;
import ch.systemsx.cisd.openbis.dss.generic.server.images.ImageChannelsUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.images.RepresentationUtil;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageChannelStackReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.RequestedImageSize;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.dss.screening.server.DssServiceRpcScreeningLogger;
import ch.systemsx.cisd.openbis.dss.screening.server.logic.ImageRepresentationFormatFinder;
import ch.systemsx.cisd.openbis.dss.screening.server.util.FeatureVectorLoaderMetadataProviderFactory;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.v1.IDssServiceRpcScreening;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.AbstractFormatSelectionCriterion;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetImageRepresentationFormats;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureInformation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVector;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetWellReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorWithDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IFeatureVectorDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageRepresentationFormatSelectionCriterion;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageChannel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageRepresentationFormat;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageTransformationInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.LoadImageConfiguration;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MicroscopyImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageChannel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageTransformationInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.FeatureTableRow;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVectorLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.AbstractImgIdentifiable;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingTransformerDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgAnalysisDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgContainerDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureDefDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageTransformationDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelDTO;
import com.googlecode.jsonrpc4j.Base64;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;

public class DssServiceRpcScreening
extends AbstractDssServiceRpc<IDssServiceRpcScreening>
implements IDssServiceRpcScreening {
    public static final int MINOR_VERSION = 14;
    private final IImagingReadonlyQueryDAO dao;
    private final IImagingTransformerDAO transformerDAO;
    static final String IMAGE_VIEWER_TRANSFORMATION_CODE = "_CUSTOM";
    private static final String IMAGE_VIEWER_TRANSFORMATION_LABEL = "Custom";
    private static final String IMAGE_VIEWER_TRANSFORMATION_DESCRIPTION = "Custom image transformation defined with the Color Adjustment tool.";

    public DssServiceRpcScreening(String storeRootDir) {
        this(storeRootDir, DssScreeningUtils.getQuery(), DssScreeningUtils.createImagingTransformerDAO(), ServiceProvider.getOpenBISService(), null, null, null, true);
    }

    DssServiceRpcScreening(String storeRootDir, IImagingReadonlyQueryDAO dao, IImagingTransformerDAO transformerDAO, IEncapsulatedOpenBISService service, IStreamRepository streamRepository, IShareIdManager shareIdManager, IHierarchicalContentProvider contentProvider, boolean registerAtNameService) {
        super(service, streamRepository, shareIdManager, contentProvider);
        this.dao = dao;
        this.transformerDAO = transformerDAO;
        this.setStoreDirectory(new File(storeRootDir));
        if (registerAtNameService) {
            RpcServiceInterfaceVersionDTO ifaceVersion = new RpcServiceInterfaceVersionDTO("screening-dss", "/rmi-datastore-server-screening-api-v1", this.getMajorVersion(), this.getMinorVersion());
            RpcServiceInterfaceVersionDTO jsonVersion = new RpcServiceInterfaceVersionDTO("screening-dss", "/rmi-datastore-server-screening-api-v1.json", this.getMajorVersion(), this.getMinorVersion());
            HttpInvokerServiceExporter nameServiceExporter = ServiceProvider.getRpcNameServiceExporter();
            RpcServiceNameServer nameServer = (RpcServiceNameServer)nameServiceExporter.getService();
            nameServer.addSupportedInterfaceVersion(ifaceVersion);
            nameServer.addSupportedInterfaceVersion(jsonVersion);
            this.operationLog.info((Object)"[rpc] Started DSS RPC screening service V1.");
        }
    }

    @Override
    public List<String> listAvailableFeatureNames(String sessionToken, List<? extends IFeatureVectorDatasetIdentifier> featureDatasets) {
        return this.listAvailableFeatureCodes(sessionToken, featureDatasets);
    }

    @Override
    public IDssServiceRpcScreening createLogger(IInvocationLoggerContext context) {
        return new DssServiceRpcScreeningLogger(context);
    }

    @Override
    public List<String> listAvailableFeatureCodes(String sessionToken, List<? extends IFeatureVectorDatasetIdentifier> featureDatasets) {
        List<ImgFeatureDefDTO> featureDefinitions = this.getFeatureDefinitionsWithContained(featureDatasets);
        ArrayList<String> result = new ArrayList<String>();
        for (ImgFeatureDefDTO featureDefinition : featureDefinitions) {
            String featureCode = featureDefinition.getCode();
            if (result.contains(featureCode)) continue;
            result.add(featureCode);
        }
        return result;
    }

    @Override
    public List<FeatureInformation> listAvailableFeatures(String sessionToken, List<? extends IFeatureVectorDatasetIdentifier> featureDatasets) {
        List<ImgFeatureDefDTO> featureDefinitions = this.getFeatureDefinitionsWithContained(featureDatasets);
        ArrayList<FeatureInformation> result = new ArrayList<FeatureInformation>();
        for (ImgFeatureDefDTO featureDefinition : featureDefinitions) {
            FeatureInformation description = new FeatureInformation(featureDefinition.getCode(), featureDefinition.getLabel(), featureDefinition.getDescription());
            if (result.contains(description)) continue;
            result.add(description);
        }
        return result;
    }

    @Override
    public List<String> listAvailableFeatureLists(String sessionToken, IFeatureVectorDatasetIdentifier featureDataset) {
        IHierarchicalContent content = ServiceProvider.getHierarchicalContentProvider().asContent(featureDataset.getDatasetCode());
        IHierarchicalContentNode node = content.tryGetNode("feature_lists");
        LinkedList<String> result = new LinkedList<String>();
        if (node != null && node.exists() && node.isDirectory()) {
            List<IHierarchicalContentNode> children = node.getChildNodes();
            for (IHierarchicalContentNode child : children) {
                result.add(child.getName());
            }
        }
        return result;
    }

    @Override
    public List<String> getFeatureList(String sessionToken, IFeatureVectorDatasetIdentifier featureDataset, String featureListCode) {
        try {
            String value = this.readFeatureListContent(featureDataset.getDatasetCode(), featureListCode);
            String[] values = value.split("\n");
            return Arrays.asList(values);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot get the feature list of feature list doesn't exist", ioe);
        }
    }

    protected String readFeatureListContent(String dataSetCode, String featureListCode) throws IOException {
        IHierarchicalContent content = ServiceProvider.getHierarchicalContentProvider().asContent(dataSetCode);
        IHierarchicalContentNode node = content.tryGetNode("feature_lists/" + featureListCode);
        if (node == null) {
            throw new UserFailureException("The specified feature list <" + featureListCode + "> is not defined for data set " + dataSetCode);
        }
        InputStream is = null;
        String value = null;
        try {
            try {
                is = node.getInputStream();
                value = IOUtils.toString((InputStream)is);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
        }
        return value;
    }

    @Override
    public List<ImageDatasetMetadata> listImageMetadata(String sessionToken, List<? extends IImageDatasetIdentifier> imageDatasets) {
        IShareIdManager shareIdManager = this.getShareIdManager();
        ArrayList<String> dataSetCodes = new ArrayList<String>(imageDatasets.size());
        for (IImageDatasetIdentifier iImageDatasetIdentifier : imageDatasets) {
            dataSetCodes.add(iImageDatasetIdentifier.getDatasetCode());
        }
        shareIdManager.lock(dataSetCodes);
        try {
            ArrayList<ImageDatasetMetadata> arrayList = new ArrayList<ImageDatasetMetadata>();
            for (IImageDatasetIdentifier iImageDatasetIdentifier : imageDatasets) {
                IHierarchicalContent content = this.getHierarchicalContent(sessionToken, iImageDatasetIdentifier.getDatasetCode());
                try {
                    arrayList.add(this.extractImageMetadata(iImageDatasetIdentifier, content));
                }
                finally {
                    content.close();
                }
            }
            ArrayList<ImageDatasetMetadata> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            shareIdManager.releaseLocks();
        }
    }

    private ImageDatasetMetadata extractImageMetadata(IImageDatasetIdentifier dataset, IHierarchicalContent content) {
        IImagingDatasetLoader imageAccessor = this.createImageLoader(dataset.getDatasetCode(), content);
        Size imageSize = this.getOriginalImageSize(dataset, imageAccessor);
        Size thumbnailSize = this.getThumbnailImageSize(dataset, imageAccessor);
        ImageDatasetParameters params = imageAccessor.getImageParameters();
        return new ImageDatasetMetadata(dataset, this.toPublicChannels(params.getInternalChannels()), params.getTileRowsNum(), params.getTileColsNum(), imageSize.getWidth(), imageSize.getHeight(), thumbnailSize.getWidth(), thumbnailSize.getHeight());
    }

    private List<ImageChannel> toPublicChannels(List<InternalImageChannel> internalChannels) {
        ArrayList<ImageChannel> publicChannels = new ArrayList<ImageChannel>(internalChannels.size());
        for (InternalImageChannel channel : internalChannels) {
            publicChannels.add(new ImageChannel(channel.getCode(), channel.getLabel(), channel.tryGetDescription(), channel.tryGetWavelength(), this.toPublicImageTransformationInfos(channel.getAvailableImageTransformations())));
        }
        return publicChannels;
    }

    private List<ImageTransformationInfo> toPublicImageTransformationInfos(List<InternalImageTransformationInfo> internalTrafos) {
        ArrayList<ImageTransformationInfo> publicTrafos = new ArrayList<ImageTransformationInfo>(internalTrafos.size());
        for (InternalImageTransformationInfo info : internalTrafos) {
            publicTrafos.add(new ImageTransformationInfo(info.getCode(), info.getLabel(), info.getDescription(), info.isDefault()));
        }
        return publicTrafos;
    }

    private Size getOriginalImageSize(IImageDatasetIdentifier dataset, IImagingDatasetLoader imageAccessor) {
        List<ImgImageZoomLevelDTO> zoomLevelLists = this.dao.listOriginalImageZoomLevelsByPermId(dataset.getPermId());
        if (zoomLevelLists.isEmpty()) {
            this.operationLog.warn((Object)("No zoom-level entry found for the original image of specified dataset " + dataset.getPermId()));
            return DssServiceRpcScreening.getOriginalImageSizeFetchingImage(dataset, imageAccessor);
        }
        ImgImageZoomLevelDTO first = zoomLevelLists.get(0);
        if (first == null || first.getWidth() == null || first.getHeight() == null) {
            this.operationLog.warn((Object)("Image dimensions not found for the zoom level of the original image of specified dataset " + dataset.getPermId()));
            return DssServiceRpcScreening.getOriginalImageSizeFetchingImage(dataset, imageAccessor);
        }
        Size imageSize = new Size(first.getWidth(), first.getHeight());
        return imageSize;
    }

    private Size getThumbnailImageSize(IImageDatasetIdentifier dataset, IImagingDatasetLoader imageAccessor) {
        List<ImgImageZoomLevelDTO> zoomLevelLists = this.dao.listThumbImageZoomLevelsByPermId(dataset.getPermId());
        if (zoomLevelLists.isEmpty()) {
            this.operationLog.warn((Object)("No zoom-level entry found for the thumbnail of specified dataset " + dataset.getPermId()));
            return DssServiceRpcScreening.getThumbnailImageSizeFetchingImage(dataset, imageAccessor);
        }
        ImgImageZoomLevelDTO first = zoomLevelLists.get(0);
        if (first == null || first.getWidth() == null || first.getHeight() == null) {
            this.operationLog.warn((Object)("Image dimensions not found for the zoom level of the thumbnail of specified dataset " + dataset.getPermId()));
            return DssServiceRpcScreening.getThumbnailImageSizeFetchingImage(dataset, imageAccessor);
        }
        Size imageSize = new Size(first.getWidth(), first.getHeight());
        return imageSize;
    }

    private static Size getOriginalImageSizeFetchingImage(IImageDatasetIdentifier dataset, IImagingDatasetLoader imageAccessor) {
        BufferedImage image = DssServiceRpcScreening.getAnyImage(imageAccessor, dataset);
        Size imageSize = new Size(image.getWidth(), image.getHeight());
        return imageSize;
    }

    private static Size getThumbnailImageSizeFetchingImage(IImageDatasetIdentifier dataset, IImagingDatasetLoader imageAccessor) {
        BufferedImage image = DssServiceRpcScreening.getAnyThumbnailImage(imageAccessor, dataset);
        if (image != null) {
            return new Size(image.getWidth(), image.getHeight());
        }
        return Size.NULL_SIZE;
    }

    private static BufferedImage getAnyImage(IImagingDatasetLoader imageAccessor, IImageDatasetIdentifier dataset) {
        if (imageAccessor.getImageParameters().tryGetRowsNum() == null) {
            return DssServiceRpcScreening.getAnyMicroscopyImage(imageAccessor, dataset);
        }
        return DssServiceRpcScreening.getAnyHCSImage(imageAccessor, dataset);
    }

    private static BufferedImage getAnyThumbnailImage(IImagingDatasetLoader imageAccessor, IImageDatasetIdentifier dataset) {
        if (imageAccessor.getImageParameters().tryGetRowsNum() == null) {
            return DssServiceRpcScreening.getAnyMicroscopyThumbnail(imageAccessor, dataset);
        }
        return DssServiceRpcScreening.getAnyHCSThumbnail(imageAccessor, dataset);
    }

    private static BufferedImage getAnyMicroscopyImage(IImagingDatasetLoader imageAccessor, IImageDatasetIdentifier dataset) {
        ImageDatasetParameters params = imageAccessor.getImageParameters();
        RequestedImageSize originalOrThumbnail = RequestedImageSize.createOriginal();
        for (String channelCode : params.getChannelsCodes()) {
            AbsoluteImageReference image = imageAccessor.tryGetRepresentativeImage(channelCode, null, originalOrThumbnail, null);
            if (image == null) continue;
            return image.getUnchangedImage();
        }
        throw new IllegalStateException("Cannot find any image in a dataset: " + dataset);
    }

    private static BufferedImage getAnyMicroscopyThumbnail(IImagingDatasetLoader imageAccessor, IImageDatasetIdentifier dataset) {
        ImageDatasetParameters params = imageAccessor.getImageParameters();
        for (String channelCode : params.getChannelsCodes()) {
            AbsoluteImageReference image = imageAccessor.tryGetRepresentativeThumbnail(channelCode, null, null, null);
            if (image == null) continue;
            return image.getUnchangedImage();
        }
        return null;
    }

    private static BufferedImage getAnyHCSThumbnail(IImagingDatasetLoader imageAccessor, IImageDatasetIdentifier dataset) {
        AbsoluteImageReference image = imageAccessor.tryFindAnyThumbnail();
        if (image != null) {
            return image.getUnchangedImage();
        }
        return null;
    }

    private static BufferedImage getAnyHCSImage(IImagingDatasetLoader imageAccessor, IImageDatasetIdentifier dataset) {
        AbsoluteImageReference image = imageAccessor.tryFindAnyOriginalImage();
        if (image != null) {
            return image.getUnchangedImage();
        }
        throw new IllegalStateException("Cannot find any image in a dataset: " + dataset);
    }

    @Override
    public List<FeatureVectorDataset> loadFeatures(String sessionToken, List<FeatureVectorDatasetReference> featureDatasets, List<String> featureNames) {
        List<String> codes = this.normalize(featureNames);
        ArrayList<FeatureVectorDataset> result = new ArrayList<FeatureVectorDataset>();
        FeatureVectorLoader.IMetadataProvider metadataProvider = FeatureVectorLoaderMetadataProviderFactory.createMetadataProviderFromFeatureVectors(this.getOpenBISService(), featureDatasets);
        this.prefetchSampleIdentifiers(featureDatasets, metadataProvider);
        for (FeatureVectorDatasetReference dataset : featureDatasets) {
            result.add(this.createFeatureVectorDataset(sessionToken, dataset, codes, metadataProvider));
        }
        return result;
    }

    private void prefetchSampleIdentifiers(List<FeatureVectorDatasetReference> featureDatasets, FeatureVectorLoader.IMetadataProvider metadataProvider) {
        LinkedList<String> dataSetIds = new LinkedList<String>();
        for (FeatureVectorDatasetReference featureVectorDatasetReference : featureDatasets) {
            dataSetIds.add(featureVectorDatasetReference.getDatasetCode());
            dataSetIds.addAll(metadataProvider.tryGetContainedDatasets(featureVectorDatasetReference.getDatasetCode()));
        }
        List<ImgAnalysisDatasetDTO> dataSets = this.getDAO().listAnalysisDatasetsByPermId(dataSetIds.toArray(new String[0]));
        long[] containerIds = new long[dataSets.size()];
        int i = 0;
        for (ImgAnalysisDatasetDTO adto : dataSets) {
            containerIds[i++] = adto.getContainerId();
        }
        List<ImgContainerDTO> containers = this.getDAO().listContainersByIds(containerIds);
        LinkedList<String> samplePermIds = new LinkedList<String>();
        for (ImgContainerDTO container : containers) {
            samplePermIds.add(container.getPermId());
        }
        metadataProvider.getSampleIdentifiers(samplePermIds);
    }

    private FeatureVectorDataset createFeatureVectorDataset(String sessionToken, FeatureVectorDatasetReference dataset, List<String> featureCodes, FeatureVectorLoader.IMetadataProvider metadataProvider) {
        FeatureVectorLoader.WellFeatureCollection<FeatureTableRow> datasetFeatures = FeatureVectorLoader.fetchDatasetFeatures(Arrays.asList(dataset.getDatasetCode()), featureCodes, this.getDAO(), metadataProvider);
        ArrayList<FeatureVector> featureVectors = new ArrayList<FeatureVector>();
        for (FeatureTableRow featureTableRow : datasetFeatures.getFeatures()) {
            WellLocation wellPosition = featureTableRow.getWellLocation();
            double[] values = DssServiceRpcScreening.getFloatFeaturesAsDouble(featureTableRow);
            featureVectors.add(new FeatureVector(DssServiceRpcScreening.convert(wellPosition), values));
        }
        return new FeatureVectorDataset(dataset, datasetFeatures.getFeatureCodes(), datasetFeatures.getFeatureLabels(), featureVectors);
    }

    private static double[] getFloatFeaturesAsDouble(FeatureTableRow featureTableRow) {
        FeatureValue[] featureValues = featureTableRow.getFeatureValues();
        double[] doubleValues = new double[featureValues.length];
        int i = 0;
        while (i < featureValues.length) {
            FeatureValue featureValue = featureValues[i];
            doubleValues[i] = featureValue.isFloat() ? (double)featureValue.asFloat() : Double.NaN;
            ++i;
        }
        return doubleValues;
    }

    private static WellPosition convert(WellLocation wellPosition) {
        return new WellPosition(wellPosition.getRow(), wellPosition.getColumn());
    }

    private List<String> normalize(List<String> names) {
        ArrayList<String> codes = new ArrayList<String>(names.size());
        for (String name : names) {
            codes.add(CodeNormalizer.normalize(name));
        }
        return codes;
    }

    @Override
    public List<FeatureVectorWithDescription> loadFeaturesForDatasetWellReferences(String sessionToken, List<FeatureVectorDatasetWellReference> datasetWellReferences, List<String> featureNames) {
        FeatureVectorLoader.WellFeatureCollection<FeatureTableRow> features = FeatureVectorLoader.fetchWellFeatures(datasetWellReferences, featureNames, this.getDAO(), FeatureVectorLoaderMetadataProviderFactory.createMetadataProviderFromFeatureVectors(this.getOpenBISService(), datasetWellReferences));
        return this.createFeatureVectorList(features);
    }

    private List<FeatureVectorWithDescription> createFeatureVectorList(FeatureVectorLoader.WellFeatureCollection<FeatureTableRow> features) {
        List<String> featureCodes = features.getFeatureCodes();
        List<FeatureTableRow> featureTableRows = features.getFeatures();
        ArrayList<FeatureVectorWithDescription> result = new ArrayList<FeatureVectorWithDescription>(featureTableRows.size());
        for (FeatureTableRow featureTableRow : featureTableRows) {
            result.add(this.createFeatureVector(featureTableRow, featureCodes));
        }
        return result;
    }

    private FeatureVectorWithDescription createFeatureVector(FeatureTableRow featureTableRow, List<String> featureCodes) {
        return new FeatureVectorWithDescription(featureTableRow.getReference(), featureCodes, DssServiceRpcScreening.getFloatFeaturesAsDouble(featureTableRow));
    }

    @Override
    public InputStream loadImages(String sessionToken, List<PlateImageReference> imageReferences, boolean convertToPng) {
        return this.loadImages(sessionToken, imageReferences, null, null, convertToPng);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences, boolean convertToPng) {
        return this.convertToBase64(this.loadImages(sessionToken, imageReferences, convertToPng));
    }

    @Override
    public InputStream loadImages(String sessionToken, List<PlateImageReference> imageReferences, ImageSize thumbnailSizeOrNull) {
        return this.loadImages(sessionToken, imageReferences, this.tryAsSize(thumbnailSizeOrNull), null, true);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences, ImageSize size) {
        return this.convertToBase64(this.loadImages(sessionToken, imageReferences, size));
    }

    @Override
    public InputStream loadImages(String sessionToken, List<PlateImageReference> imageReferences, LoadImageConfiguration configuration) {
        Map<String, IImagingDatasetLoader> imageLoadersMap = this.getImageDatasetsMap(sessionToken, imageReferences);
        return this.loadImages(imageReferences, this.tryAsSize(configuration.getDesiredImageSize()), configuration.getSingleChannelImageTransformationCode(), configuration.isDesiredImageFormatPng(), configuration.isOpenBisImageTransformationApplied(), imageLoadersMap);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences, LoadImageConfiguration configuration) {
        return this.convertToBase64(this.loadImages(sessionToken, imageReferences, configuration));
    }

    @Override
    public InputStream loadImages(String sessionToken, List<PlateImageReference> imageReferences, final ImageRepresentationFormat format) {
        for (PlateImageReference plateImageReference : imageReferences) {
            if (plateImageReference.getDatasetCode().equals(format.getDataSetCode())) continue;
            throw new UserFailureException("At least for one plate image reference the image representation format is unknown: Plate image reference: " + plateImageReference + ", format: " + format);
        }
        AbstractFormatSelectionCriterion criterion = new AbstractFormatSelectionCriterion(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean accept(ImageRepresentationFormat availableFormat) {
                return format.getId() == availableFormat.getId();
            }
        };
        return this.loadImages(sessionToken, imageReferences, criterion);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences, ImageRepresentationFormat format) {
        return this.convertToBase64(this.loadImages(sessionToken, imageReferences, format));
    }

    @Override
    public InputStream loadImages(String sessionToken, List<PlateImageReference> imageReferences, IImageRepresentationFormatSelectionCriterion ... criteria) {
        Map<String, IImagingDatasetLoader> imageLoadersMap = this.getImageDatasetsMap(sessionToken, imageReferences);
        Map<String, ImgImageDatasetDTO> imageDataSetMap = this.createDataSetCodeToImageDataSetMap(imageReferences);
        ImageRepresentationFormatFinder finder = new ImageRepresentationFormatFinder(criteria);
        HashMap<String, ImageRepresentationFormat> dataSetToImageReferenceFormatMap = new HashMap<String, ImageRepresentationFormat>();
        for (Map.Entry<String, ImgImageDatasetDTO> entry : imageDataSetMap.entrySet()) {
            String dataSetCode = entry.getKey();
            List<ImageRepresentationFormat> filteredFormats = finder.find(RepresentationUtil.getImageRepresentationFormats(entry.getValue(), this.getDAO()));
            if (filteredFormats.isEmpty()) {
                throw new UserFailureException("No image representation format fitting criteria found for data set " + dataSetCode + ".");
            }
            if (filteredFormats.size() > 1) {
                throw new UserFailureException("To many image representation formats fitting criteria for data set " + dataSetCode + ": " + filteredFormats);
            }
            dataSetToImageReferenceFormatMap.put(dataSetCode, filteredFormats.get(0));
        }
        ArrayList<IHierarchicalContentNode> imageContents = new ArrayList<IHierarchicalContentNode>();
        for (PlateImageReference imageReference : imageReferences) {
            String datasetCode = imageReference.getDatasetCode();
            IImagingDatasetLoader loader = imageLoadersMap.get(datasetCode);
            ImageRepresentationFormat format = (ImageRepresentationFormat)dataSetToImageReferenceFormatMap.get(datasetCode);
            Size size = new Size(format.getWidth(), format.getHeight());
            this.addImageContentTo(imageContents, loader, imageReference, size, null, false, false);
        }
        return new ConcatenatedContentInputStream(true, imageContents);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences, IImageRepresentationFormatSelectionCriterion ... criteria) {
        return this.convertToBase64(this.loadImages(sessionToken, imageReferences, criteria));
    }

    private InputStream loadImages(String sessionToken, List<PlateImageReference> imageReferences, Size sizeOrNull, String singleChannelImageTransformationCodeOrNull, boolean convertToPng) {
        Map<String, IImagingDatasetLoader> imageLoadersMap = this.getImageDatasetsMap(sessionToken, imageReferences);
        return this.loadImages(imageReferences, sizeOrNull, singleChannelImageTransformationCodeOrNull, convertToPng, false, imageLoadersMap);
    }

    private InputStream loadImages(List<PlateImageReference> imageReferences, Size sizeOrNull, String singleChannelImageTransformationCodeOrNull, boolean convertToPng, boolean transform, Map<String, IImagingDatasetLoader> imageLoadersMap) {
        ArrayList<IHierarchicalContentNode> imageContents = new ArrayList<IHierarchicalContentNode>();
        for (PlateImageReference imageReference : imageReferences) {
            IImagingDatasetLoader imageAccessor = imageLoadersMap.get(imageReference.getDatasetCode());
            assert (imageAccessor != null) : "imageAccessor not found for: " + imageReference;
            this.addImageContentTo(imageContents, imageAccessor, imageReference, sizeOrNull, singleChannelImageTransformationCodeOrNull, convertToPng, transform);
        }
        return new ConcatenatedContentInputStream(true, imageContents);
    }

    private void addImageContentTo(List<IHierarchicalContentNode> imageContents, IImagingDatasetLoader imageAccessor, PlateImageReference imageReference, Size sizeOrNull, String singleChannelImageTransformationCodeOrNull, boolean convertToPng, boolean transform) {
        IImagingLoaderStrategy imageLoaderStrategy = ImagingLoaderStrategyFactory.createImageLoaderStrategy(imageAccessor);
        ImageChannelStackReference channelStackRef = DssServiceRpcScreening.getImageChannelStackReference(imageAccessor, imageReference);
        String channelCode = imageReference.getChannel();
        imageContents.add(new HierarchicalContentNodeBasedHierarchicalContentNode(this.tryGetImageContent(imageLoaderStrategy, channelStackRef, channelCode, sizeOrNull, singleChannelImageTransformationCodeOrNull, convertToPng, transform)));
    }

    private InputStream loadThumbnailImages(List<PlateImageReference> imageReferences, Map<String, IImagingDatasetLoader> imageLoadersMap) {
        ArrayList<IHierarchicalContentNode> imageContents = new ArrayList<IHierarchicalContentNode>();
        for (PlateImageReference imageReference : imageReferences) {
            IImagingDatasetLoader imageAccessor = imageLoadersMap.get(imageReference.getDatasetCode());
            assert (imageAccessor != null) : "imageAccessor not found for: " + imageReference;
            IImagingLoaderStrategy imageLoaderStrategy = ImagingLoaderStrategyFactory.createThumbnailLoaderStrategy(imageAccessor);
            ImageChannelStackReference channelStackRef = DssServiceRpcScreening.getImageChannelStackReference(imageAccessor, imageReference);
            String channelCode = imageReference.getChannel();
            imageContents.add(new HierarchicalContentNodeBasedHierarchicalContentNode(this.tryGetImageContent(imageLoaderStrategy, channelStackRef, channelCode, null, null, false, false)));
        }
        return new ConcatenatedContentInputStream(true, imageContents);
    }

    @Override
    public InputStream loadImages(String sessionToken, List<PlateImageReference> imageReferences) {
        return this.loadImages(sessionToken, imageReferences, true);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, List<PlateImageReference> imageReferences) {
        return this.convertToBase64(this.loadImages(sessionToken, imageReferences));
    }

    @Override
    public InputStream loadImages(String sessionToken, IDatasetIdentifier dataSetIdentifier, List<WellPosition> wellPositions, String channel, ImageSize thumbnailSizeOrNull) {
        IImagingDatasetLoader imageAccessor = this.createImageLoader(sessionToken, dataSetIdentifier);
        List<PlateImageReference> imageReferences = this.createPlateImageReferences(imageAccessor, dataSetIdentifier, wellPositions, channel);
        Size size = this.tryAsSize(thumbnailSizeOrNull);
        HashMap<String, IImagingDatasetLoader> imageLoadersMap = new HashMap<String, IImagingDatasetLoader>();
        imageLoadersMap.put(dataSetIdentifier.getDatasetCode(), imageAccessor);
        return this.loadImages(imageReferences, size, null, true, false, imageLoadersMap);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, IDatasetIdentifier dataSetIdentifier, List<WellPosition> wellPositions, String channel, ImageSize thumbnailSizeOrNull) {
        return this.convertToBase64(this.loadImages(sessionToken, dataSetIdentifier, wellPositions, channel, thumbnailSizeOrNull));
    }

    @Override
    public InputStream loadThumbnailImages(String sessionToken, List<PlateImageReference> imageReferences) {
        Map<String, IImagingDatasetLoader> imageLoadersMap = this.getImageDatasetsMap(sessionToken, imageReferences);
        return this.loadThumbnailImages(imageReferences, imageLoadersMap);
    }

    @Override
    public List<String> loadThumbnailImagesBase64(String sessionToken, List<PlateImageReference> imageReferences) {
        return this.convertToBase64(this.loadThumbnailImages(sessionToken, imageReferences));
    }

    @Override
    public InputStream loadImages(String sessionToken, IDatasetIdentifier dataSetIdentifier, String channel, ImageSize thumbnailSizeOrNull) {
        IImagingDatasetLoader imageAccessor = this.createImageLoader(sessionToken, dataSetIdentifier);
        List<MicroscopyImageReference> imageReferences = this.listImageReferences(dataSetIdentifier, channel, imageAccessor);
        Size sizeOrNull = this.tryAsSize(thumbnailSizeOrNull);
        ArrayList<IHierarchicalContentNode> imageContents = new ArrayList<IHierarchicalContentNode>();
        for (MicroscopyImageReference imageReference : imageReferences) {
            ImageChannelStackReference channelStackRef = this.getImageChannelStackReference(imageAccessor, imageReference);
            String channelCode = imageReference.getChannel();
            imageContents.add(new HierarchicalContentNodeBasedHierarchicalContentNode(this.tryGetImageContent(ImagingLoaderStrategyFactory.createImageLoaderStrategy(imageAccessor), channelStackRef, channelCode, sizeOrNull, null, true, false)));
        }
        return new ConcatenatedContentInputStream(true, imageContents);
    }

    @Override
    public List<String> loadImagesBase64(String sessionToken, IDatasetIdentifier dataSetIdentifier, String channel, ImageSize thumbnailSizeOrNull) {
        return this.convertToBase64(this.loadImages(sessionToken, dataSetIdentifier, channel, thumbnailSizeOrNull));
    }

    @Override
    public InputStream loadThumbnailImages(String sessionToken, IDatasetIdentifier dataSetIdentifier, List<String> channels) {
        IImagingDatasetLoader imageAccessor = this.createImageLoader(sessionToken, dataSetIdentifier);
        assert (imageAccessor != null) : "imageAccessor not found for: " + dataSetIdentifier;
        List<MicroscopyImageReference> imageReferences = this.listImageReferences(dataSetIdentifier, channels, imageAccessor);
        ArrayList<IHierarchicalContentNode> imageContents = new ArrayList<IHierarchicalContentNode>();
        for (MicroscopyImageReference imageReference : imageReferences) {
            IImagingLoaderStrategy imageLoaderStrategy = ImagingLoaderStrategyFactory.createThumbnailLoaderStrategy(imageAccessor);
            ImageChannelStackReference channelStackRef = this.getImageChannelStackReference(imageAccessor, imageReference);
            String channelCode = imageReference.getChannel();
            imageContents.add(new HierarchicalContentNodeBasedHierarchicalContentNode(this.tryGetImageContent(imageLoaderStrategy, channelStackRef, channelCode, null, null, false, false)));
        }
        return new ConcatenatedContentInputStream(true, imageContents);
    }

    @Override
    public List<String> loadThumbnailImagesBase64(String sessionToken, IDatasetIdentifier dataSetIdentifier, List<String> channels) {
        return this.convertToBase64(this.loadThumbnailImages(sessionToken, dataSetIdentifier, channels));
    }

    @Override
    public List<String> loadPhysicalThumbnailsBase64(String sessionToken, List<PlateImageReference> imageReferences, ImageRepresentationFormat format) {
        return this.convertToBase64(this.loadPhysicalThumbnails(sessionToken, imageReferences, format));
    }

    @Override
    public InputStream loadPhysicalThumbnails(String sessionToken, List<PlateImageReference> imageReferences, final ImageRepresentationFormat format) {
        for (PlateImageReference plateImageReference : imageReferences) {
            if (plateImageReference.getDatasetCode().equals(format.getDataSetCode())) continue;
            throw new UserFailureException("At least for one plate image reference the image representation format is unknown: Plate image reference: " + plateImageReference + ", format: " + format);
        }
        AbstractFormatSelectionCriterion criterion = new AbstractFormatSelectionCriterion(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean accept(ImageRepresentationFormat availableFormat) {
                return format.getId() == availableFormat.getId();
            }
        };
        return this.loadPhysicalThumbnails(sessionToken, imageReferences, criterion);
    }

    public InputStream loadPhysicalThumbnails(String sessionToken, List<PlateImageReference> imageReferences, IImageRepresentationFormatSelectionCriterion ... criteria) {
        Map<String, IImagingDatasetLoader> imageLoadersMap = this.getImageDatasetsMap(sessionToken, imageReferences);
        Map<String, ImgImageDatasetDTO> imageDataSetMap = this.createDataSetCodeToImageDataSetMap(imageReferences);
        ImageRepresentationFormatFinder finder = new ImageRepresentationFormatFinder(criteria);
        HashMap<String, ImageRepresentationFormat> dataSetToImageReferenceFormatMap = new HashMap<String, ImageRepresentationFormat>();
        for (Map.Entry<String, ImgImageDatasetDTO> entry : imageDataSetMap.entrySet()) {
            String dataSetCode = entry.getKey();
            List<ImageRepresentationFormat> filteredFormats = finder.find(RepresentationUtil.getImageRepresentationFormats(entry.getValue(), this.getDAO()));
            if (filteredFormats.isEmpty()) {
                throw new UserFailureException("No image representation format fitting criteria found for data set " + dataSetCode + ".");
            }
            if (filteredFormats.size() > 1) {
                throw new UserFailureException("To many image representation formats fitting criteria for data set " + dataSetCode + ": " + filteredFormats);
            }
            dataSetToImageReferenceFormatMap.put(dataSetCode, filteredFormats.get(0));
        }
        ArrayList<IHierarchicalContentNode> imageContents = new ArrayList<IHierarchicalContentNode>();
        for (PlateImageReference imageReference : imageReferences) {
            IHierarchicalContentNode content;
            String datasetCode = imageReference.getDatasetCode();
            IImagingDatasetLoader loader = imageLoadersMap.get(datasetCode);
            ImageRepresentationFormat format = (ImageRepresentationFormat)dataSetToImageReferenceFormatMap.get(datasetCode);
            Size size = new Size(format.getWidth(), format.getHeight());
            String transformation = this.tryGetTransformation(imageReference, format);
            ImageChannelStackReference channelStackRef = DssServiceRpcScreening.getImageChannelStackReference(loader, imageReference);
            AbsoluteImageReference imr = loader.tryGetThumbnail(imageReference.getChannel(), channelStackRef, new RequestedImageSize(size, false, false), transformation);
            IHierarchicalContentNode iHierarchicalContentNode = content = imr != null ? imr.tryGetRawContent() : null;
            if (content == null) {
                throw new UserFailureException("Couldn't fetch the image as raw content, as it is only a partial content of an image");
            }
            imageContents.add(content);
        }
        return new ConcatenatedContentInputStream(true, imageContents);
    }

    protected String tryGetTransformation(PlateImageReference imageReference, ImageRepresentationFormat format) {
        for (ImageRepresentationFormat.ImageRepresentationTransformation t : format.getTransformations()) {
            if (!t.getChannelCode().equals(imageReference.getChannel())) continue;
            return t.getTransformationCode();
        }
        return null;
    }

    @Override
    public List<MicroscopyImageReference> listImageReferences(String sessionToken, IDatasetIdentifier dataSetIdentifier, String channel) {
        IImagingDatasetLoader imageAccessor = this.createImageLoader(sessionToken, dataSetIdentifier);
        return this.listImageReferences(dataSetIdentifier, channel, imageAccessor);
    }

    @Override
    public List<MicroscopyImageReference> listImageReferences(String sessionToken, IDatasetIdentifier dataSetIdentifier, List<String> channels) {
        IImagingDatasetLoader imageAccessor = this.createImageLoader(sessionToken, dataSetIdentifier);
        return this.listImageReferences(dataSetIdentifier, channels, imageAccessor);
    }

    private List<MicroscopyImageReference> listImageReferences(IDatasetIdentifier dataSetIdentifier, String channel, IImagingDatasetLoader imageAccessor) {
        int numberOfTiles = this.getNumberOfTiles(imageAccessor);
        ArrayList<MicroscopyImageReference> imageReferences = new ArrayList<MicroscopyImageReference>();
        int i = 0;
        while (i < numberOfTiles) {
            imageReferences.add(new MicroscopyImageReference(i, channel, dataSetIdentifier));
            ++i;
        }
        return imageReferences;
    }

    private List<MicroscopyImageReference> listImageReferences(IDatasetIdentifier dataSetIdentifier, List<String> channels, IImagingDatasetLoader imageAccessor) {
        int numberOfTiles = this.getNumberOfTiles(imageAccessor);
        ArrayList<MicroscopyImageReference> imageReferences = new ArrayList<MicroscopyImageReference>(numberOfTiles * channels.size());
        int i = 0;
        while (i < numberOfTiles) {
            for (String channel : channels) {
                imageReferences.add(new MicroscopyImageReference(i, channel, dataSetIdentifier));
            }
            ++i;
        }
        return imageReferences;
    }

    @Override
    public List<PlateImageReference> listPlateImageReferences(String sessionToken, IDatasetIdentifier dataSetIdentifier, List<WellPosition> wellPositions, String channel) {
        IImagingDatasetLoader imageAccessor = this.createImageLoader(sessionToken, dataSetIdentifier);
        return this.createPlateImageReferences(imageAccessor, dataSetIdentifier, wellPositions, channel);
    }

    @Override
    public List<PlateImageReference> listPlateImageReferences(String sessionToken, IDatasetIdentifier dataSetIdentifier, List<WellPosition> wellPositions, List<String> channels) {
        IImagingDatasetLoader imageAccessor = this.createImageLoader(sessionToken, dataSetIdentifier);
        return this.createPlateImageReferences(imageAccessor, dataSetIdentifier, wellPositions, channels);
    }

    @Override
    public List<DatasetImageRepresentationFormats> listAvailableImageRepresentationFormats(String sessionToken, List<? extends IDatasetIdentifier> imageDatasets) {
        ArrayList<DatasetImageRepresentationFormats> result = new ArrayList<DatasetImageRepresentationFormats>(imageDatasets.size());
        Map<String, ImgImageDatasetDTO> imageDataSetMap = this.createDataSetCodeToImageDataSetMap(imageDatasets);
        for (IDatasetIdentifier iDatasetIdentifier : imageDatasets) {
            DatasetImageRepresentationFormats datasetResult;
            String dataSetCode = iDatasetIdentifier.getPermId();
            ImgImageDatasetDTO primImageDataSet = imageDataSetMap.get(dataSetCode);
            if (primImageDataSet == null) {
                List<ImageRepresentationFormat> emptyList = Collections.emptyList();
                datasetResult = new DatasetImageRepresentationFormats(iDatasetIdentifier, emptyList);
                result.add(datasetResult);
                continue;
            }
            List<ImageRepresentationFormat> formats = RepresentationUtil.getImageRepresentationFormats(primImageDataSet, this.getDAO());
            datasetResult = new DatasetImageRepresentationFormats(iDatasetIdentifier, formats);
            result.add(datasetResult);
        }
        return result;
    }

    private Map<String, ImgImageDatasetDTO> createDataSetCodeToImageDataSetMap(List<? extends IDatasetIdentifier> imageDatasets) {
        HashSet<String> permIds = new HashSet<String>();
        for (IDatasetIdentifier iDatasetIdentifier : imageDatasets) {
            permIds.add(iDatasetIdentifier.getPermId());
        }
        List<ImgImageDatasetDTO> list = this.getDAO().listImageDatasetsByPermId(permIds.toArray(new String[permIds.size()]));
        HashMap<String, ImgImageDatasetDTO> imageDataSetMap = new HashMap<String, ImgImageDatasetDTO>();
        for (ImgImageDatasetDTO primImageDataSet : list) {
            imageDataSetMap.put(primImageDataSet.getPermId(), primImageDataSet);
        }
        return imageDataSetMap;
    }

    private IImagingDatasetLoader createImageLoader(String sessionToken, IDatasetIdentifier dataSetIdentifier) {
        String datasetCode = dataSetIdentifier.getDatasetCode();
        return this.createImageLoader(sessionToken, datasetCode);
    }

    @Override
    public void saveImageTransformerFactory(String sessionToken, List<IDatasetIdentifier> dataSetIdentifiers, String channel, IImageTransformerFactory transformerFactory) {
        for (IDatasetIdentifier datasetIdentifier : dataSetIdentifiers) {
            ImgImageDatasetDTO dataset = this.getImagingImageDataset(datasetIdentifier);
            if (dataset == null) {
                throw new UserFailureException("Unkown data set " + datasetIdentifier);
            }
            if (this.dao.hasDatasetChannels(dataset.getPermId())) {
                this.saveImageTransformerFactoryForDataset(dataset.getId(), channel, transformerFactory);
                continue;
            }
            Long containerId = dataset.getContainerId();
            ImgContainerDTO container = this.getDAO().getContainerById(containerId);
            this.saveImageTransformerFactoryForExperiment(container.getExperimentId(), channel, transformerFactory);
        }
        this.transformerDAO.commit();
    }

    private static boolean isMergedChannel(String channel) {
        return "Merged Channels".equals(channel);
    }

    private void saveImageTransformerFactoryForExperiment(long experimentId, String channel, IImageTransformerFactory transformerFactory) {
        if (DssServiceRpcScreening.isMergedChannel(channel)) {
            if (this.operationLog.isInfoEnabled()) {
                this.operationLog.info((Object)("save image transformer factory " + transformerFactory + " for experiment " + experimentId));
            }
            this.transformerDAO.saveTransformerFactoryForExperiment(experimentId, transformerFactory);
        } else {
            if (this.operationLog.isInfoEnabled()) {
                this.operationLog.info((Object)("save image transformer factory " + transformerFactory + " for experiment " + experimentId + " and channel '" + channel + "'."));
            }
            Long channelId = this.transformerDAO.getExperimentChannelId(experimentId, channel);
            this.createOrUpdateImageViewerTransformation(channelId, transformerFactory);
        }
    }

    private void createOrUpdateImageViewerTransformation(long channelId, IImageTransformerFactory transformerFactory) {
        Long transformationIdOrNull = this.transformerDAO.tryGetImageTransformationId(channelId, IMAGE_VIEWER_TRANSFORMATION_CODE);
        if (transformationIdOrNull == null) {
            this.transformerDAO.addImageTransformation(this.createImageViewerTransformation(channelId, transformerFactory));
        } else if (transformerFactory != null) {
            this.transformerDAO.updateImageTransformerFactory(transformationIdOrNull, transformerFactory);
        } else {
            this.transformerDAO.removeImageTransformation(transformationIdOrNull);
        }
    }

    private ImgImageTransformationDTO createImageViewerTransformation(long channelId, IImageTransformerFactory transformerFactory) {
        return new ImgImageTransformationDTO(IMAGE_VIEWER_TRANSFORMATION_CODE, IMAGE_VIEWER_TRANSFORMATION_LABEL, IMAGE_VIEWER_TRANSFORMATION_DESCRIPTION, false, channelId, transformerFactory, true);
    }

    private void saveImageTransformerFactoryForDataset(long datasetId, String channel, IImageTransformerFactory transformerFactory) {
        if (DssServiceRpcScreening.isMergedChannel(channel)) {
            if (this.operationLog.isInfoEnabled()) {
                this.operationLog.info((Object)("save image transformer factory " + transformerFactory + " for dataset " + datasetId));
            }
            this.transformerDAO.saveTransformerFactoryForImageDataset(datasetId, transformerFactory);
        } else {
            if (this.operationLog.isInfoEnabled()) {
                this.operationLog.info((Object)("save image transformer factory " + transformerFactory + " for dataset " + datasetId + " and channel '" + channel + "'."));
            }
            long channelId = this.transformerDAO.getDatasetChannelId(datasetId, channel);
            this.createOrUpdateImageViewerTransformation(channelId, transformerFactory);
        }
    }

    @Override
    public IImageTransformerFactory getImageTransformerFactoryOrNull(String sessionToken, List<IDatasetIdentifier> dataSetIdentifiers, String channel) {
        Set<String> experimentPermIDs;
        if (dataSetIdentifiers.size() == 1) {
            IDatasetIdentifier datasetIdentifier = dataSetIdentifiers.get(0);
            if (this.getDAO().hasDatasetChannels(datasetIdentifier.getPermId())) {
                return this.tryGetImageTransformerFactoryForDataset(datasetIdentifier, channel);
            }
        }
        if ((experimentPermIDs = this.getExperimentPermIDs(sessionToken, dataSetIdentifiers)).isEmpty()) {
            throw new UserFailureException("No data set identifers specified.");
        }
        if (experimentPermIDs.size() > 1) {
            throw new UserFailureException("All data sets have to belong to the same experiment: " + dataSetIdentifiers);
        }
        String experimentPermID = experimentPermIDs.iterator().next();
        return this.tryGetImageTransformerFactoryForExperiment(experimentPermID, channel);
    }

    private Set<String> getExperimentPermIDs(String sessionToken, List<IDatasetIdentifier> dataSetIdentifiers) {
        HashSet<String> experimentPermIDs = new HashSet<String>();
        for (IDatasetIdentifier dataSetIdentifier : dataSetIdentifiers) {
            AbstractExternalData dataSet = this.getOpenBISService().tryGetDataSet(sessionToken, dataSetIdentifier.getDatasetCode());
            if (dataSet == null) {
                throw new UserFailureException("Unkown data set " + dataSetIdentifier);
            }
            experimentPermIDs.add(dataSet.getExperiment().getPermId());
        }
        return experimentPermIDs;
    }

    private IImageTransformerFactory tryGetImageTransformerFactoryForDataset(IDatasetIdentifier datasetIdentifier, String channel) {
        ImgImageDatasetDTO dataset = this.getImagingImageDataset(datasetIdentifier);
        if (DssServiceRpcScreening.isMergedChannel(channel)) {
            return dataset.tryGetImageTransformerFactory();
        }
        long channelId = this.getDAO().getDatasetChannelId(dataset.getId(), channel);
        return this.tryGetImageViewerTransformation(channelId);
    }

    private IImageTransformerFactory tryGetImageViewerTransformation(long channelId) {
        ImgImageTransformationDTO transformation = this.getDAO().tryGetImageTransformation(channelId, IMAGE_VIEWER_TRANSFORMATION_CODE);
        if (transformation == null) {
            return null;
        }
        return transformation.getImageTransformerFactory();
    }

    private IImageTransformerFactory tryGetImageTransformerFactoryForExperiment(String experimentPermID, String channel) {
        if (DssServiceRpcScreening.isMergedChannel(channel)) {
            return this.getDAO().tryGetExperimentByPermId(experimentPermID).tryGetImageTransformerFactory();
        }
        ImgChannelDTO channelDTO = this.getDAO().tryGetChannelForExperimentPermId(experimentPermID, channel);
        assert (channelDTO != null) : String.format("No channel '%s' for experiment '%s'.", channel, experimentPermID);
        return this.tryGetImageViewerTransformation(channelDTO.getId());
    }

    private List<ImgAnalysisDatasetDTO> getAnalysisDatasets(List<? extends IDatasetIdentifier> datasetIdents) {
        String[] permIds = DssServiceRpcScreening.extractPermIds(datasetIdents);
        List<ImgAnalysisDatasetDTO> datasets = this.getDAO().listAnalysisDatasetsByPermId(permIds);
        if (datasets.size() == 0 && datasetIdents.size() > 0) {
            throw new UserFailureException("Couldn't find any analysis dataset for given datasets: " + Arrays.asList(permIds));
        }
        return datasets;
    }

    private static <T extends AbstractImgIdentifiable> long[] extractIds(List<T> dataSets) {
        long[] ids = new long[dataSets.size()];
        int i = 0;
        while (i < ids.length) {
            ids[i] = ((AbstractImgIdentifiable)dataSets.get(i)).getId();
            ++i;
        }
        return ids;
    }

    private static String[] extractPermIds(List<? extends IDatasetIdentifier> datasets) {
        String[] permIds = new String[datasets.size()];
        int i = 0;
        while (i < permIds.length) {
            permIds[i] = datasets.get(i).getDatasetCode();
            ++i;
        }
        return permIds;
    }

    private ImgImageDatasetDTO getImagingImageDataset(IDatasetIdentifier datasetIdentifier) {
        ImgImageDatasetDTO dataset = this.getDAO().tryGetImageDatasetByPermId(datasetIdentifier.getDatasetCode());
        if (dataset == null) {
            throw new UserFailureException("Unknown data set: " + datasetIdentifier.getDatasetCode());
        }
        return dataset;
    }

    private List<PlateImageReference> createPlateImageReferences(IImagingDatasetLoader imageAccessor, IDatasetIdentifier dataSetIdentifier, List<WellPosition> wellPositions, String channel) {
        int numberOfTiles = this.getNumberOfTiles(imageAccessor);
        ArrayList<PlateImageReference> imageReferences = new ArrayList<PlateImageReference>();
        if (wellPositions == null || wellPositions.isEmpty()) {
            int i = 0;
            while (i < numberOfTiles) {
                imageReferences.add(new PlateImageReference(i, channel, null, dataSetIdentifier));
                ++i;
            }
        } else {
            for (WellPosition wellPosition : wellPositions) {
                this.addImageReferencesForAllTiles(imageReferences, wellPosition.getWellRow(), wellPosition.getWellColumn(), channel, dataSetIdentifier, numberOfTiles);
            }
        }
        return imageReferences;
    }

    private List<PlateImageReference> createPlateImageReferences(IImagingDatasetLoader imageAccessor, IDatasetIdentifier dataSetIdentifier, List<WellPosition> wellPositions, List<String> channels) {
        int numberOfTiles = this.getNumberOfTiles(imageAccessor);
        ArrayList<PlateImageReference> imageReferences = new ArrayList<PlateImageReference>();
        if (wellPositions == null || wellPositions.isEmpty()) {
            for (String channel : channels) {
                int i = 0;
                while (i < numberOfTiles) {
                    imageReferences.add(new PlateImageReference(i, channel, null, dataSetIdentifier));
                    ++i;
                }
            }
        } else {
            for (WellPosition wellPosition : wellPositions) {
                for (String channel : channels) {
                    this.addImageReferencesForAllTiles(imageReferences, wellPosition.getWellRow(), wellPosition.getWellColumn(), channel, dataSetIdentifier, numberOfTiles);
                }
            }
        }
        return imageReferences;
    }

    private int getNumberOfTiles(IImagingDatasetLoader imageAccessor) {
        ImageDatasetParameters imageParameters = imageAccessor.getImageParameters();
        int numberOfTiles = imageParameters.getTileRowsNum() * imageParameters.getTileColsNum();
        return numberOfTiles;
    }

    private void addImageReferencesForAllTiles(List<PlateImageReference> imageReferences, int wellRow, int wellColumn, String channel, IDatasetIdentifier dataset, int numberOfTiles) {
        int i = 0;
        while (i < numberOfTiles) {
            imageReferences.add(new PlateImageReference(wellRow, wellColumn, i, channel, dataset));
            ++i;
        }
    }

    private Map<String, IImagingDatasetLoader> getImageDatasetsMap(String sessionToken, List<PlateImageReference> imageReferences) {
        HashMap<String, IImagingDatasetLoader> imageDatasetsMap = new HashMap<String, IImagingDatasetLoader>();
        for (PlateImageReference imageReference : imageReferences) {
            if (imageDatasetsMap.containsKey(imageReference.getDatasetCode())) continue;
            IImagingDatasetLoader imageAccessor = this.tryCreateImageLoader(sessionToken, imageReference.getDatasetCode());
            if (imageAccessor == null) {
                AbstractExternalData imageDataset = this.tryFindImageDataset(sessionToken, imageReference.getDatasetCode());
                if (imageDataset != null) {
                    imageAccessor = this.createImageLoader(sessionToken, imageDataset.getCode());
                } else {
                    throw UserFailureException.fromTemplate("Cannot find an image dataset for the reference: %s", imageReference);
                }
            }
            imageDatasetsMap.put(imageReference.getDatasetCode(), imageAccessor);
        }
        return imageDatasetsMap;
    }

    private IHierarchicalContentNode tryGetImageContent(IImagingLoaderStrategy imageLoaderStrategy, ImageChannelStackReference channelStackReference, String channelCode, Size thumbnailSizeOrNull, String singleChannelImageTransformationCodeOrNull, boolean convertToPng, boolean transform) {
        try {
            return ImageChannelsUtils.getImage(imageLoaderStrategy, channelStackReference, channelCode, thumbnailSizeOrNull, singleChannelImageTransformationCodeOrNull, convertToPng, transform);
        }
        catch (EnvironmentFailureException e) {
            this.operationLog.error((Object)"Error reading image.", (Throwable)e);
            return null;
        }
    }

    private ImageChannelStackReference getImageChannelStackReference(IImagingDatasetLoader imageAccessor, MicroscopyImageReference imageReference) {
        return DssServiceRpcScreening.getMicroscopyImageChannelStackReference(imageAccessor, imageReference.getTile());
    }

    private static ImageChannelStackReference getImageChannelStackReference(IImagingDatasetLoader imageAccessor, PlateImageReference imageRef) {
        int tile = imageRef.getTile();
        if (imageRef.getWellPosition() != null) {
            Location tileLocation = DssServiceRpcScreening.getTileLocation(imageAccessor, tile);
            Location wellLocation = DssServiceRpcScreening.asLocation(imageRef.getWellPosition());
            return ImageChannelStackReference.createHCSFromLocations(wellLocation, tileLocation);
        }
        return DssServiceRpcScreening.getMicroscopyImageChannelStackReference(imageAccessor, tile);
    }

    private static ImageChannelStackReference getMicroscopyImageChannelStackReference(IImagingDatasetLoader imageAccessor, int tileIx) {
        Location tileLocation = DssServiceRpcScreening.getTileLocation(imageAccessor, tileIx);
        return ImageChannelStackReference.createMicroscopyFromLocations(tileLocation);
    }

    private static Location getTileLocation(IImagingDatasetLoader imageAccessor, int tile) {
        return DssServiceRpcScreening.getTileLocation(tile, imageAccessor.getImageParameters().getTileColsNum());
    }

    private static Location getTileLocation(int tile, int tileColumnsNum) {
        int row = tile / tileColumnsNum + 1;
        int col = tile % tileColumnsNum + 1;
        return new Location(col, row);
    }

    private static Location asLocation(WellPosition wellPosition) {
        return new Location(wellPosition.getWellColumn(), wellPosition.getWellRow());
    }

    private Size tryAsSize(ImageSize thumbnailSizeOrNull) {
        if (thumbnailSizeOrNull == null) {
            return null;
        }
        return new Size(thumbnailSizeOrNull.getWidth(), thumbnailSizeOrNull.getHeight());
    }

    private IImagingDatasetLoader tryCreateImageLoader(String sessionToken, String datasetCode) {
        IHierarchicalContent content = this.getHierarchicalContent(sessionToken, datasetCode);
        return this.tryCreateImageLoader(datasetCode, content, false);
    }

    private IImagingDatasetLoader createImageLoader(String sessionToken, String datasetCode) {
        IHierarchicalContent content = this.getHierarchicalContent(sessionToken, datasetCode);
        return this.createImageLoader(datasetCode, content);
    }

    IImagingDatasetLoader createImageLoader(String dataSetCode, IHierarchicalContent content) {
        return this.tryCreateImageLoader(dataSetCode, content, true);
    }

    IImagingDatasetLoader tryCreateImageLoader(String dataSetCode, IHierarchicalContent content, boolean check) {
        IImagingDatasetLoader loader = HCSImageDatasetLoaderFactory.tryCreate(content, dataSetCode);
        if (check && loader == null) {
            throw new IllegalStateException(String.format("Dataset '%s' not found in the imaging database.", dataSetCode));
        }
        return loader;
    }

    private AbstractExternalData tryFindImageDataset(String sessionToken, String datasetCode) {
        AbstractExternalData dataset = this.tryGetDataSet(sessionToken, datasetCode);
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset " + datasetCode + " cannot be found.");
        }
        if (this.isImageDataset(dataset)) {
            return dataset;
        }
        Collection<AbstractExternalData> parents = dataset.getParents();
        if (parents.size() > 1) {
            throw new IllegalArgumentException("Dataset " + datasetCode + " should have at most 1 parent, but has: " + parents.size());
        }
        if (parents.size() == 1) {
            AbstractExternalData parent = parents.iterator().next();
            if (this.isImageDataset(parent)) {
                return parent;
            }
            return null;
        }
        return null;
    }

    private List<String> convertToBase64(InputStream stream) {
        ConcatenatedFileOutputStreamWriter imagesWriter = new ConcatenatedFileOutputStreamWriter(stream);
        ArrayList<String> result = new ArrayList<String>();
        try {
            byte[] bytes = this.extractNextImage(imagesWriter);
            while (bytes.length > 0) {
                result.add(Base64.encodeBytes((byte[])bytes));
                bytes = this.extractNextImage(imagesWriter);
            }
        }
        catch (IOException ex) {
            this.operationLog.error((Object)"Error reading image.", (Throwable)ex);
        }
        return result;
    }

    private byte[] extractNextImage(ConcatenatedFileOutputStreamWriter imagesWriter) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        imagesWriter.writeNextBlock(outputStream);
        return outputStream.toByteArray();
    }

    private boolean isImageDataset(AbstractExternalData dataset) {
        String datasetTypeCode = dataset.getDataSetType().getCode();
        return datasetTypeCode.matches("HCS_IMAGE($|[^_].*|_[^A].*|_A[^N].*|_AN[^A].*)") || datasetTypeCode.matches("MICROSCOPY_IMAGE|.*IMG.*");
    }

    private List<ImgFeatureDefDTO> getFeatureDefinitions(List<? extends IDatasetIdentifier> featureDatasets) {
        List<ImgAnalysisDatasetDTO> dataSets = this.getAnalysisDatasets(featureDatasets);
        return this.getDAO().listFeatureDefsByDataSetIds(DssServiceRpcScreening.extractIds(dataSets));
    }

    private List<ImgFeatureDefDTO> getFeatureDefinitionsWithContained(List<? extends IDatasetIdentifier> featureDatasets) {
        FeatureVectorLoader.IMetadataProvider metadataProvider = FeatureVectorLoaderMetadataProviderFactory.createMetadataProviderFromFeatureVectors(this.getOpenBISService(), featureDatasets);
        ArrayList<IDatasetIdentifier> featureDatasetsWithContained = new ArrayList<IDatasetIdentifier>();
        for (IDatasetIdentifier iDatasetIdentifier : featureDatasets) {
            featureDatasetsWithContained.add(iDatasetIdentifier);
            List<String> containedCodes = metadataProvider.tryGetContainedDatasets(iDatasetIdentifier.getDatasetCode());
            for (String containedCode : containedCodes) {
                featureDatasetsWithContained.add(new DatasetIdentifier(containedCode, iDatasetIdentifier.getDatastoreServerUrl()));
            }
        }
        return this.getFeatureDefinitions(featureDatasetsWithContained);
    }

    private IImagingReadonlyQueryDAO getDAO() {
        return this.dao;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 14;
    }
}

