/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.screening.server.util;

import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVectorLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FeatureVectorLoaderMetadataProviderFactory {
    private static HashMap<String, List<String>> createContainedDatasetMapFromFeatureVectors(IEncapsulatedOpenBISService service, List<? extends IDatasetIdentifier> featureDatasets) {
        LinkedList<String> dsCodes = new LinkedList<String>();
        for (IDatasetIdentifier iDatasetIdentifier : featureDatasets) {
            dsCodes.add(iDatasetIdentifier.getDatasetCode());
        }
        return FeatureVectorLoaderMetadataProviderFactory.createContainedDatasetMap(service, dsCodes);
    }

    private static HashMap<String, List<String>> createContainedDatasetMap(IEncapsulatedOpenBISService service, List<String> dsCodes) {
        List<AbstractExternalData> dataSets = service.listDataSetsByCode(dsCodes);
        HashMap<String, List<String>> containedDataSetsMap = new HashMap<String, List<String>>();
        for (AbstractExternalData dataSet : dataSets) {
            List<String> list = FeatureVectorLoaderMetadataProviderFactory.getContainedDatasets(dataSet);
            containedDataSetsMap.put(dataSet.getCode(), list);
        }
        return containedDataSetsMap;
    }

    private static List<String> getContainedDatasets(AbstractExternalData dataSet) {
        List<String> list;
        ContainerDataSet container = dataSet.tryGetAsContainerDataSet();
        if (container != null) {
            list = new LinkedList();
            for (AbstractExternalData contained : container.getContainedDataSets()) {
                list.add(contained.getCode());
            }
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public static FeatureVectorLoader.IMetadataProvider createMetadataProvider(IEncapsulatedOpenBISService openBISService, List<String> dataSetCodes) {
        return FeatureVectorLoaderMetadataProviderFactory.createMetadataProvider(openBISService, FeatureVectorLoaderMetadataProviderFactory.createContainedDatasetMap(openBISService, dataSetCodes));
    }

    public static FeatureVectorLoader.IMetadataProvider createMetadataProvider(IEncapsulatedOpenBISService openBISService) {
        return new BasicMetadataProvider(openBISService);
    }

    public static FeatureVectorLoader.IMetadataProvider createMetadataProviderFromFeatureVectors(IEncapsulatedOpenBISService openBISService, List<? extends IDatasetIdentifier> featureDatasets) {
        return FeatureVectorLoaderMetadataProviderFactory.createMetadataProvider(openBISService, FeatureVectorLoaderMetadataProviderFactory.createContainedDatasetMapFromFeatureVectors(openBISService, featureDatasets));
    }

    private static FeatureVectorLoader.IMetadataProvider createMetadataProvider(IEncapsulatedOpenBISService openBISService, HashMap<String, List<String>> containedDataSetsMap) {
        return new CachedDatasetsMetadataProvider(openBISService, containedDataSetsMap);
    }

    private static class BasicMetadataProvider
    implements FeatureVectorLoader.IMetadataProvider {
        private final IEncapsulatedOpenBISService openBISService;
        private final HashMap<String, SampleIdentifier> sampleCache = new HashMap();

        public BasicMetadataProvider(IEncapsulatedOpenBISService openBISService) {
            this.openBISService = openBISService;
        }

        @Override
        public void getSampleIdentifiers(List<String> samplePermIds) {
            Map<String, SampleIdentifier> result = this.openBISService.listSampleIdentifiers(samplePermIds);
            this.sampleCache.putAll(result);
        }

        @Override
        public SampleIdentifier tryGetSampleIdentifier(String samplePermId) {
            SampleIdentifier result;
            if (!this.sampleCache.containsKey(samplePermId)) {
                result = this.openBISService.tryGetSampleIdentifier(samplePermId);
                this.sampleCache.put(samplePermId, result);
            } else {
                result = this.sampleCache.get(samplePermId);
            }
            return result;
        }

        @Override
        public List<String> tryGetContainedDatasets(String datasetCode) {
            AbstractExternalData dataSet = this.openBISService.tryGetDataSet(datasetCode);
            return FeatureVectorLoaderMetadataProviderFactory.getContainedDatasets(dataSet);
        }
    }

    private static class CachedDatasetsMetadataProvider
    extends BasicMetadataProvider {
        private final HashMap<String, List<String>> containedDataSetsMap;

        public CachedDatasetsMetadataProvider(IEncapsulatedOpenBISService openBISService, HashMap<String, List<String>> containedDataSetsMap) {
            super(openBISService);
            this.containedDataSetsMap = containedDataSetsMap;
        }

        @Override
        public List<String> tryGetContainedDatasets(String datasetCode) {
            if (this.containedDataSetsMap.containsKey(datasetCode)) {
                return this.containedDataSetsMap.get(datasetCode);
            }
            throw new IllegalArgumentException("Data set code unknown to the provider. " + datasetCode);
        }
    }
}

