/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.customcolumn.core;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.customcolumn.core.CustomColumnJSONClientData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.customcolumn.core.CustomColumnJSONParser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.customcolumn.extension.link.CustomColumnLinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.PrimitiveValue;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;

public class CustomColumnStringRenderer
implements GridCellRenderer<BaseEntityModel<?>> {
    public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
        Object object = model.get(property);
        if (object == null) {
            return "";
        }
        String escapedString = ((PrimitiveValue)object).toString();
        if (this.maybeJSON(escapedString)) {
            String unescapedString = StringEscapeUtils.unescapeHtml(escapedString);
            CustomColumnJSONClientData json = this.parseJSON(unescapedString);
            if (json == null) {
                return this.renderNonJSON(escapedString);
            }
            return this.renderJSON(json);
        }
        return this.renderNonJSON(escapedString);
    }

    private boolean maybeJSON(String string) {
        return string.charAt(0) == '{';
    }

    private CustomColumnJSONClientData parseJSON(String string) {
        return CustomColumnJSONParser.parse(string);
    }

    private Object renderNonJSON(String string) {
        return string;
    }

    private Object renderJSON(CustomColumnJSONClientData data) {
        switch (data.getMethod()) {
            case LINK: {
                return new CustomColumnLinkRenderer(data).render();
            }
        }
        throw new IllegalArgumentException("No render defined for custom column method: " + (Object)((Object)data.getMethod()));
    }
}

