/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.amc.AddRoleAssignmentDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.List;

public class RoleAssignmentGrid
extends TypedTableGrid<RoleAssignment> {
    public static final String BROWSER_ID = "openbis_role-browser";
    public static final String GRID_ID = "openbis_role-browser-grid";
    public static final String ASSIGN_BUTTON_ID = "openbis_role-browser_assign-button";

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        RoleAssignmentGrid grid = new RoleAssignmentGrid(viewContext);
        grid.extendBottomToolbar();
        return grid.asDisposableWithoutToolbar();
    }

    private RoleAssignmentGrid(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.ROLE_ASSIGNMENT_BROWSER_GRID);
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addGroupButton = new Button(this.viewContext.getMessage("button_assign_role", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                AddRoleAssignmentDialog dialog = new AddRoleAssignmentDialog(RoleAssignmentGrid.this.viewContext, RoleAssignmentGrid.this.createRefreshGridAction());
                dialog.show();
            }
        });
        addGroupButton.setId(ASSIGN_BUTTON_ID);
        this.addButton(addGroupButton);
        Button removeRoleButton = this.createSelectedItemButton(this.viewContext.getMessage("button_release_role_assignment", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<RoleAssignment>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<RoleAssignment>> selectedItem, boolean keyPressed) {
                RoleAssignment assignment = selectedItem.getBaseObject().getObjectOrNull();
                new RemoveRoleDialog(assignment).show();
            }
        });
        this.addButton(removeRoleButton);
        this.addEntityOperationsSeparator();
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<RoleAssignment>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<RoleAssignment>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listRoleAssignments(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<RoleAssignment>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportRoleAssignments(exportCriteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("AUTHORIZATION_GROUP", "DATABASE_INSTANCE", "PERSON", "ROLE", "SPACE");
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.ROLE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.ROLE_ASSIGNMENT)};
    }

    class RemoveRoleDialog
    extends ConfirmationDialog {
        private final RoleAssignment selectedRoleAssignment;

        public RemoveRoleDialog(RoleAssignment selectedRoleAssignment) {
            super(RoleAssignmentGrid.this.viewContext.getMessage("confirm_role_removal_title", new Object[0]), RoleAssignmentGrid.this.viewContext.getMessage("confirm_role_removal_msg", new Object[0]));
            this.selectedRoleAssignment = selectedRoleAssignment;
        }

        private void deleteRole() {
            Grantee grantee;
            AbstractAsyncCallback<Void> roleListRefreshCallback = new AbstractAsyncCallback<Void>(RoleAssignmentGrid.this.viewContext){

                @Override
                public void process(Void result) {
                    RoleAssignmentGrid.this.asActionInvoker().refresh();
                }
            };
            Person person = this.selectedRoleAssignment.getPerson();
            Grantee grantee2 = grantee = person != null && !StringUtils.isBlank(person.getUserId()) ? Grantee.createPerson(person.getUserId()) : Grantee.createAuthorizationGroup(this.selectedRoleAssignment.getAuthorizationGroup().getCode());
            if (this.selectedRoleAssignment.getSpace() == null) {
                ((ICommonClientServiceAsync)RoleAssignmentGrid.this.viewContext.getService()).deleteInstanceRole(this.selectedRoleAssignment.getRoleSetCode(), grantee, (AsyncCallback<Void>)roleListRefreshCallback);
            } else {
                ((ICommonClientServiceAsync)RoleAssignmentGrid.this.viewContext.getService()).deleteSpaceRole(this.selectedRoleAssignment.getRoleSetCode(), this.selectedRoleAssignment.getSpace().getCode(), grantee, (AsyncCallback<Void>)roleListRefreshCallback);
            }
        }

        @Override
        protected void onYes() {
            this.deleteRole();
        }
    }
}

