/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GenericConstants;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IGenericImageBundle;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ShowRelatedDatasetsDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.VoidAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplaySettingsManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplaySettingsGetter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.MaterialRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.MultilineStringCellRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.RealNumberRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.TimestampStringCellRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.VocabularyTermStringCellRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.customcolumn.core.CustomColumnStringRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.ColumnSettingsConfigurer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.ComponentEventLogger;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGridColumnDefinitionUI;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.IColumnDefinitionUI;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.specific.GridCustomColumnDefinition;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.BrowserGridPagingToolBar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDataModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.CustomColumnsMetadataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ExtendedGridView;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IColumnDefinitionProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisplayTypeIDProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IModification;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ModificationsData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.PendingFetchManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.TableExportType;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter.FilterToolbar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityEditorTabClickListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridCustomColumnInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridFilters;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IUpdateResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.RelatedDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetFetchConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleDateRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ColumnSetting;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DateTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SortInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebClientConfiguration;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BasePagingLoadConfig;
import com.extjs.gxt.ui.client.data.BasePagingLoadResult;
import com.extjs.gxt.ui.client.data.BasePagingLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.Loader;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadConfig;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.PagingLoader;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Container;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.InfoConfig;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.EditorGrid;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TypedTableGrid<T extends Serializable>
extends LayoutContainer
implements IDatabaseModificationObserver,
IDisplayTypeIDProvider,
IColumnDefinitionProvider<TableModelRowWithObject<T>> {
    private static final IGenericImageBundle IMAGE_BUNDLE = (IGenericImageBundle)GWT.create(IGenericImageBundle.class);
    public static final String GRID_POSTFIX = "-grid";
    private static final int MAX_SHOWN_COLUMNS = 200;
    protected final IViewContext<ICommonClientServiceAsync> viewContext;
    protected final ICellListener<TableModelRowWithObject<T>> showEntityViewerLinkClickListener;
    protected final TableModificationsManager tableModificationsManager;
    private static final int PAGE_SIZE = 50;
    private static final boolean DEBUG = false;
    private final PagingLoader<PagingLoadResult<BaseEntityModel<TableModelRowWithObject<T>>>> pagingLoader;
    private final ContentPanel contentPanel;
    private final Grid<BaseEntityModel<TableModelRowWithObject<T>>> grid;
    private final ColumnListener<TableModelRowWithObject<T>, BaseEntityModel<TableModelRowWithObject<T>>> columnListener;
    private final boolean refreshAutomatically;
    private final BrowserGridPagingToolBar pagingToolbar;
    private final FilterToolbar<TableModelRowWithObject<T>> filterToolbar;
    private final ToolBar modificationsToolbar;
    private final IDisplayTypeIDGenerator displayTypeIDGenerator;
    private Set<IColumnDefinition<TableModelRowWithObject<T>>> columnDefinitions;
    private final CustomColumnsMetadataProvider customColumnsMetadataProvider;
    private String resultSetKeyOrNull;
    private final PendingFetchManager pendingFetchManager;
    private IDataRefreshCallback refreshCallback;
    private LayoutContainer bottomToolbars;
    private ColumnModel fullColumnModel;
    private final Map<String, ICellListenerAndLinkGenerator<T>> listenerLinkGenerators = new HashMap<String, ICellListenerAndLinkGenerator<T>>();
    private List<TableModelColumnHeader> headers;
    private List<IColumnDefinitionUI<TableModelRowWithObject<T>>> columnUIDefinitions;
    private String downloadURL;
    private Map<String, IColumnDefinition<TableModelRowWithObject<T>>> columnDefinitionsMap;
    private String currentGridDisplayTypeID;
    private List<IColumnDefinitionUI<TableModelRowWithObject<T>>> visibleColDefinitions;
    protected final String gridId;
    boolean ignoreVisibleColumnsLimit = false;

    protected abstract void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<T>> var1, AbstractAsyncCallback<String> var2);

    protected static final <E extends IEntityInformationHolder> void showRelatedDataSets(IViewContext<ICommonClientServiceAsync> viewContext, TypedTableGrid<E> browser) {
        List<TableModelRowWithObject<E>> selectedEntities = browser.getSelectedBaseObjects();
        TableExportCriteria<TableModelRowWithObject<E>> displayedEntities = browser.createTableExportCriteria();
        if (selectedEntities.isEmpty()) {
            RelatedDataSetCriteria<E> relatedCriteria = RelatedDataSetCriteria.createDisplayedEntities(displayedEntities);
            ShowRelatedDatasetsDialog.showRelatedDatasetsTab(viewContext, relatedCriteria);
        } else {
            new ShowRelatedDatasetsDialog<E>(viewContext, selectedEntities, displayedEntities, browser.getTotalCount()).show();
        }
    }

    protected TypedTableGrid(IViewContext<ICommonClientServiceAsync> viewContext, String browserId, IDisplayTypeIDGenerator displayTypeIDGenerator) {
        this(viewContext, browserId, false, displayTypeIDGenerator);
    }

    protected TypedTableGrid(IViewContext<ICommonClientServiceAsync> viewContext, String browserId, boolean refreshAutomatically, IDisplayTypeIDGenerator displayTypeIDGenerator) {
        this.gridId = String.valueOf(browserId) + GRID_POSTFIX;
        this.pendingFetchManager = new PendingFetchManager();
        this.displayTypeIDGenerator = displayTypeIDGenerator;
        this.viewContext = viewContext;
        int logID = this.log("create browser grid " + this.gridId);
        this.refreshAutomatically = refreshAutomatically;
        this.pagingLoader = this.createPagingLoader();
        this.customColumnsMetadataProvider = new CustomColumnsMetadataProvider();
        this.grid = this.createGrid(this.pagingLoader, this.gridId);
        this.grid.setLazyRowRender(0);
        this.pagingToolbar = new BrowserGridPagingToolBar(this.asActionInvoker(), viewContext, 50, this.gridId);
        this.pagingToolbar.bind(this.pagingLoader);
        this.filterToolbar = new FilterToolbar(viewContext, this.gridId, this, this.createApplyFiltersDelagator());
        this.tableModificationsManager = new TableModificationsManager();
        this.modificationsToolbar = new TableModificationsToolbar(viewContext, this.tableModificationsManager);
        this.contentPanel = TypedTableGrid.createEmptyContentPanel();
        this.bottomToolbars = TypedTableGrid.createBottomToolbars(this.contentPanel, (ToolBar)this.pagingToolbar);
        this.configureBottomToolbarSyncSize();
        this.contentPanel.add(this.grid);
        this.contentPanel.setBottomComponent((Component)this.bottomToolbars);
        this.contentPanel.setHeaderVisible(false);
        this.columnListener = new ColumnListener(this.grid);
        this.showEntityViewerLinkClickListener = this.createShowEntityViewerLinkClickListener();
        this.registerLinkClickListenerFor("code", this.showEntityViewerLinkClickListener);
        this.setLayout((Layout)new FitLayout());
        this.add((Component)this.contentPanel);
        this.configureLoggingBetweenEvents(logID);
        this.grid.addListener(Events.HeaderContextMenu, (Listener)new Listener<GridEvent<ModelData>>(){

            public void handleEvent(GridEvent<ModelData> ge) {
                Menu menu = ge.getMenu();
                int itemCount = menu.getItemCount();
                int i = 2;
                while (i < itemCount) {
                    menu.remove(menu.getItem(2));
                    ++i;
                }
            }
        });
        if (viewContext.getModel().isEmbeddedMode()) {
            this.removeButtons(BrowserGridPagingToolBar.PagingToolBarButtonKind.CONFIG, BrowserGridPagingToolBar.PagingToolBarButtonKind.REFRESH);
        }
        this.setId(browserId);
        this.pagingToolbar.setId(String.valueOf(this.gridId) + "-paging-toolbar");
    }

    public void removeButtons(BrowserGridPagingToolBar.PagingToolBarButtonKind ... buttonKinds) {
        this.pagingToolbar.removeButtons(buttonKinds);
    }

    private ICellListener<TableModelRowWithObject<T>> createShowEntityViewerLinkClickListener() {
        return new ICellListener<TableModelRowWithObject<T>>(){

            @Override
            public void handle(TableModelRowWithObject<T> rowItem, boolean keyPressed) {
                TypedTableGrid.this.showEntityViewer(rowItem, false, keyPressed);
            }
        };
    }

    private void configureBottomToolbarSyncSize() {
        this.pagingLoader.addListener(Loader.Load, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                TypedTableGrid.this.pagingToolbar.syncSize();
            }
        });
        this.pagingToolbar.addListener(Events.AfterLayout, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                TypedTableGrid.this.contentPanel.syncSize();
            }
        });
        this.filterToolbar.addListener(Events.AfterLayout, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                TypedTableGrid.this.contentPanel.syncSize();
            }
        });
    }

    private void configureLoggingBetweenEvents(int logID) {
        if (this.viewContext.isLoggingEnabled()) {
            ComponentEventLogger logger = new ComponentEventLogger(this.viewContext, this.getId());
            logger.prepareLoggingBetweenEvents((Component)this.contentPanel, ComponentEventLogger.EventPair.RENDER);
            logger.prepareLoggingBetweenEvents((Component)this, ComponentEventLogger.EventPair.LAYOUT);
            logger.prepareLoggingBetweenEvents((Component)this.grid, ComponentEventLogger.EventPair.LAYOUT);
            logger.prepareLoggingBetweenEvents((Component)this.contentPanel, ComponentEventLogger.EventPair.LAYOUT);
            logger.prepareLoggingBetweenEvents((Component)this.bottomToolbars, ComponentEventLogger.EventPair.LAYOUT);
            logger.prepareLoggingBetweenEvents((Component)this.filterToolbar, ComponentEventLogger.EventPair.LAYOUT);
            logger.prepareLoggingBetweenEvents((Component)this.pagingToolbar, ComponentEventLogger.EventPair.LAYOUT);
            this.viewContext.logStop(logID);
        }
    }

    private int log(String message) {
        return this.viewContext.log(String.valueOf(message) + " [" + this.getId() + "]");
    }

    protected void showEntityInformationHolderViewer(IEntityInformationHolderWithPermId entity, boolean editMode, boolean inBackground) {
        if (editMode && OpenEntityEditorTabClickListener.forbidDeletedEntityModification(this.viewContext, entity)) {
            return;
        }
        EntityKind entityKind = entity.getEntityKind();
        BasicEntityType entityType = entity.getEntityType();
        IClientPluginFactory clientPluginFactory = this.viewContext.getClientPluginFactoryProvider().getClientPluginFactory(entityKind, entityType);
        IClientPlugin createClientPlugin = clientPluginFactory.createClientPlugin(entityKind);
        AbstractTabItemFactory tabView = editMode ? createClientPlugin.createEntityEditor(entity) : createClientPlugin.createEntityViewer(entity);
        tabView.setInBackground(inBackground);
        DispatcherHelper.dispatchNaviEvent(tabView);
    }

    private void refreshGridSilently() {
        this.grid.setLoadMask(false);
        int id = this.log("refresh silently");
        this.refresh();
        this.grid.setLoadMask(true);
        this.viewContext.logStop(id);
    }

    public void setLoadMaskImmediately(boolean loadMask) {
        if (this.grid.isRendered()) {
            if (loadMask) {
                this.grid.el().mask(GXT.MESSAGES.loadMask_msg());
            } else {
                this.grid.el().unmask();
            }
        }
    }

    protected final void registerLinkClickListenerFor(String columnID, ICellListener<TableModelRowWithObject<T>> listener) {
        if (!this.viewContext.isSimpleOrEmbeddedMode()) {
            this.columnListener.registerLinkClickListener(columnID, listener);
        }
    }

    protected final void registerLinkClickListenerForAnyMode(String columnID, ICellListener<TableModelRowWithObject<T>> listener) {
        this.columnListener.registerLinkClickListener(columnID, listener);
    }

    protected final void allowMultipleSelection() {
        this.grid.getSelectionModel().setSelectionMode(Style.SelectionMode.MULTI);
    }

    public void disallowMultipleSelection() {
        this.grid.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
    }

    private List<TableModelRowWithObject<T>> getGridElements() {
        List models = this.grid.getStore().getModels();
        ArrayList<TableModelRowWithObject<T>> elements = new ArrayList<TableModelRowWithObject<T>>();
        for (BaseEntityModel model : models) {
            elements.add((TableModelRowWithObject)model.getBaseObject());
        }
        return elements;
    }

    private IDelegatedAction createApplyFiltersDelagator() {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                if (TypedTableGrid.this.resultSetKeyOrNull != null && TypedTableGrid.this.pendingFetchManager.hasNoPendingFetch()) {
                    ResultSetFetchConfig<String> fetchConfig = ResultSetFetchConfig.createFetchFromCache(TypedTableGrid.this.resultSetKeyOrNull);
                    SortInfo sortInfo = TypedTableGrid.this.getGridSortInfo();
                    if (sortInfo != null) {
                        TypedTableGrid.this.pagingLoader.setSortField(sortInfo.getSortField());
                        TypedTableGrid.this.pagingLoader.setSortDir(TypedTableGrid.translate(sortInfo.getSortDir()));
                    }
                    TypedTableGrid.this.reloadData(fetchConfig);
                }
            }
        };
    }

    protected DisposableEntityChooser<TableModelRowWithObject<T>> asDisposableWithToolbar(IDisposableComponent toolbar) {
        LayoutContainer container = new LayoutContainer();
        container.setLayout((Layout)new RowLayout());
        container.add((Widget)toolbar.getComponent());
        container.add((Widget)this, (LayoutData)new RowData(1.0, 1.0));
        return this.asDisposableEntityChooser((Component)container, toolbar);
    }

    public final DisposableEntityChooser<TableModelRowWithObject<T>> asDisposableWithoutToolbar() {
        return this.asDisposableEntityChooser((Component)this, new IDisposableComponent[0]);
    }

    protected final DisposableEntityChooser<TableModelRowWithObject<T>> asDisposableWithToolbarAndTree(IDisposableComponent toolbar, Component tree, String headerOrNull) {
        LayoutContainer container = new LayoutContainer();
        container.setLayout((Layout)new RowLayout(Style.Orientation.VERTICAL));
        container.add((Widget)toolbar.getComponent(), (LayoutData)new RowData(1.0, -1.0));
        LayoutContainer subContainer = new LayoutContainer();
        subContainer.setLayout((Layout)new RowLayout(Style.Orientation.HORIZONTAL));
        subContainer.add((Widget)tree, (LayoutData)new RowData(300.0, 1.0));
        this.setHeader(headerOrNull);
        subContainer.add((Widget)this, (LayoutData)new RowData(1.0, 1.0));
        container.add((Widget)subContainer, (LayoutData)new RowData(1.0, 1.0));
        return this.asDisposableEntityChooser((Component)container, toolbar);
    }

    protected final void setHeader(String headerOrNull) {
        if (headerOrNull != null) {
            this.contentPanel.setHeaderVisible(true);
            this.contentPanel.setHeading(headerOrNull);
        } else {
            this.contentPanel.setHeaderVisible(false);
        }
    }

    protected final DisposableEntityChooser<TableModelRowWithObject<T>> asDisposableEntityChooser(final Component mainComponent, final IDisposableComponent ... disposableComponents) {
        final TypedTableGrid self = this;
        return new DisposableEntityChooser<TableModelRowWithObject<T>>(){

            @Override
            public List<TableModelRowWithObject<T>> getSelected() {
                List items = TypedTableGrid.this.getSelectedItems();
                ArrayList result = new ArrayList();
                for (BaseEntityModel item : items) {
                    result.add(item.getBaseObject());
                }
                return result;
            }

            @Override
            public void dispose() {
                TypedTableGrid.this.debug("dispose a browser");
                self.disposeCache();
                IDisposableComponent[] iDisposableComponentArray = disposableComponents;
                int n = disposableComponents.length;
                int n2 = 0;
                while (n2 < n) {
                    IDisposableComponent disposableComponent = iDisposableComponentArray[n2];
                    disposableComponent.dispose();
                    ++n2;
                }
            }

            @Override
            public Component getComponent() {
                return mainComponent;
            }

            @Override
            public DatabaseModificationKind[] getRelevantModifications() {
                return self.getRelevantModifications();
            }

            @Override
            public void update(Set<DatabaseModificationKind> observedModifications) {
                self.update(observedModifications);
            }
        };
    }

    protected void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
        if (this.refreshAutomatically) {
            int id = this.log("layout automatically");
            this.layout();
            this.viewContext.logStop(id);
            id = this.log("refresh automatically");
            this.refresh();
            this.viewContext.logStop(id);
        }
    }

    private PagingLoader<PagingLoadResult<BaseEntityModel<TableModelRowWithObject<T>>>> createPagingLoader() {
        RpcProxy proxy = new RpcProxy<PagingLoadResult<BaseEntityModel<TableModelRowWithObject<T>>>>(){

            protected void load(Object loadConfig, AsyncCallback<PagingLoadResult<BaseEntityModel<TableModelRowWithObject<T>>>> callback) {
                TypedTableGrid.this.loadData((PagingLoadConfig)loadConfig, callback);
            }
        };
        BasePagingLoader newPagingLoader = new BasePagingLoader((DataProxy)proxy);
        newPagingLoader.setRemoteSort(true);
        return newPagingLoader;
    }

    private void loadData(PagingLoadConfig loadConfig, AsyncCallback<PagingLoadResult<BaseEntityModel<TableModelRowWithObject<T>>>> callback) {
        if (this.pendingFetchManager.hasNoPendingFetch()) {
            if (this.resultSetKeyOrNull == null) {
                return;
            }
            this.pendingFetchManager.pushPendingFetchConfig(ResultSetFetchConfig.createFetchFromCache(this.resultSetKeyOrNull));
        }
        GridFilters<TableModelRowWithObject<T>> filters = this.filterToolbar.getFilters();
        DefaultResultSetConfig<String, TableModelRowWithObject<T>> resultSetConfig = this.createPagingConfig(loadConfig, filters, this.getGridDisplayTypeID());
        this.debug("create a refresh callback " + this.pendingFetchManager.tryTopPendingFetchConfig());
        ListEntitiesCallback listCallback = new ListEntitiesCallback(this.viewContext, callback, resultSetConfig);
        this.listEntities(resultSetConfig, listCallback);
    }

    void debug(String msg) {
    }

    private DefaultResultSetConfig<String, TableModelRowWithObject<T>> createPagingConfig(PagingLoadConfig loadConfig, GridFilters<TableModelRowWithObject<T>> filters, String gridDisplayId) {
        int limit = loadConfig.getLimit();
        int offset = loadConfig.getOffset();
        com.extjs.gxt.ui.client.data.SortInfo sortInfo = loadConfig.getSortInfo();
        DefaultResultSetConfig resultSetConfig = new DefaultResultSetConfig();
        resultSetConfig.setLimit(limit);
        resultSetConfig.setOffset(offset);
        resultSetConfig.setAvailableColumns(this.columnDefinitions);
        SortInfo translatedSortInfo = TypedTableGrid.translateSortInfo(sortInfo);
        Set<String> columnIDs = this.getIDsOfColumnsToBeShown();
        resultSetConfig.setIDsOfPresentedColumns(columnIDs);
        resultSetConfig.setSortInfo(translatedSortInfo);
        resultSetConfig.setFilters(filters);
        resultSetConfig.setCacheConfig(this.pendingFetchManager.tryTopPendingFetchConfig());
        resultSetConfig.setGridDisplayId(gridDisplayId);
        resultSetConfig.setCustomColumnErrorMessageLong(this.viewContext.getDisplaySettingsManager().isDebuggingModeEnabled());
        return resultSetConfig;
    }

    private Set<String> getIDsOfColumnsToBeShown() {
        HashSet<String> columnIDs = new HashSet<String>();
        DisplaySettingsManager manager = this.viewContext.getDisplaySettingsManager();
        List<ColumnSetting> columnSettings = manager.getColumnSettings(this.getGridDisplayTypeID());
        if (columnSettings != null) {
            for (ColumnSetting columnSetting : columnSettings) {
                if (columnSetting.isHidden()) continue;
                columnIDs.add(columnSetting.getColumnID());
            }
        }
        List<IColumnDefinition<TableModelRowWithObject<T>>> visibleColumns = this.getVisibleColumns(this.columnDefinitions);
        for (IColumnDefinition<TableModelRowWithObject<T>> definition : visibleColumns) {
            columnIDs.add(definition.getIdentifier());
        }
        return columnIDs;
    }

    private static <T> SortInfo translateSortInfo(com.extjs.gxt.ui.client.data.SortInfo sortInfo) {
        return TypedTableGrid.translateSortInfo(sortInfo.getSortField(), sortInfo.getSortDir());
    }

    private static <T> SortInfo translateSortInfo(String sortFieldId, Style.SortDir sortDir) {
        SortInfo sortInfo = new SortInfo();
        sortInfo.setSortField(sortFieldId);
        sortInfo.setSortDir(TypedTableGrid.translate(sortDir));
        return sortInfo;
    }

    private static SortInfo.SortDir translate(Style.SortDir sortDir) {
        if (sortDir.equals((Object)Style.SortDir.ASC)) {
            return SortInfo.SortDir.ASC;
        }
        if (sortDir.equals((Object)Style.SortDir.DESC)) {
            return SortInfo.SortDir.DESC;
        }
        if (sortDir.equals((Object)Style.SortDir.NONE)) {
            return SortInfo.SortDir.NONE;
        }
        throw new IllegalStateException("unknown sort dir: " + sortDir);
    }

    private static Style.SortDir translate(SortInfo.SortDir sortDir) {
        if (sortDir.equals(SortInfo.SortDir.ASC)) {
            return Style.SortDir.ASC;
        }
        if (sortDir.equals(SortInfo.SortDir.DESC)) {
            return Style.SortDir.DESC;
        }
        if (sortDir.equals(SortInfo.SortDir.NONE)) {
            return Style.SortDir.NONE;
        }
        throw new IllegalStateException("unknown sort dir: " + sortDir);
    }

    public final int getRowNumber() {
        return this.grid.getStore().getCount();
    }

    private Set<String> getIDsOfVisibleColumns() {
        HashSet<String> visibleColumnIds = new HashSet<String>();
        int i = 0;
        int n = this.fullColumnModel.getColumnCount();
        while (i < n) {
            ColumnConfig column = this.fullColumnModel.getColumn(i);
            if (!column.isHidden()) {
                visibleColumnIds.add(column.getId());
            }
            ++i;
        }
        return visibleColumnIds;
    }

    protected IBrowserGridActionInvoker asActionInvoker() {
        final TypedTableGrid delegate = this;
        return new IBrowserGridActionInvoker(){

            @Override
            public boolean supportsExportForUpdate() {
                return delegate.supportsExportForUpdate();
            }

            @Override
            public void export(TableExportType type) {
                delegate.export(type);
            }

            @Override
            public void refresh() {
                int id = TypedTableGrid.this.log("refresh in action invoker");
                delegate.refresh();
                TypedTableGrid.this.viewContext.logStop(id);
            }

            @Override
            public void configure() {
                delegate.configureColumnSettings();
            }

            @Override
            public void toggleFilters(boolean show) {
                if (show) {
                    int logId = TypedTableGrid.this.log("adding filters");
                    delegate.showFiltersBar();
                    TypedTableGrid.this.viewContext.logStop(logId);
                } else {
                    int logId = TypedTableGrid.this.log("removing filters");
                    TypedTableGrid.this.bottomToolbars.remove((Widget)TypedTableGrid.this.filterToolbar);
                    TypedTableGrid.this.bottomToolbars.layout();
                    TypedTableGrid.this.viewContext.logStop(logId);
                }
            }
        };
    }

    protected boolean supportsExportForUpdate() {
        return false;
    }

    protected void showFiltersBar() {
        int position = this.bottomToolbars.getItemCount() > 1 ? 1 : 0;
        this.bottomToolbars.insert(this.filterToolbar, position);
        this.bottomToolbars.layout();
    }

    private void showModificationsBar() {
        if (!this.bottomToolbars.getItems().contains(this.modificationsToolbar)) {
            GWTUtils.displayInfo(this.viewContext.getMessage("table_modifications_info_title", new Object[0]), this.viewContext.getMessage("table_modifications_info_text", new Object[0]), GWTUtils.DisplayInfoTime.LONG);
            this.bottomToolbars.insert((Widget)this.modificationsToolbar, 0);
            this.bottomToolbars.layout();
        }
    }

    private void hideModificationsBar() {
        this.bottomToolbars.remove((Widget)this.modificationsToolbar);
        this.bottomToolbars.layout();
    }

    protected final ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<T>>> asShowEntityInvoker(final boolean editMode) {
        return new ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<T>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<T>> selectedItem, boolean keyPressed) {
                if (selectedItem != null) {
                    TypedTableGrid.this.showEntityViewer(selectedItem.getBaseObject(), editMode, keyPressed);
                }
            }
        };
    }

    private ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<T>>> createNotImplementedInvoker() {
        return new ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<T>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<T>> selectedItem, boolean keyPressed) {
                MessageBox.alert((String)TypedTableGrid.this.viewContext.getMessage("messagebox_warning", new Object[0]), (String)TypedTableGrid.this.viewContext.getMessage("not_implemented", new Object[0]), null);
            }
        };
    }

    protected final Button createSelectedItemDummyButton(String title) {
        return this.createSelectedItemButton(title, this.createNotImplementedInvoker());
    }

    protected final Button createSelectedItemButton(String title, String id, ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<T>>> invoker) {
        Button button = this.createSelectedItemButton(title, invoker);
        button.setId(id);
        return button;
    }

    protected final Button createSelectedItemButton(String title, final ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<T>>> invoker) {
        Button button = new Button(title, (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                List selectedItems = TypedTableGrid.this.getSelectedItems();
                if (!selectedItems.isEmpty()) {
                    invoker.invoke(selectedItems.get(0), false);
                }
            }
        });
        this.enableButtonOnSelectedItem(button);
        return button;
    }

    protected final Button createSelectedItemsButton(String title, SelectionListener<ButtonEvent> listener) {
        Button button = new Button(title);
        button.addSelectionListener(listener);
        this.enableButtonOnSelectedItems(button);
        return button;
    }

    protected final void addButton(Button button) {
        this.pagingToolbar.add((Component)button);
    }

    protected final void enableButtonOnSelectedItems(final Button button) {
        button.setEnabled(false);
        this.addGridSelectionChangeListener(new Listener<SelectionChangedEvent<ModelData>>(){

            public void handleEvent(SelectionChangedEvent<ModelData> se) {
                boolean enabled = se.getSelection().size() > 0;
                button.setEnabled(enabled);
            }
        });
    }

    protected final void enableButtonOnSelectedItem(final Button button) {
        button.setEnabled(false);
        this.addGridSelectionChangeListener(new Listener<SelectionChangedEvent<ModelData>>(){

            public void handleEvent(SelectionChangedEvent<ModelData> se) {
                boolean enabled = se.getSelection().size() == 1;
                button.setEnabled(enabled);
            }
        });
    }

    protected final void changeButtonTitleOnSelectedItems(final Button button, final String noSelectedItemsTitle, final String selectedItemsTitle) {
        this.addGridSelectionChangeListener(new Listener<SelectionChangedEvent<ModelData>>(){

            public void handleEvent(SelectionChangedEvent<ModelData> se) {
                boolean noSelected = se.getSelection().size() == 0;
                button.setText(noSelected ? noSelectedItemsTitle : selectedItemsTitle);
            }
        });
    }

    public void addGridSelectionChangeListener(Listener<SelectionChangedEvent<ModelData>> listener) {
        this.grid.getSelectionModel().addListener(Events.SelectionChange, listener);
    }

    public final List<BaseEntityModel<TableModelRowWithObject<T>>> getSelectedItems() {
        return this.grid.getSelectionModel().getSelectedItems();
    }

    protected final List<TableModelRowWithObject<T>> getSelectedBaseObjects() {
        List<BaseEntityModel<TableModelRowWithObject<T>>> items = this.getSelectedItems();
        ArrayList<TableModelRowWithObject<T>> data = new ArrayList<TableModelRowWithObject<T>>();
        for (BaseEntityModel<TableModelRowWithObject<T>> item : items) {
            data.add(item.getBaseObject());
        }
        return data;
    }

    protected final IDelegatedAction createRefreshGridAction() {
        return this.createRefreshGridAction(null);
    }

    protected final IDelegatedAction createRefreshGridAction(final IDataRefreshCallback externalDataRefreshCallbackOrNull) {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                int id = TypedTableGrid.this.log("execute refresh grid action");
                TypedTableGrid.this.refresh(externalDataRefreshCallbackOrNull);
                TypedTableGrid.this.viewContext.logStop(id);
            }
        };
    }

    protected final IDelegatedAction createRefreshGridSilentlyAction() {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                int id = TypedTableGrid.this.log("execute refresh grid silently action");
                TypedTableGrid.this.refreshGridSilently();
                TypedTableGrid.this.viewContext.logStop(id);
            }
        };
    }

    protected final void refreshGridWithFilters() {
        this.pagingToolbar.disableExportButton();
        this.pagingToolbar.updateDefaultConfigButton(false);
        this.filterToolbar.resetFilterFields();
        this.filterToolbar.resetFilterSelectionWithoutApply();
        int id = this.log("refresh grid with filters");
        this.refresh();
        this.viewContext.logStop(id);
        this.filterToolbar.refresh();
    }

    protected final void updateDefaultRefreshButton() {
        boolean isEnabled = this.isRefreshEnabled();
        this.pagingToolbar.updateDefaultRefreshButton(isEnabled);
    }

    protected final void refresh(boolean refreshColumnsDefinition) {
        this.refresh(null, refreshColumnsDefinition);
    }

    protected final void refresh(IDataRefreshCallback externalRefreshCallbackOrNull, boolean refreshColumnsDefinition) {
        int id = this.log("refresh (refreshColumnsDefinition=" + refreshColumnsDefinition + ")");
        this.pagingToolbar.updateDefaultRefreshButton(false);
        SortInfo sortInfo = this.getGridSortInfo();
        if (sortInfo != null) {
            this.pagingLoader.setSortField(sortInfo.getSortField());
            this.pagingLoader.setSortDir(TypedTableGrid.translate(sortInfo.getSortDir()));
        }
        this.debug("clean cache for refresh");
        this.refreshCallback = this.createRefreshCallback(externalRefreshCallbackOrNull);
        if (this.columnDefinitions == null || refreshColumnsDefinition) {
            this.recreateColumnModelAndRefreshColumnsWithFilters();
        }
        this.reloadData(this.createDisposeAndRefreshFetchMode());
        this.viewContext.logStop(id);
    }

    private ResultSetFetchConfig<String> createDisposeAndRefreshFetchMode() {
        if (this.resultSetKeyOrNull != null) {
            return ResultSetFetchConfig.createClearComputeAndCache(this.resultSetKeyOrNull);
        }
        return ResultSetFetchConfig.createComputeAndCache();
    }

    private ColumnDefsAndConfigs<TableModelRowWithObject<T>> createColumnDefsAndConfigs() {
        ColumnDefsAndConfigs<TableModelRowWithObject<T>> defsAndConfigs = this.createColumnsDefinition();
        List<GridCustomColumnInfo> customColumnsMetadata = this.customColumnsMetadataProvider.getCustomColumnsMetadata();
        if (customColumnsMetadata.size() > 0) {
            List<IColumnDefinitionUI<T>> customColumnsDefs = TypedTableGrid.createCustomColumnDefinitions(customColumnsMetadata);
            defsAndConfigs.addColumns(customColumnsDefs, this.viewContext);
            for (GridCustomColumnInfo gridCustomColumnInfo : customColumnsMetadata) {
                DataTypeCode columnType = gridCustomColumnInfo.getDataType();
                GridCellRenderer<BaseEntityModel<?>> columnRenderer = null;
                if (DataTypeCode.REAL.equals(columnType)) {
                    columnRenderer = new RealNumberRenderer(this.viewContext.getDisplaySettingsManager().getRealNumberFormatingParameters());
                } else if (DataTypeCode.VARCHAR.equals(columnType)) {
                    columnRenderer = new CustomColumnStringRenderer();
                }
                if (columnRenderer == null) continue;
                defsAndConfigs.setGridCellRendererFor(gridCustomColumnInfo.getCode(), columnRenderer);
            }
        }
        return defsAndConfigs;
    }

    protected final void recreateColumnModelAndRefreshColumnsWithFilters() {
        int logId = this.log("recreateColumnModelAndRefreshColumnsWithFilters");
        ColumnDefsAndConfigs<TableModelRowWithObject<T>> defsAndConfigs = this.createColumnDefsAndConfigs();
        this.columnDefinitions = defsAndConfigs.getColumnDefs();
        ColumnModel columnModel = TypedTableGrid.createColumnModel(defsAndConfigs.getColumnConfigs());
        this.refreshColumnsAndFilters(columnModel);
        this.viewContext.logStop(logId);
    }

    private static <T> List<IColumnDefinitionUI<T>> createCustomColumnDefinitions(List<GridCustomColumnInfo> customColumnsMetadata) {
        ArrayList<IColumnDefinitionUI<T>> defs = new ArrayList<IColumnDefinitionUI<T>>();
        for (GridCustomColumnInfo columnMetadata : customColumnsMetadata) {
            GridCustomColumnDefinition colDef = new GridCustomColumnDefinition(columnMetadata);
            defs.add(colDef);
        }
        return defs;
    }

    private void refreshColumnsAndFilters(ColumnModel columnModel) {
        ColumnModel newColumnModel = columnModel;
        DisplaySettingsManager.GridDisplaySettings settings = this.tryApplyDisplaySettings(newColumnModel);
        if (settings != null && settings.getColumnConfigs() != null) {
            newColumnModel = TypedTableGrid.createColumnModel(settings.getColumnConfigs());
            this.rebuildFiltersFromIds(settings.getFilteredColumnIds());
        } else {
            this.filterToolbar.rebuildColumnFilters(this.getInitialFilters());
        }
        this.changeColumnModel(newColumnModel, settings != null ? settings.getSortField() : null, settings != null ? settings.getSortDir() : null);
    }

    private void hideLoadingMask() {
        if (this.grid.isRendered() && this.grid.el() != null) {
            this.grid.el().unmask();
        }
    }

    private DisplaySettingsManager.GridDisplaySettings tryApplyDisplaySettings(ColumnModel columnModel) {
        List<IColumnDefinition<T>> initialFilters = this.getInitialFilters();
        return this.viewContext.getDisplaySettingsManager().tryApplySettings(this.getGridDisplayTypeID(), columnModel, TypedTableGrid.extractColumnIds(initialFilters), this.getGridSortInfo());
    }

    private void reconfigureGrid(ColumnModel columnModelOfVisible) {
        ArrayList sortlisteners = new ArrayList(this.grid.getListeners(Events.SortChange));
        for (Listener listener : sortlisteners) {
            this.grid.removeListener(Events.SortChange, listener);
        }
        this.grid.reconfigure(this.grid.getStore(), columnModelOfVisible);
        for (Listener listener : sortlisteners) {
            this.grid.addListener(Events.SortChange, listener);
        }
    }

    private void changeColumnModel(ColumnModel columnModel, String sortField, SortInfo.SortDir sortDir) {
        this.fullColumnModel = columnModel;
        int logId = this.log("grid reconfigure");
        ColumnModel columnModelOfVisible = this.trimToVisibleColumns(columnModel);
        if (sortDir != null && sortField != null) {
            this.pagingLoader.setSortDir(TypedTableGrid.translate(sortDir));
            this.pagingLoader.setSortField(sortField);
        }
        this.reconfigureGrid(columnModelOfVisible);
        this.viewContext.logStop(logId);
        this.registerGridSettingsChangesListener();
        List listeners = this.fullColumnModel.getListeners(Events.WidthChange);
        for (Listener listener : listeners) {
            columnModelOfVisible.addListener(Events.WidthChange, listener);
            columnModelOfVisible.addListener(Events.ColumnMove, listener);
        }
    }

    private ColumnModel trimToVisibleColumns(ColumnModel columnModel) {
        int maxVisibleColumns = this.getWebClientConfiguration().getMaxVisibleColumns();
        int counter = 0;
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        int i = 0;
        int n = columnModel.getColumnCount();
        while (i < n) {
            ColumnConfig column = columnModel.getColumn(i);
            if (!column.isHidden()) {
                if (++counter <= maxVisibleColumns) {
                    columns.add(column);
                } else {
                    column.setHidden(true);
                }
            }
            ++i;
        }
        if (counter > maxVisibleColumns) {
            this.saveColumnDisplaySettings();
            InfoConfig infoConfig = new InfoConfig(this.viewContext.getMessage("VISIBLE_COLUMNS_LIMITED_TITLE", new Object[0]), this.viewContext.getMessage("VISIBLE_COLUMNS_LIMITED_MSG", maxVisibleColumns, counter));
            infoConfig.height = 100;
            infoConfig.display = 5000;
            Info.display((InfoConfig)infoConfig);
        }
        ColumnModel trimmedModel = TypedTableGrid.createColumnModel(columns);
        return trimmedModel;
    }

    private void registerGridSettingsChangesListener() {
        this.viewContext.getDisplaySettingsManager().registerGridSettingsChangesListener(this.getGridDisplayTypeID(), this.createDisplaySettingsUpdater());
    }

    void reloadData(ResultSetFetchConfig<String> resultSetFetchConfig) {
        if (this.pendingFetchManager.hasPendingFetch()) {
            this.debug("Cannot reload the data with the mode '" + resultSetFetchConfig + "'; there is an unfinished request already: " + this.pendingFetchManager.tryTopPendingFetchConfig());
            return;
        }
        this.pendingFetchManager.pushPendingFetchConfig(resultSetFetchConfig);
        this.pagingLoader.load(0, 50);
    }

    private IDisplaySettingsGetter createDisplaySettingsUpdater() {
        return new IDisplaySettingsGetter(){

            @Override
            public ColumnModel getColumnModel() {
                return TypedTableGrid.this.getFullColumnModel();
            }

            @Override
            public List<String> getFilteredColumnIds() {
                return TypedTableGrid.this.filterToolbar.extractFilteredColumnIds();
            }

            @Override
            public Object getModifier() {
                return TypedTableGrid.this;
            }

            @Override
            public SortInfo getSortState() {
                return TypedTableGrid.this.getGridSortInfo();
            }
        };
    }

    boolean rebuildFiltersFromIds(List<String> filteredColumnIds) {
        List filteredColumns = this.getColumnDefinitions(filteredColumnIds);
        return this.filterToolbar.rebuildColumnFilters(filteredColumns);
    }

    @Override
    public List<IColumnDefinition<TableModelRowWithObject<T>>> getColumnDefinitions(List<String> columnIds) {
        Map<String, IColumnDefinition<T>> colsMap = TypedTableGrid.asColumnIdMap(this.columnDefinitions);
        ArrayList<IColumnDefinition<TableModelRowWithObject<T>>> columns = new ArrayList<IColumnDefinition<TableModelRowWithObject<T>>>();
        for (String columnId : columnIds) {
            IColumnDefinition<T> colDef = colsMap.get(columnId);
            assert (colDef != null) : "Cannot find a column '" + columnId;
            columns.add(colDef);
        }
        return columns;
    }

    protected final String createGridDisplayTypeID(String suffixOrNull) {
        if (this.displayTypeIDGenerator == null) {
            throw new IllegalStateException("Undefined display type ID generator.");
        }
        if (suffixOrNull == null) {
            return this.displayTypeIDGenerator.createID();
        }
        return this.displayTypeIDGenerator.createID(suffixOrNull);
    }

    protected EntityKind getEntityKindOrNull() {
        return null;
    }

    private IDataRefreshCallback createRefreshCallback(IDataRefreshCallback externalRefreshCallbackOrNull) {
        IDataRefreshCallback internalCallback = this.createInternalPostRefreshCallback();
        if (externalRefreshCallbackOrNull == null) {
            return internalCallback;
        }
        return TypedTableGrid.mergeCallbacks(internalCallback, externalRefreshCallbackOrNull);
    }

    private IDataRefreshCallback createInternalPostRefreshCallback() {
        return new IDataRefreshCallback(){

            @Override
            public void postRefresh(boolean wasSuccessful) {
                if (TypedTableGrid.this.customColumnsMetadataProvider.getHasChangedAndSetFalse()) {
                    TypedTableGrid.this.recreateColumnModelAndRefreshColumnsWithFilters();
                }
                TypedTableGrid.this.updateDefaultRefreshButton();
                if (wasSuccessful) {
                    TypedTableGrid.this.hideLoadingMask();
                    TypedTableGrid.this.pagingToolbar.updateDefaultConfigButton(true);
                    TypedTableGrid.this.pagingToolbar.enableExportButton();
                }
            }
        };
    }

    private static IDataRefreshCallback mergeCallbacks(final IDataRefreshCallback c1, final IDataRefreshCallback c2) {
        return new IDataRefreshCallback(){

            @Override
            public void postRefresh(boolean wasSuccessful) {
                c1.postRefresh(wasSuccessful);
                c2.postRefresh(wasSuccessful);
            }
        };
    }

    private List<IColumnDefinition<TableModelRowWithObject<T>>> getVisibleColumns(Set<IColumnDefinition<TableModelRowWithObject<T>>> availableColumns) {
        Map<String, IColumnDefinition<T>> availableColumnsMap = TypedTableGrid.asColumnIdMap(availableColumns);
        return TypedTableGrid.getVisibleColumns(availableColumnsMap, this.fullColumnModel);
    }

    private List<IColumnDefinition<TableModelRowWithObject<T>>> getNonCustomColumns(Set<IColumnDefinition<TableModelRowWithObject<T>>> availableColumns) {
        ArrayList<IColumnDefinition<TableModelRowWithObject<T>>> nonCustom = new ArrayList<IColumnDefinition<TableModelRowWithObject<T>>>();
        for (IColumnDefinition<TableModelRowWithObject<T>> c : availableColumns) {
            if (c.isCustom()) continue;
            nonCustom.add(c);
        }
        return nonCustom;
    }

    private void saveCacheKey(String newResultSetKey) {
        this.resultSetKeyOrNull = newResultSetKey;
        this.debug("saving new cache key");
    }

    protected void disposeCache() {
        this.removeResultSet(this.resultSetKeyOrNull);
        this.resultSetKeyOrNull = null;
    }

    protected void removeResultSet(String resultSetKey) {
        if (resultSetKey != null) {
            this.viewContext.getService().removeResultSet(resultSetKey, new VoidAsyncCallback<Void>(this.viewContext));
        }
    }

    private void export(TableExportType type) {
        this.export(type, new ExportEntitiesCallback(this.viewContext));
    }

    private void configureColumnSettings() {
        assert (this.grid != null && this.grid.getColumnModel() != null) : "Grid must be loaded";
        ColumnSettingsConfigurer<T> columnSettingsConfigurer = new ColumnSettingsConfigurer<T>(this, this.viewContext, this.filterToolbar, this.customColumnsMetadataProvider, this.resultSetKeyOrNull, this.pendingFetchManager.tryTopPendingFetchConfig());
        columnSettingsConfigurer.showDialog();
    }

    private void saveColumnDisplaySettings() {
        IDisplaySettingsGetter settingsUpdater = this.createDisplaySettingsUpdater();
        this.viewContext.getDisplaySettingsManager().storeSettings(this.getGridDisplayTypeID(), settingsUpdater, false);
    }

    public final void export(TableExportType type, AbstractAsyncCallback<String> callback) {
        TableExportCriteria<TableModelRowWithObject<T>> exportCriteria = this.createTableExportCriteria(type);
        this.prepareExportEntities(exportCriteria, callback);
    }

    protected final TableExportCriteria<TableModelRowWithObject<T>> createTableExportCriteria() {
        return this.createTableExportCriteria(TableExportType.VISIBLE);
    }

    private final TableExportCriteria<TableModelRowWithObject<T>> createTableExportCriteria(TableExportType type) {
        assert (this.columnDefinitions != null) : "refresh before exporting!";
        assert (this.resultSetKeyOrNull != null) : "refresh before exporting, resultSetKey is null!";
        ArrayList columnDefs = TableExportType.VISIBLE.equals((Object)type) ? this.getVisibleColumns(this.columnDefinitions) : (TableExportType.FOR_UPDATE.equals((Object)type) ? this.getNonCustomColumns(this.columnDefinitions) : new ArrayList(this.columnDefinitions));
        SortInfo sortInfo = this.getGridSortInfo();
        EntityKind entityKindForUpdateOrNull = TableExportType.FOR_UPDATE.equals((Object)type) ? this.getEntityKindOrNull() : null;
        TableExportCriteria<TableModelRowWithObject<T>> exportCriteria = new TableExportCriteria<TableModelRowWithObject<T>>(this.resultSetKeyOrNull, sortInfo, this.filterToolbar.getFilters(), entityKindForUpdateOrNull, columnDefs, this.columnDefinitions, this.getGridDisplayTypeID());
        return exportCriteria;
    }

    public SortInfo getGridSortInfo() {
        ListStore store = this.grid.getStore();
        return TypedTableGrid.translateSortInfo(store.getSortField(), store.getSortDir());
    }

    public int getTotalCount() {
        return this.pagingToolbar.getTotalCount();
    }

    void refreshColumnsSettings() {
        this.grid.setLoadMask(false);
        this.grid.getView().refresh(true);
        this.grid.setLoadMask(true);
    }

    protected final void addEntityOperationsLabel() {
        this.pagingToolbar.addEntityOperationsLabel();
    }

    protected final void addEntityOperationsSeparator() {
        this.pagingToolbar.add((Component)new SeparatorToolItem());
    }

    protected final GridCellRenderer<BaseEntityModel<?>> createMultilineStringCellRenderer() {
        return new MultilineStringCellRenderer();
    }

    protected GridCellRenderer<BaseEntityModel<?>> createInternalLinkCellRenderer() {
        return LinkRenderer.createLinkRenderer();
    }

    protected WebClientConfiguration getWebClientConfiguration() {
        return this.viewContext.getModel().getApplicationInfo().getWebClientConfiguration();
    }

    private static <T> List<String> extractColumnIds(List<IColumnDefinition<T>> columns) {
        ArrayList<String> columnsIds = new ArrayList<String>();
        for (IColumnDefinition<T> column : columns) {
            columnsIds.add(column.getIdentifier());
        }
        return columnsIds;
    }

    static List<ColumnDataModel> createColumnsSettingsModel(ColumnModel cm, List<String> filteredColumnsIds) {
        HashSet<String> filteredColumnsMap = new HashSet<String>(filteredColumnsIds);
        int cols = cm.getColumnCount();
        ArrayList<ColumnDataModel> list = new ArrayList<ColumnDataModel>();
        int i = 0;
        while (i < cols) {
            if (cm.getColumnHeader(i) != null && !cm.getColumnHeader(i).equals("") && !cm.isFixed(i)) {
                String columnId = cm.getColumnId(i);
                boolean isVisible = !cm.isHidden(i);
                boolean hasFilter = filteredColumnsMap.contains(columnId);
                list.add(new ColumnDataModel(cm.getColumnHeader(i), isVisible, hasFilter, columnId));
            }
            ++i;
        }
        return list;
    }

    private static ContentPanel createEmptyContentPanel() {
        ContentPanel contentPanel = new ContentPanel();
        contentPanel.setBorders(false);
        contentPanel.setBodyBorder(false);
        contentPanel.setLayout((Layout)new FitLayout());
        return contentPanel;
    }

    private static <T> LayoutContainer createBottomToolbars(Container<?> parentContainer, ToolBar pagingToolbar) {
        ContainerKeeper bottomToolbars = new ContainerKeeper(parentContainer);
        bottomToolbars.setMonitorWindowResize(true);
        bottomToolbars.setLayout((Layout)new RowLayout(Style.Orientation.VERTICAL));
        bottomToolbars.add((Widget)pagingToolbar, (LayoutData)new RowData(1.0, -1.0));
        return bottomToolbars;
    }

    private Grid<BaseEntityModel<TableModelRowWithObject<T>>> createGrid(PagingLoader<PagingLoadResult<BaseEntityModel<TableModelRowWithObject<T>>>> dataLoader, String gridId) {
        ListStore listStore = new ListStore(dataLoader);
        ColumnModel columnModel = TypedTableGrid.createColumnModel(new ArrayList<ColumnConfig>());
        EditorGrid editorGrid = new EditorGrid(listStore, columnModel);
        editorGrid.setId(gridId);
        editorGrid.setLoadMask(true);
        editorGrid.setSelectionModel(new GridSelectionModel());
        editorGrid.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        editorGrid.setView((GridView)new ExtendedGridView());
        editorGrid.setStripeRows(true);
        editorGrid.setColumnReordering(true);
        editorGrid.setClicksToEdit(EditorGrid.ClicksToEdit.TWO);
        editorGrid.addListener(Events.BeforeEdit, new Listener<GridEvent<BaseEntityModel<TableModelRowWithObject<T>>>>(){

            public void handleEvent(GridEvent<BaseEntityModel<TableModelRowWithObject<T>>> event) {
                if (TypedTableGrid.this.viewContext.isSimpleOrEmbeddedMode()) {
                    MessageBox.info((String)"Not Allowed", (String)"Sorry, table cell editing is not allowed in current viewing mode", null);
                    event.setCancelled(true);
                } else if (TypedTableGrid.this.tableModificationsManager.isSaving()) {
                    MessageBox.info((String)"Not Allowed", (String)"Sorry, table cell editing is not allowed during saving of recently changed table cells.", null);
                    event.setCancelled(true);
                } else {
                    String columnID;
                    BaseEntityModel model = (BaseEntityModel)event.getModel();
                    boolean editable = TypedTableGrid.this.isEditable(model, columnID = event.getProperty());
                    if (!editable) {
                        TypedTableGrid.this.showNonEditableTableCellMessage(model, columnID);
                    }
                    event.setCancelled(!editable);
                }
            }
        });
        editorGrid.addListener(Events.AfterEdit, new Listener<GridEvent<BaseEntityModel<TableModelRowWithObject<T>>>>(){

            public void handleEvent(GridEvent<BaseEntityModel<TableModelRowWithObject<T>>> event) {
                BaseEntityModel model = (BaseEntityModel)event.getModel();
                String columnID = event.getProperty();
                Object value = event.getValue();
                String newValueNotNull = StringUtils.toStringEmptyIfNull(value);
                String oldValueNotNull = StringUtils.toStringEmptyIfNull(event.getStartValue());
                if (oldValueNotNull.equals(newValueNotNull)) {
                    event.setCancelled(true);
                } else {
                    TypedTableGrid.this.showModificationsBar();
                    if (value instanceof VocabularyTerm) {
                        VocabularyTerm term = (VocabularyTerm)value;
                        value = term.getCode();
                    }
                    TypedTableGrid.this.tableModificationsManager.handleEditingEvent(model, columnID, StringUtils.toStringOrNull(value));
                }
            }
        });
        editorGrid.addListener(Events.SortChange, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                TypedTableGrid.this.saveColumnDisplaySettings();
            }
        });
        return editorGrid;
    }

    protected boolean isEditable(BaseEntityModel<TableModelRowWithObject<T>> model, String columnID) {
        return false;
    }

    protected void showNonEditableTableCellMessage(BaseEntityModel<TableModelRowWithObject<T>> model, String columnID) {
        MessageBox.info((String)"Not Editable", (String)"Sorry, this table cell isn't editable", null);
    }

    protected IEntityProperty tryGetProperty(IEntityPropertiesHolder propertiesHolder, String propertyColumnNameWithoutPrefix) {
        String propertyTypeCode = CodeConverter.getPropertyTypeCode(propertyColumnNameWithoutPrefix);
        List<IEntityProperty> properties = propertiesHolder.getProperties();
        for (IEntityProperty property : properties) {
            if (!property.getPropertyType().getCode().equals(propertyTypeCode)) continue;
            return property;
        }
        return null;
    }

    private static ColumnModel createColumnModel(List<ColumnConfig> columConfigs) {
        return new ColumnModel(columConfigs);
    }

    ColumnModel getFullColumnModel() {
        return this.fullColumnModel;
    }

    private static <T> Map<String, IColumnDefinition<T>> asColumnIdMap(Set<IColumnDefinition<T>> defs) {
        HashMap<String, IColumnDefinition<T>> map = new HashMap<String, IColumnDefinition<T>>();
        for (IColumnDefinition<T> def : defs) {
            map.put(def.getIdentifier(), def);
        }
        return map;
    }

    private static <T> List<T> getVisibleColumns(Map<String, T> availableColumns, ColumnModel columnModel) {
        ArrayList<T> selectedColumnDefs = new ArrayList<T>();
        int columnCount = columnModel.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            if (!columnModel.isHidden(i)) {
                String columnId = columnModel.getColumnId(i);
                selectedColumnDefs.add(availableColumns.get(columnId));
            }
            ++i;
        }
        return selectedColumnDefs;
    }

    protected final AbstractAsyncCallback<Void> createEmptyCallback() {
        return new AbstractAsyncCallback<Void>(this.viewContext){

            @Override
            protected void process(Void result) {
            }
        };
    }

    protected final AbstractAsyncCallback<Void> createRefreshCallback(IBrowserGridActionInvoker invoker) {
        return new RefreshCallback(this.viewContext, invoker);
    }

    protected void applyModifications(BaseEntityModel<TableModelRowWithObject<T>> model, String resultSetKey, List<IModification> modifications, AsyncCallback<IUpdateResult> callBack) {
    }

    @Override
    public String getGridDisplayTypeID() {
        return this.createGridDisplayTypeID(null);
    }

    protected void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    protected abstract void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<T>> var1, AbstractAsyncCallback<TypedTableResultSet<T>> var2);

    protected ColumnDefsAndConfigs<TableModelRowWithObject<T>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<T>> definitions = ColumnDefsAndConfigs.create(this.createColDefinitions(), this.viewContext);
        Set<IColumnDefinition<TableModelRowWithObject<T>>> columnDefs = definitions.getColumnDefs();
        this.columnDefinitionsMap = new HashMap<String, IColumnDefinition<TableModelRowWithObject<T>>>();
        for (IColumnDefinition<TableModelRowWithObject<T>> definition : columnDefs) {
            String identifier = definition.getIdentifier();
            this.columnDefinitionsMap.put(identifier, definition);
        }
        if (this.headers != null) {
            for (TableModelColumnHeader header : this.headers) {
                String id = header.getId();
                GridCellRenderer<BaseEntityModel<?>> specificRendererOrNull = this.tryGetSpecificRenderer(header.getDataType(), header.getIndex());
                if (specificRendererOrNull != null) {
                    definitions.setGridCellRendererFor(id, specificRendererOrNull);
                    continue;
                }
                if (this.tryGetCellListenerAndLinkGenerator(id) == null) continue;
                definitions.setGridCellRendererFor(id, LinkRenderer.createLinkRenderer(true, header.getIndex()));
            }
        }
        return definitions;
    }

    private GridCellRenderer<BaseEntityModel<?>> tryGetSpecificRenderer(DataTypeCode dataType, int columnIndex) {
        if (dataType == null) {
            return null;
        }
        switch (dataType) {
            case CONTROLLEDVOCABULARY: {
                return new VocabularyTermStringCellRenderer(columnIndex);
            }
            case MATERIAL: {
                return new MaterialRenderer(columnIndex);
            }
            case HYPERLINK: {
                return LinkRenderer.createExternalLinkRenderer();
            }
            case REAL: {
                return new RealNumberRenderer(this.viewContext.getDisplaySettingsManager().getRealNumberFormatingParameters());
            }
            case MULTILINE_VARCHAR: {
                return new MultilineStringCellRenderer();
            }
            case TIMESTAMP: {
                return new TimestampStringCellRenderer();
            }
            case XML: {
                return new MultilineStringCellRenderer();
            }
        }
        return null;
    }

    protected BaseEntityModel<TableModelRowWithObject<T>> createModel(GridRowModel<TableModelRowWithObject<T>> entity) {
        return new BaseEntityModel<TableModelRowWithObject<T>>(entity, this.visibleColDefinitions);
    }

    protected void registerListenerAndLinkGenerator(String columnID, ICellListenerAndLinkGenerator<T> listenerLinkGenerator) {
        this.listenerLinkGenerators.put(columnID, listenerLinkGenerator);
        this.registerLinkClickListenerFor(columnID, listenerLinkGenerator);
    }

    protected void registerListenerAndLinkGeneratorForAnyMode(String columnID, ICellListenerAndLinkGenerator<T> listenerLinkGenerator) {
        this.listenerLinkGenerators.put(columnID, listenerLinkGenerator);
        this.registerLinkClickListenerForAnyMode(columnID, listenerLinkGenerator);
    }

    private List<IColumnDefinitionUI<TableModelRowWithObject<T>>> createColDefinitions() {
        if (this.columnUIDefinitions == null) {
            ArrayList<IColumnDefinitionUI<TableModelRowWithObject<T>>> list = new ArrayList<IColumnDefinitionUI<TableModelRowWithObject<T>>>();
            if (this.headers != null) {
                String sessionID = this.viewContext.getModel().getSessionContext().getSessionID();
                for (TableModelColumnHeader header : this.headers) {
                    String title = header.getTitle();
                    String columnId = header.getId();
                    if (title == null) {
                        title = this.viewContext.getMessage(this.translateColumnIdToDictionaryKey(columnId), new Object[0]);
                    }
                    CellListenerAndLinkGenerator linkGeneratorOrNull = this.tryGetCellListenerAndLinkGenerator(columnId);
                    EntityKind entityKind = header.tryGetEntityKind();
                    if (linkGeneratorOrNull == null && entityKind != null) {
                        linkGeneratorOrNull = new CellListenerAndLinkGenerator(entityKind, header);
                        this.registerListenerAndLinkGenerator(columnId, linkGeneratorOrNull);
                    }
                    TypedTableGridColumnDefinitionUI<T> definition = new TypedTableGridColumnDefinitionUI<T>(header, title, this.downloadURL, sessionID, linkGeneratorOrNull);
                    if (list.size() > 200) {
                        definition.setHidden(true);
                    }
                    list.add(definition);
                }
            }
            this.columnUIDefinitions = list;
        }
        return this.columnUIDefinitions;
    }

    protected ICellListenerAndLinkGenerator<T> tryGetCellListenerAndLinkGenerator(String columnId) {
        return this.listenerLinkGenerators.get(columnId);
    }

    protected String translateColumnIdToDictionaryKey(String columnID) {
        return String.valueOf(this.getId()) + "_" + columnID;
    }

    private void listEntities(final DefaultResultSetConfig<String, TableModelRowWithObject<T>> resultSetConfig, final AbstractAsyncCallback<ResultSet<TableModelRowWithObject<T>>> callback) {
        AbstractAsyncCallback extendedCallback = new AbstractAsyncCallback<TypedTableResultSet<T>>(this.viewContext){

            @Override
            protected void process(TypedTableResultSet<T> result) {
                ResultSet resultSet = result.getResultSet();
                if (resultSetConfig.getCacheConfig().getMode() != ResultSetFetchConfig.ResultSetFetchMode.FETCH_FROM_CACHE) {
                    TypedTableGrid.this.headers = resultSet.getList().getColumnHeaders();
                    TypedTableGrid.this.columnUIDefinitions = null;
                    List<GridCustomColumnInfo> customColumnMetadata = resultSet.getList().getCustomColumnsMetadata();
                    TypedTableGrid.this.customColumnsMetadataProvider.setCustomColumnsMetadata(customColumnMetadata);
                    TypedTableGrid.this.recreateColumnModelAndRefreshColumnsWithFilters();
                    TypedTableGrid.this.saveColumnDisplaySettings();
                }
                callback.onSuccess(resultSet);
            }

            @Override
            public void finishOnFailure(Throwable caught) {
                callback.finishOnFailure(caught);
            }
        };
        this.listTableRows(resultSetConfig, extendedCallback);
        this.currentGridDisplayTypeID = this.getGridDisplayTypeID();
    }

    protected boolean isRefreshEnabled() {
        return true;
    }

    protected void refresh() {
        this.refresh(null);
    }

    protected void refresh(IDataRefreshCallback externalRefreshCallbackOrNull) {
        String gridDisplayTypeID = this.getGridDisplayTypeID();
        this.refresh(externalRefreshCallbackOrNull, !gridDisplayTypeID.equals(this.currentGridDisplayTypeID));
    }

    protected void showEntityViewer(TableModelRowWithObject<T> entity, boolean editMode, boolean inBackground) {
    }

    private List<IColumnDefinition<TableModelRowWithObject<T>>> getInitialFilters() {
        ArrayList<IColumnDefinition<TableModelRowWithObject<T>>> definitions = new ArrayList<IColumnDefinition<TableModelRowWithObject<T>>>();
        List<String> ids = this.getColumnIdsOfFilters();
        for (String id : ids) {
            IColumnDefinition<TableModelRowWithObject<T>> definition = this.columnDefinitionsMap.get(id);
            if (definition == null) continue;
            definitions.add(definition);
        }
        return definitions;
    }

    protected List<String> getColumnIdsOfFilters() {
        return Collections.emptyList();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[0];
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.refreshGridSilently();
    }

    protected List<T> getContainedGridElements() {
        List<TableModelRowWithObject<T>> wrappedElements = this.getGridElements();
        ArrayList<T> elements = new ArrayList<T>();
        for (TableModelRowWithObject<T> wrappedElement : wrappedElements) {
            elements.add(wrappedElement.getObjectOrNull());
        }
        return elements;
    }

    protected abstract class AbstractCreateDialogListener
    extends SelectionListener<ButtonEvent> {
        protected AbstractCreateDialogListener() {
        }

        public void componentSelected(ButtonEvent ce) {
            List data = TypedTableGrid.this.getSelectedBaseObjects();
            IBrowserGridActionInvoker invoker = TypedTableGrid.this.asActionInvoker();
            if (this.validateSelectedData(data)) {
                this.createDialog(data, invoker).show();
            }
        }

        protected boolean validateSelectedData(List<TableModelRowWithObject<T>> data) {
            return true;
        }

        protected abstract Dialog createDialog(List<TableModelRowWithObject<T>> var1, IBrowserGridActionInvoker var2);
    }

    private final class CellListenerAndLinkGenerator
    implements ICellListenerAndLinkGenerator<T> {
        private final EntityKind entityKind;
        private final TableModelColumnHeader header;

        private CellListenerAndLinkGenerator(EntityKind entityKind, TableModelColumnHeader header) {
            this.entityKind = entityKind;
            this.header = header;
        }

        @Override
        public String tryGetLink(T entity, ISerializableComparable value) {
            if (value == null || value.toString().length() == 0) {
                return null;
            }
            if (value instanceof EntityTableCell) {
                EntityTableCell entityTableCell = (EntityTableCell)value;
                if (entityTableCell.isMissing() || entityTableCell.isFake()) {
                    return null;
                }
                String permId = entityTableCell.getPermId();
                if (entityTableCell.getEntityKind() == EntityKind.MATERIAL) {
                    return LinkExtractor.tryExtract(MaterialIdentifier.tryParseIdentifier(permId));
                }
                return LinkExtractor.createPermlink(entityTableCell.getEntityKind(), permId);
            }
            if (this.header.isLinkEntitiesOnly()) {
                return null;
            }
            return LinkExtractor.createPermlink(this.entityKind, value.toString());
        }

        @Override
        public void handle(TableModelRowWithObject<T> rowItem, boolean specialKeyPressed) {
            ISerializableComparable cellValue = rowItem.getValues().get(this.header.getIndex());
            if (cellValue instanceof EntityTableCell) {
                EntityTableCell entityTableCell = (EntityTableCell)cellValue;
                String permId = entityTableCell.getPermId();
                if (entityTableCell.getEntityKind() == EntityKind.MATERIAL) {
                    MaterialIdentifier materialIdentifier = MaterialIdentifier.tryParseIdentifier(permId);
                    OpenEntityDetailsTabHelper.open(TypedTableGrid.this.viewContext, materialIdentifier, specialKeyPressed);
                } else if (permId.length() != 0) {
                    OpenEntityDetailsTabHelper.open(TypedTableGrid.this.viewContext, entityTableCell.getEntityKind(), permId, specialKeyPressed);
                } else {
                    OpenEntityDetailsTabHelper.open(TypedTableGrid.this.viewContext, new BasicEntityDescription(entityTableCell.getEntityKind(), entityTableCell.getIdentifierOrNull()), specialKeyPressed);
                }
            } else {
                OpenEntityDetailsTabHelper.open(TypedTableGrid.this.viewContext, this.entityKind, cellValue.toString(), specialKeyPressed);
            }
        }
    }

    private static final class ContainerKeeper
    extends LayoutContainer {
        private final Container<?> parentContainer;

        private ContainerKeeper(Container<?> parentContainer) {
            this.parentContainer = parentContainer;
        }

        protected void onWindowResize(int aWidth, int aHeight) {
            super.onWindowResize(aWidth, aHeight);
            if (this.isVisible()) {
                this.setWidth(this.parentContainer.getWidth());
            }
        }
    }

    private static final class ExportEntitiesCallback
    extends AbstractAsyncCallback<String> {
        public ExportEntitiesCallback(IViewContext<ICommonClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(String exportDataKey) {
            URLMethodWithParameters methodWithParameters = new URLMethodWithParameters(GenericConstants.FILE_EXPORTER_DOWNLOAD_SERVLET_NAME);
            methodWithParameters.addParameter("exportDataKey", exportDataKey);
            methodWithParameters.addParameter("timestamp", Long.toString(System.currentTimeMillis()));
            WindowUtils.openWindow(methodWithParameters.toString());
        }
    }

    protected static interface ISelectedEntityInvoker<M> {
        public void invoke(M var1, boolean var2);
    }

    public final class ListEntitiesCallback
    extends AbstractAsyncCallback<ResultSet<TableModelRowWithObject<T>>> {
        private final AsyncCallback<PagingLoadResult<BaseEntityModel<TableModelRowWithObject<T>>>> delegate;
        private DefaultResultSetConfig<String, TableModelRowWithObject<T>> resultSetConfig;
        private int logID;
        private boolean reloadingPhase;

        public ListEntitiesCallback(IViewContext<?> viewContext, AsyncCallback<PagingLoadResult<BaseEntityModel<TableModelRowWithObject<T>>>> delegate, DefaultResultSetConfig<String, TableModelRowWithObject<T>> resultSetConfig) {
            super(viewContext);
            this.delegate = delegate;
            this.resultSetConfig = resultSetConfig;
            this.logID = TypedTableGrid.this.log("load data");
        }

        @Override
        public final void finishOnFailure(Throwable caught) {
            this.reenableAfterFailure();
            caught.printStackTrace();
            this.delegate.onFailure(caught);
        }

        public final void reenableAfterFailure() {
            TypedTableGrid.this.grid.el().unmask();
            this.onComplete(false);
            TypedTableGrid.this.pagingToolbar.enable();
        }

        @Override
        protected void performSuccessActionOrIgnore(final IDelegatedAction successAction) {
            if (TypedTableGrid.this.tableModificationsManager.isTableDirty()) {
                Listener<MessageBoxEvent> listener = new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent me) {
                        if (me.getButtonClicked().getItemId().equals("yes")) {
                            ((ListEntitiesCallback)ListEntitiesCallback.this).TypedTableGrid.this.tableModificationsManager.saveModifications();
                        } else {
                            ((ListEntitiesCallback)ListEntitiesCallback.this).TypedTableGrid.this.tableModificationsManager.cancelModifications();
                        }
                        successAction.execute();
                    }
                };
                String title = this.viewContext.getMessage("confirm_save_table_modifications_dialog_title", new Object[0]);
                String msg = this.viewContext.getMessage("confirm_save_table_modifications_dialog_message", new Object[0]);
                MessageBox.confirm((String)title, (String)msg, (Listener)listener);
            } else {
                successAction.execute();
            }
        }

        @Override
        protected final void process(ResultSet<TableModelRowWithObject<T>> result) {
            this.viewContext.logStop(this.logID);
            this.logID = TypedTableGrid.this.log("process loaded data");
            String key = result.getResultSetKey();
            TypedTableGrid.this.saveCacheKey(key);
            GridRowModels rowModels = result.getList();
            boolean partial = result.isPartial();
            if (this.reloadingPhase) {
                this.reloadingPhase = false;
            } else if (partial) {
                String sortField;
                this.reloadingPhase = true;
                BasePagingLoadConfig loadConfig = new BasePagingLoadConfig();
                loadConfig.setLimit(this.resultSetConfig.getLimit());
                loadConfig.setOffset(this.resultSetConfig.getOffset());
                SortInfo sortInfo = this.resultSetConfig.getSortInfo();
                if (sortInfo != null && (sortField = sortInfo.getSortField()) != null) {
                    loadConfig.setSortField(sortField);
                    loadConfig.setSortDir(TypedTableGrid.translate(sortInfo.getSortDir()));
                }
                this.resultSetConfig = TypedTableGrid.this.createPagingConfig((PagingLoadConfig)loadConfig, TypedTableGrid.this.filterToolbar.getFilters(), this.resultSetConfig.tryGetGridDisplayId());
                this.resultSetConfig.setCacheConfig(ResultSetFetchConfig.createFetchFromCacheAndRecompute(key));
                this.reuse();
                TypedTableGrid.this.listEntities(this.resultSetConfig, this);
            }
            List models = this.createModels(rowModels);
            BasePagingLoadResult loadResult = new BasePagingLoadResult(models, this.resultSetConfig.getOffset(), result.getTotalLength());
            this.delegate.onSuccess((Object)loadResult);
            TypedTableGrid.this.pagingToolbar.enableExportButton();
            TypedTableGrid.this.pagingToolbar.updateDefaultConfigButton(true);
            if (!this.reloadingPhase) {
                TypedTableGrid.this.pagingToolbar.enable();
                TypedTableGrid.this.filterToolbar.refreshColumnFiltersDistinctValues(rowModels.getColumnDistinctValues());
            } else {
                TypedTableGrid.this.pagingToolbar.disableForLoadingRest();
            }
            this.onComplete(true);
            this.viewContext.logStop(this.logID);
        }

        private void onComplete(boolean wasSuccessful) {
            TypedTableGrid.this.pendingFetchManager.popPendingFetch();
            TypedTableGrid.this.refreshCallback.postRefresh(wasSuccessful);
        }

        private List<BaseEntityModel<TableModelRowWithObject<T>>> createModels(GridRowModels<TableModelRowWithObject<T>> gridRowModels) {
            ArrayList result = new ArrayList();
            this.initializeModelCreation();
            for (GridRowModel gridRowModel : gridRowModels) {
                BaseEntityModel model = TypedTableGrid.this.createModel(gridRowModel);
                result.add(model);
            }
            return result;
        }

        private void initializeModelCreation() {
            Set visibleColumnIds = TypedTableGrid.this.getIDsOfVisibleColumns();
            List colDefinitions = TypedTableGrid.this.createColDefinitions();
            TypedTableGrid.this.visibleColDefinitions = new ArrayList();
            for (IColumnDefinitionUI definition : colDefinitions) {
                if (!visibleColumnIds.contains(definition.getIdentifier())) continue;
                TypedTableGrid.this.visibleColDefinitions.add(definition);
            }
        }

        @Override
        public String getCallbackId() {
            return TypedTableGrid.this.grid.getId();
        }
    }

    private static final class RefreshCallback
    extends AbstractAsyncCallback<Void> {
        private final IBrowserGridActionInvoker invoker;

        public RefreshCallback(IViewContext<?> viewContext, IBrowserGridActionInvoker invoker) {
            super(viewContext);
            this.invoker = invoker;
        }

        @Override
        protected void process(Void result) {
            this.invoker.refresh();
        }
    }

    private class TableModificationsManager {
        private final ModificationsData<T> modificationsData = new ModificationsData();

        private TableModificationsManager() {
        }

        public boolean isSaving() {
            return this.modificationsData.isSaving();
        }

        public boolean isTableDirty() {
            return !this.modificationsData.isApplyModificationsComplete() && !this.modificationsData.isSaving();
        }

        public void saveModifications() {
            this.modificationsData.handleModifications(new ModificationsData.IModificationsHandler<T>(){

                @Override
                public void applyModifications(BaseEntityModel<TableModelRowWithObject<T>> model, List<IModification> modifications) {
                    AsyncCallback callBack = TableModificationsManager.this.createApplyModificationsCallback(model, modifications);
                    TypedTableGrid.this.applyModifications(model, TypedTableGrid.this.resultSetKeyOrNull, modifications, (AsyncCallback<IUpdateResult>)callBack);
                }
            });
        }

        public void cancelModifications() {
            this.clearModifications();
            TypedTableGrid.this.grid.getStore().rejectChanges();
            TypedTableGrid.this.refresh();
        }

        public void handleEditingEvent(BaseEntityModel<TableModelRowWithObject<T>> model, String columnID, String newValueOrNull) {
            this.modificationsData.addModification(model, columnID, newValueOrNull);
        }

        private AsyncCallback<IUpdateResult> createApplyModificationsCallback(final BaseEntityModel<TableModelRowWithObject<T>> model, List<IModification> modifications) {
            return new AbstractAsyncCallback<IUpdateResult>(TypedTableGrid.this.viewContext){

                @Override
                protected void process(IUpdateResult result) {
                    this.processErrorMessage(result.tryGetErrorMessage());
                }

                @Override
                public void finishOnFailure(Throwable caught) {
                    this.processErrorMessage(caught.getMessage());
                }

                private void processErrorMessage(String errorMessageOrNull) {
                    TableModificationsManager.this.modificationsData.handleResponseAfterModificationHasBeenApplied(model, errorMessageOrNull);
                    if (TableModificationsManager.this.modificationsData.isApplyModificationsComplete()) {
                        TableModificationsManager.this.onApplyModificationsComplete(model);
                    }
                }
            };
        }

        private void onApplyModificationsComplete(BaseEntityModel<TableModelRowWithObject<T>> model) {
            if (this.modificationsData.hasFailedModifications()) {
                String failureTitle = this.modificationsData.createFailureTitle();
                String failureReport = this.modificationsData.createFailedModificationsReport();
                MessageBox.alert((String)failureTitle, (String)failureReport, null);
                TypedTableGrid.this.refresh();
            } else {
                GWTUtils.displayInfo("All modifications successfully applied.");
                model.setOutdated(true);
                model.set("MODIFIER", TypedTableGrid.this.viewContext.getModel().getLoggedInPerson());
                model.set("MODIFICATION_DATE", SimpleDateRenderer.renderDate(new DateTableCell(new Date()).getDateTime()));
                TypedTableGrid.this.grid.getStore().commitChanges();
            }
            this.clearModifications();
            this.refreshCacheSilently();
        }

        private void refreshCacheSilently() {
            DefaultResultSetConfig config = TypedTableGrid.this.createPagingConfig((PagingLoadConfig)new BasePagingLoadConfig(), TypedTableGrid.this.filterToolbar.getFilters(), TypedTableGrid.this.getGridDisplayTypeID());
            config.setCacheConfig(ResultSetFetchConfig.createRecomputeAndCache(TypedTableGrid.this.resultSetKeyOrNull));
            final int id = TypedTableGrid.this.log("refreshing cache silently");
            TypedTableGrid.this.listTableRows(config, new AbstractAsyncCallback<TypedTableResultSet<T>>(TypedTableGrid.this.viewContext){

                @Override
                protected void process(TypedTableResultSet<T> result) {
                    this.viewContext.logStop(id);
                }
            });
        }

        private void clearModifications() {
            this.modificationsData.clearData();
            TypedTableGrid.this.hideModificationsBar();
        }
    }

    private class TableModificationsToolbar
    extends ToolBar {
        public TableModificationsToolbar(IMessageProvider messageProvider, final TableModificationsManager manager) {
            this.add((Component)new Label(messageProvider.getMessage("table_modifications", new Object[0])));
            AbstractImagePrototype confirmIcon = AbstractImagePrototype.create((ImageResource)IMAGE_BUNDLE.getConfirmIcon());
            AbstractImagePrototype cancelIcon = AbstractImagePrototype.create((ImageResource)IMAGE_BUNDLE.getCancelIcon());
            this.add((Component)new Button("Save", confirmIcon, (SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent be) {
                    manager.saveModifications();
                }
            }));
            this.add((Component)new Button("Cancel", cancelIcon, (SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent be) {
                    manager.cancelModifications();
                }
            }));
        }
    }
}

