/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetComputeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetProcessingMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetReportGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DatastoreServiceDescriptionModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGeneratedCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DataSetGridUtils {
    public static AbstractExternalDataGrid extractBrowser(IDisposableComponent metadataComponent) {
        return (AbstractExternalDataGrid)metadataComponent.getComponent();
    }

    public static SelectionChangedListener<DatastoreServiceDescriptionModel> createReportSelectionChangedListener(final IViewContext<?> viewContext, final IDisposableComponent metadataComponent, final ReportGeneratedCallback.IOnReportComponentGeneratedAction reportGeneratedAction) {
        final AbstractExternalDataGrid browser = DataSetGridUtils.extractBrowser(metadataComponent);
        return new SelectionChangedListener<DatastoreServiceDescriptionModel>(){

            public void selectionChanged(SelectionChangedEvent<DatastoreServiceDescriptionModel> se) {
                DatastoreServiceDescriptionModel selectedItem = (DatastoreServiceDescriptionModel)se.getSelectedItem();
                if (selectedItem != null) {
                    DatastoreServiceDescription service = selectedItem.getBaseObject();
                    if (service.getLabel().equals("Overview")) {
                        this.showMetadataView();
                    } else {
                        this.showGeneratedReport(service);
                    }
                }
            }

            private void showMetadataView() {
                reportGeneratedAction.execute(metadataComponent);
            }

            private void showGeneratedReport(DatastoreServiceDescription service) {
                if (!$assertionsDisabled && service.getServiceKind() != DataStoreServiceKind.QUERIES) {
                    throw new AssertionError();
                }
                IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems> selectedAndDisplayedItemsAction = browser.getSelectedAndDisplayedItemsAction();
                if (browser.getSelectedItems().isEmpty()) {
                    DisplayedOrSelectedDatasetCriteria criteria = selectedAndDisplayedItemsAction.execute().createCriteria(false);
                    DataSetReportGenerator.generateAndInvoke(viewContext.getCommonViewContext(), service, criteria, reportGeneratedAction);
                } else {
                    DataSetComputeUtils.createComputeAction(viewContext.getCommonViewContext(), selectedAndDisplayedItemsAction, service, reportGeneratedAction).execute();
                }
            }
        };
    }

    public static interface IAddProcessingPluginsMenuAction {
        public void addProcessingPlugins(DataSetProcessingMenu var1);
    }

    public static final class LoadProcessingPluginsCallback
    extends AbstractAsyncCallback<List<DatastoreServiceDescription>> {
        private final AbstractExternalDataGrid browser;
        private final IAddProcessingPluginsMenuAction action;

        public LoadProcessingPluginsCallback(IViewContext<?> viewContext, AbstractExternalDataGrid browser, IAddProcessingPluginsMenuAction action) {
            super(viewContext);
            this.browser = browser;
            this.action = action;
        }

        @Override
        protected void process(List<DatastoreServiceDescription> result) {
            if (!result.isEmpty()) {
                ArrayList<DatastoreServiceDescription> filtered = new ArrayList<DatastoreServiceDescription>();
                HashSet<String> keys = new HashSet<String>();
                for (DatastoreServiceDescription desc : result) {
                    if (keys.contains(desc.getKey())) continue;
                    filtered.add(desc);
                    keys.add(desc.getKey());
                }
                DataSetProcessingMenu menu = new DataSetProcessingMenu(this.viewContext.getCommonViewContext(), this.browser.getSelectedAndDisplayedItemsAction(), filtered);
                this.action.addProcessingPlugins(menu);
            }
        }
    }
}

