/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentBrowserGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedIdHolderCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletionType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Collections;
import java.util.List;

public final class ExperimentListDeletionConfirmationDialog
extends AbstractDataListDeletionConfirmationDialog<Experiment> {
    private final ExperimentBrowserGrid.DisplayedAndSelectedExperiments selectedAndDisplayedItemsOrNull;
    private final Experiment singleDataOrNull;

    public ExperimentListDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, AsyncCallback<Void> callback, ExperimentBrowserGrid.DisplayedAndSelectedExperiments selectedAndDisplayedItems) {
        super(viewContext, selectedAndDisplayedItems.getExperiments(), callback);
        this.withRadio();
        this.singleDataOrNull = null;
        this.selectedAndDisplayedItemsOrNull = selectedAndDisplayedItems;
        this.setId("deletion-confirmation-dialog");
    }

    public ExperimentListDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, AsyncCallback<Void> deletionCallback, Experiment experiment) {
        super(viewContext, Collections.singletonList(experiment), deletionCallback);
        this.singleDataOrNull = experiment;
        this.selectedAndDisplayedItemsOrNull = null;
        this.setId("deletion-confirmation-dialog");
    }

    private IViewContext<ICommonClientServiceAsync> getViewContext() {
        return this.viewContext;
    }

    @Override
    protected void executeDeletion(AsyncCallback<Void> deletionCallback) {
        DeletionType deletionType = this.getDeletionType();
        if (this.selectedAndDisplayedItemsOrNull != null) {
            DisplayedOrSelectedIdHolderCriteria<TableModelRowWithObject<Experiment>> uploadCriteria = this.selectedAndDisplayedItemsOrNull.createCriteria(this.isOnlySelected());
            this.getViewContext().getCommonService().deleteExperiments(uploadCriteria, (String)this.reason.getValue(), deletionType, deletionCallback);
        } else {
            this.getViewContext().getCommonService().deleteExperiment(TechId.create(this.singleDataOrNull), (String)this.reason.getValue(), deletionType, deletionCallback);
        }
    }

    @Override
    protected String getEntityName() {
        return EntityKind.EXPERIMENT.getDescription();
    }

    @Override
    protected final RadioGroup createRadio() {
        IViewContext<ICommonClientServiceAsync> context = this.getViewContext();
        this.onlySelectedRadioOrNull = WidgetUtils.createRadio(context.getMessage("only_selected_radio", ((List)this.data).size()));
        return WidgetUtils.createAllOrSelectedRadioGroup(this.onlySelectedRadioOrNull, WidgetUtils.createRadio(context.getMessage("all_radio", this.selectedAndDisplayedItemsOrNull.getDisplayedItemsCount())), context.getMessage("experiments_radio_group_label", new Object[0]), ((List)this.data).size());
    }
}

