/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.entity;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.entity.PropertyTypesCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PropertyTypesFilterUtil {
    public static List<PropertyType> filterPropertyTypesForEntityKind(List<PropertyType> propertyTypes, EntityKind entityKind) {
        ArrayList<PropertyType> result = new ArrayList<PropertyType>();
        for (PropertyType st : propertyTypes) {
            if (PropertyTypesFilterUtil.getPropertyAssignments(st, entityKind).size() <= 0) continue;
            result.add(st);
        }
        return result;
    }

    public static PropertyTypesCriteria filterPropertyTypesForEntityTypes(PropertyTypesCriteria propertyTypesCriteriaOrNull, EntityKind entityKind, Set<? extends BasicEntityType> shownEntityTypesOrNull) {
        List<PropertyType> propertyTypes;
        if (propertyTypesCriteriaOrNull != null && shownEntityTypesOrNull != null && (propertyTypes = propertyTypesCriteriaOrNull.tryGetPropertyTypes()) != null) {
            propertyTypes = PropertyTypesFilterUtil.filterPropertyTypesForEntityTypes(propertyTypes, entityKind, shownEntityTypesOrNull);
            PropertyTypesCriteria newCriteria = new PropertyTypesCriteria();
            newCriteria.copyPagingConfig(propertyTypesCriteriaOrNull);
            newCriteria.setPropertyTypes(propertyTypes);
            return newCriteria;
        }
        return propertyTypesCriteriaOrNull;
    }

    private static List<PropertyType> filterPropertyTypesForEntityTypes(List<PropertyType> propertyTypes, EntityKind entityKind, Set<? extends BasicEntityType> entityTypes) {
        Set<String> entityTypesCodes = PropertyTypesFilterUtil.extractCodes(entityTypes);
        HashSet<PropertyType> result = new HashSet<PropertyType>();
        for (PropertyType propertyType : propertyTypes) {
            List<EntityTypePropertyType<?>> assignments = PropertyTypesFilterUtil.getPropertyAssignments(propertyType, entityKind);
            for (EntityTypePropertyType<?> assignment : assignments) {
                if (!entityTypesCodes.contains(((Code)assignment.getEntityType()).getCode())) continue;
                result.add(propertyType);
            }
        }
        return new ArrayList<PropertyType>(result);
    }

    private static Set<String> extractCodes(Set<? extends BasicEntityType> entityTypes) {
        HashSet<String> codes = new HashSet<String>();
        Iterator<? extends BasicEntityType> iterator = entityTypes.iterator();
        while (iterator.hasNext()) {
            codes.add(iterator.next().getCode());
        }
        return codes;
    }

    private static List<? extends EntityTypePropertyType<?>> getPropertyAssignments(PropertyType propertyType, EntityKind entityKind) {
        switch (entityKind) {
            case DATA_SET: {
                return propertyType.getDataSetTypePropertyTypes();
            }
            case EXPERIMENT: {
                return propertyType.getExperimentTypePropertyTypes();
            }
            case MATERIAL: {
                return propertyType.getMaterialTypePropertyTypes();
            }
            case SAMPLE: {
                return propertyType.getSampleTypePropertyTypes();
            }
        }
        throw new IllegalStateException("unknown enumerator " + entityKind);
    }

    public static List<PropertyType> filterSamplePropertyTypes(List<PropertyType> propertyTypes) {
        return PropertyTypesFilterUtil.filterPropertyTypesForEntityKind(propertyTypes, EntityKind.SAMPLE);
    }

    public static List<PropertyType> filterExperimentPropertyTypes(List<PropertyType> propertyTypes) {
        return PropertyTypesFilterUtil.filterPropertyTypesForEntityKind(propertyTypes, EntityKind.EXPERIMENT);
    }

    public static List<PropertyType> filterDataSetPropertyTypes(List<PropertyType> propertyTypes) {
        return PropertyTypesFilterUtil.filterPropertyTypesForEntityKind(propertyTypes, EntityKind.DATA_SET);
    }

    public static List<PropertyType> filterMaterialPropertyTypes(List<PropertyType> propertyTypes) {
        return PropertyTypesFilterUtil.filterPropertyTypesForEntityKind(propertyTypes, EntityKind.MATERIAL);
    }

    public static List<PropertyType> extractPropertyTypes(EntityType selectedType) {
        List<EntityTypePropertyType<?>> entityTypePropertyTypes = selectedType.getAssignedPropertyTypes();
        ArrayList<PropertyType> propertyTypes = new ArrayList<PropertyType>();
        for (EntityTypePropertyType<?> etpt : entityTypePropertyTypes) {
            propertyTypes.add(etpt.getPropertyType());
        }
        return propertyTypes;
    }
}

