/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisplayTypeIDProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter.FilterModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomFilter;
import java.util.Arrays;
import java.util.List;

public final class FilterSelectionWidget
extends DropDownList<FilterModel, GridCustomFilter> {
    private static final String LIST_ITEMS_CALLBACK = "ListItemsCallback";
    public static final String SUFFIX = "filter";
    private final IViewContext<?> viewContext;
    private final boolean withStandard;
    private final IDisplayTypeIDProvider displayTypeIDProvider;

    public FilterSelectionWidget(IViewContext<?> viewContext, String idSuffix, IDisplayTypeIDProvider displayTypeIDProvider) {
        super(viewContext, SUFFIX + idSuffix, SUFFIX, "name", SUFFIX, "filters");
        this.viewContext = viewContext;
        this.displayTypeIDProvider = displayTypeIDProvider;
        this.withStandard = true;
        this.setAutoSelectFirst(this.withStandard);
        this.setCallbackId(FilterSelectionWidget.createCallbackId());
        this.setSelection(Arrays.asList(FilterModel.COLUMN_FILTER_MODEL));
        this.setTemplate(GWTUtils.getTooltipTemplate("name", "tooltip"));
    }

    public static String createCallbackId() {
        return FilterSelectionWidget.class + LIST_ITEMS_CALLBACK;
    }

    @Override
    protected List<FilterModel> convertItems(List<GridCustomFilter> result) {
        return FilterModel.convert(result, this.withStandard);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<GridCustomFilter>> callback) {
        this.viewContext.getCommonService().listFilters(this.displayTypeIDProvider.getGridDisplayTypeID(), callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.GRID_CUSTOM_FILTER);
    }
}

