/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.managed_property;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.TableExportType;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.managed_property.ManagedPropertyGridActionDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetFetchConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableModelReference;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IManagedPropertyGridInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiTableAction;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.List;
import java.util.Set;

public class ManagedPropertyGrid
extends TypedTableGrid<ReportRowModel> {
    public static final String BROWSER_ID = "openbis_ManagedPropertyGrid";
    private final String resultSetKey;
    private final String gridKind;
    private final IDelegatedAction onRefreshAction;
    private final IManagedProperty managedProperty;
    private final IEntityInformationHolder entity;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext, TableModelReference tableModelReference, IEntityInformationHolder entity, IManagedProperty managedProperty, IManagedPropertyGridInformationProvider gridInformation, IDelegatedAction onRefreshAction) {
        ManagedPropertyGrid grid = new ManagedPropertyGrid(viewContext, tableModelReference, entity, managedProperty, gridInformation, onRefreshAction);
        return grid.asDisposableWithoutToolbar();
    }

    public static String createId(String idSuffix) {
        return "openbis_ManagedPropertyGrid_" + idSuffix;
    }

    private ManagedPropertyGrid(IViewContext<ICommonClientServiceAsync> viewContext, TableModelReference tableModelReference, IEntityInformationHolder entity, IManagedProperty managedProperty, IManagedPropertyGridInformationProvider gridInformation, IDelegatedAction onRefreshAction) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.DATA_SET_REPORTING_GRID);
        this.entity = entity;
        this.managedProperty = managedProperty;
        this.onRefreshAction = onRefreshAction;
        this.setId(BROWSER_ID);
        this.resultSetKey = tableModelReference.getResultSetKey();
        this.gridKind = gridInformation.getKey();
        this.updateDefaultRefreshButton();
        this.extendBottomToolbar();
    }

    private void extendBottomToolbar() {
        if (this.viewContext.isSimpleOrEmbeddedMode()) {
            return;
        }
        if (this.managedProperty.getUiDescription().getActions().size() > 0) {
            this.addEntityOperationsLabel();
            this.addEntityOperationButtons();
            this.addEntityOperationsSeparator();
        }
    }

    private void addEntityOperationButtons() {
        for (IManagedUiAction managedAction : this.managedProperty.getUiDescription().getActions()) {
            if (!(managedAction instanceof IManagedUiTableAction)) continue;
            final IManagedUiTableAction tableAction = (IManagedUiTableAction)managedAction;
            final String actionTitle = tableAction.getName();
            Button actionButton = new Button(actionTitle, (SelectionListener)new TypedTableGrid.AbstractCreateDialogListener(this){

                protected Dialog createDialog(List<TableModelRowWithObject<ReportRowModel>> data, IBrowserGridActionInvoker invoker) {
                    AbstractAsyncCallback callback = ManagedPropertyGrid.this.createRefreshCallback(invoker);
                    return new ManagedPropertyGridActionDialog(ManagedPropertyGrid.this.viewContext, actionTitle, data, callback, ManagedPropertyGrid.this.entity, ManagedPropertyGrid.this.managedProperty, tableAction);
                }
            });
            this.addButton(actionButton);
            switch (tableAction.getSelectionType()) {
                case REQUIRED: {
                    this.enableButtonOnSelectedItems(actionButton);
                    this.allowMultipleSelection();
                    break;
                }
                case REQUIRED_SINGLE: {
                    this.enableButtonOnSelectedItem(actionButton);
                    break;
                }
            }
        }
    }

    @Override
    public String getGridDisplayTypeID() {
        return this.createGridDisplayTypeID(this.gridKind);
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<ReportRowModel>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<ReportRowModel>> callback) {
        resultSetConfig.setCacheConfig(ResultSetFetchConfig.createFetchFromCacheAndRecompute(this.resultSetKey));
        ((ICommonClientServiceAsync)this.viewContext.getService()).listReport(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<ReportRowModel>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportReport(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SCRIPT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        super.update(observedModifications);
    }

    @Override
    protected IBrowserGridActionInvoker asActionInvoker() {
        final IBrowserGridActionInvoker delegate = super.asActionInvoker();
        return new IBrowserGridActionInvoker(){

            @Override
            public boolean supportsExportForUpdate() {
                return false;
            }

            @Override
            public void toggleFilters(boolean show) {
                delegate.toggleFilters(show);
            }

            @Override
            public void refresh() {
                ManagedPropertyGrid.this.onRefreshAction.execute();
            }

            @Override
            public void export(TableExportType type) {
                delegate.export(type);
            }

            @Override
            public void configure() {
                delegate.configure();
            }
        };
    }
}

