/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ShowResultSetCutInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.ISampleCriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleBrowserGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchToolbar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchWindow;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.IDetailedSearchHitGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.List;

public class SampleSearchHitGrid
extends SampleBrowserGrid
implements IDetailedSearchHitGrid {
    public static final String SEARCH_BROWSER_ID = "openbis_sample-search-hit-browser";

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        SampleBrowserGrid.SampleCriteriaProvider criteriaProvider = new SampleBrowserGrid.SampleCriteriaProvider(viewContext, ListSampleDisplayCriteria.createForSearch());
        SampleSearchHitGrid grid = new SampleSearchHitGrid(viewContext, criteriaProvider);
        DetailedSearchWindow searchWindow = new DetailedSearchWindow(viewContext, EntityKind.SAMPLE);
        DetailedSearchToolbar toolbar = new DetailedSearchToolbar(grid, viewContext.getMessage("button_change_query", new Object[0]), searchWindow);
        searchWindow.setUpdateListener(toolbar);
        return grid.asDisposableWithToolbar(toolbar);
    }

    public static IDisposableComponent createWithInitialDisplayCriteria(IViewContext<ICommonClientServiceAsync> viewContext, ListSampleDisplayCriteria displayCriteria) {
        SampleBrowserGrid.SampleCriteriaProvider criteriaProvider = new SampleBrowserGrid.SampleCriteriaProvider(viewContext, displayCriteria);
        SampleSearchHitGrid grid = new SampleSearchHitGrid(viewContext, criteriaProvider);
        DetailedSearchWindow searchWindow = new DetailedSearchWindow(viewContext, EntityKind.SAMPLE);
        searchWindow.setInitialSearchCriteria(displayCriteria.getSearchCriteria());
        DetailedSearchToolbar toolbar = new DetailedSearchToolbar(grid, viewContext.getMessage("button_change_query", new Object[0]), searchWindow, true);
        searchWindow.setUpdateListener(toolbar);
        return grid.asDisposableWithToolbar(toolbar);
    }

    private SampleSearchHitGrid(IViewContext<ICommonClientServiceAsync> viewContext, ISampleCriteriaProvider criteriaProvider) {
        super(viewContext, criteriaProvider, SEARCH_BROWSER_ID, false, DisplayTypeIDGenerator.SAMPLE_SEARCH_RESULT_GRID, DUMMY_DIRECTLY_CONNECTED_CONTROLLER);
        this.updateCriteriaProviderAndRefresh();
        this.extendBottomToolbar();
    }

    @Override
    protected void addEntityOperationButtons() {
        String showRelatedDatasetsTitle = this.viewContext.getMessage("show_related_datasets", new Object[0]);
        Button showRelatedDatasetsButton = new Button(showRelatedDatasetsTitle, (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                SampleSearchHitGrid.showRelatedDataSets(SampleSearchHitGrid.this.viewContext, SampleSearchHitGrid.this);
            }
        });
        this.addButton(showRelatedDatasetsButton);
        super.addEntityOperationButtons();
    }

    @Override
    public void refresh(DetailedSearchCriteria newCriteria, List<PropertyType> propertyTypes) {
        ListSampleDisplayCriteria criteriaOrNull = this.tryGetDisplayCriteria();
        assert (criteriaOrNull != null);
        criteriaOrNull.updateSearchCriteria(newCriteria);
        this.refresh();
    }

    @Override
    protected void refresh() {
        if (this.isAnySearchCriteriaSet()) {
            super.refresh();
        }
    }

    private boolean isAnySearchCriteriaSet() {
        ListSampleDisplayCriteria criteriaOrNull = this.tryGetDisplayCriteria();
        return criteriaOrNull != null && !criteriaOrNull.getSearchCriteria().isEmpty();
    }

    private ListSampleDisplayCriteria tryGetDisplayCriteria() {
        return this.getCriteriaProvider().tryGetCriteria();
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Sample>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Sample>> callback) {
        callback.addOnSuccessAction(new ShowResultSetCutInfo(this.viewContext));
        super.listTableRows(resultSetConfig, callback);
    }

    @Override
    public IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems> getSelectedAndDisplayedItemsAction() {
        throw new UnsupportedOperationException();
    }
}

