/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.google.gwt.user.client.ui.Widget;

public class MatchCriteriaRadio
extends HorizontalPanel {
    private static final String PREFIX = "match_criteria_radio";
    private static final String ID = "openbis_match_criteria_radio";
    public static final String OR_RADIO_ID = "openbis_match_criteria_radio_or";
    public static final String AND_RADIO_ID = "openbis_match_criteria_radio_and";
    private final Radio orRadio;
    private final Radio andRadio;

    public MatchCriteriaRadio(String matchAll, String matchAny) {
        RadioGroup group = new RadioGroup();
        this.andRadio = new Radio();
        this.andRadio.setId(AND_RADIO_ID);
        this.andRadio.setBoxLabel(matchAll);
        this.orRadio = new Radio();
        this.orRadio.setId(OR_RADIO_ID);
        this.orRadio.setBoxLabel(matchAny);
        group.add(this.andRadio);
        group.add(this.orRadio);
        this.reset();
        TableData radioData = new TableData(Style.HorizontalAlignment.CENTER, Style.VerticalAlignment.MIDDLE);
        radioData.setPadding(5);
        this.add((Widget)group, (LayoutData)radioData);
    }

    public void reset() {
        this.andRadio.setValue(Boolean.valueOf(true));
    }

    public void setValue(SearchCriteriaConnection connection) {
        if (connection == SearchCriteriaConnection.MATCH_ALL) {
            this.andRadio.setValue(Boolean.valueOf(true));
        } else {
            this.orRadio.setValue(Boolean.valueOf(true));
        }
    }

    String getSelectedLabel() {
        return this.isAndSelected() ? this.andRadio.getBoxLabel() : this.orRadio.getBoxLabel();
    }

    SearchCriteriaConnection getSelected() {
        if (this.isAndSelected()) {
            return SearchCriteriaConnection.MATCH_ALL;
        }
        return SearchCriteriaConnection.MATCH_ANY;
    }

    private boolean isAndSelected() {
        return this.andRadio.getValue() != null && this.andRadio.getValue() != false;
    }
}

