/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HTML;

public final class MultilineHTML
extends HTML {
    private static final String BR = DOM.toString((Element)DOM.createElement((String)"br"));

    public MultilineHTML(String html) {
        super(MultilineHTML.preserveWhitespace(html));
    }

    public void setMultilineHTML(String html) {
        this.setHTML(MultilineHTML.preserveWhitespace(html));
    }

    private static String preserveWhitespace(String html) {
        String result = html;
        result = result.replaceAll("\n\r", BR);
        result = result.replaceAll("[\n\r]", BR);
        result = result.replaceAll("\t", "&nbsp;&nbsp;&nbsp; ");
        result = result.replaceAll("[\t]", "&nbsp;&nbsp;&nbsp; ");
        result = result.replaceAll("  ", "&nbsp; ");
        return MultilineHTML.wrapUpInDivWithTooltip(result, result.replaceAll(BR, "&nbsp;"));
    }

    public static String wrapUpInDivWithTooltip(String text, String tooltip) {
        return MultilineHTML.wrapUpInDivWithTooltip(text, tooltip, null);
    }

    public static String wrapUpInDivWithTooltip(String text, String tooltip, String styleOrNull) {
        Element div = DOM.createDiv();
        div.setInnerHTML(text);
        if (styleOrNull != null) {
            div.setAttribute("style", styleOrNull);
        }
        div.setTitle(StringEscapeUtils.unescapeHtml(tooltip));
        return DOM.toString((Element)div);
    }
}

