/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.IWizardDataModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.IWizardState;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.WizardWorkflowModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.CenterLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.ui.Widget;

public class WizardPage<M extends IWizardDataModel>
extends LayoutContainer {
    private static final String _LEFT_CONTENT = "_left_content";
    public static final String PREVIOUS_BUTTON_LABEL_KEY = "wizard_page_previous_button_label";
    public static final String NEXT_BUTTON_LABEL_KEY = "wizard_page_next_button_label";
    public static final String FINISH_BUTTON_LABEL_KEY = "wizard_page_finish_button_label";
    private final IMessageProvider messageProvider;
    protected final M model;
    private final IWizardState state;
    private final LayoutContainer leftContent;
    private final LayoutContainer rightContent;
    private Button previousButton;
    private Button nextOrFinishButton;

    public WizardPage(IMessageProvider messageProvider, IWizardState state, M model) {
        super((Layout)new BorderLayout());
        this.messageProvider = messageProvider;
        this.state = state;
        this.model = model;
        LayoutContainer leftCenterPanel = new LayoutContainer((Layout)new CenterLayout());
        leftCenterPanel.setStyleAttribute("background-color", "white");
        this.add((Widget)leftCenterPanel, (LayoutData)new BorderLayoutData(Style.LayoutRegion.WEST, 0.3f, 50, 200));
        this.leftContent = new LayoutContainer((Layout)new RowLayout());
        leftCenterPanel.add((Widget)this.leftContent);
        ContentPanel rightPanel = new ContentPanel((Layout)new RowLayout());
        rightPanel.setHeaderVisible(false);
        this.add((Widget)rightPanel, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        LayoutContainer rightCenterPanel = new LayoutContainer((Layout)new RowLayout());
        this.rightContent = new LayoutContainer((Layout)new RowLayout());
        rightCenterPanel.add((Widget)this.rightContent, (LayoutData)new RowData(1.0, 1.0, new Margins(10)));
        rightPanel.add((Widget)rightCenterPanel);
        final WizardWorkflowModel workflowModel = model.getWorkflow();
        if (workflowModel.hasPreviousState(state)) {
            this.previousButton = new Button(messageProvider.getMessage(PREVIOUS_BUTTON_LABEL_KEY, new Object[0]));
            this.previousButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    workflowModel.previousState();
                }
            });
            rightPanel.addButton(this.previousButton);
        }
        String key = workflowModel.hasNextState(state) ? NEXT_BUTTON_LABEL_KEY : FINISH_BUTTON_LABEL_KEY;
        this.nextOrFinishButton = new Button(messageProvider.getMessage(key, new Object[0]));
        this.nextOrFinishButton.setEnabled(false);
        this.nextOrFinishButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                WizardPage.this.deactivate();
                workflowModel.nextState();
            }
        });
        rightPanel.addButton(this.nextOrFinishButton);
    }

    IWizardState getWizardState() {
        return this.state;
    }

    public void setLeftContentByDictionary() {
        this.setLeftContentBy((Component)new Html(this.messageProvider.getMessage(this.state + _LEFT_CONTENT, new Object[0])));
    }

    public void setLeftContentBy(Component component) {
        this.leftContent.removeAll();
        this.leftContent.add((Widget)component, (LayoutData)new RowData(1.0, 1.0, new Margins(10)));
    }

    public void addToRightContent(Component component, RowData layoutData) {
        this.rightContent.add((Widget)component, (LayoutData)layoutData);
    }

    public void enableNextButton(boolean enabled) {
        this.nextOrFinishButton.setEnabled(enabled);
    }

    public void init() {
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public void destroy() {
    }
}

