/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.SpaceOwnerKind;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomColumnPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomFilterPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.classic.Session;

public final class AuthorizationDataProvider
implements IAuthorizationDataProvider {
    private final IAuthorizationDAOFactory daoFactory;
    private final Map<String, DatabaseInstancePE> codeToDbInstanceMap = new HashMap<String, DatabaseInstancePE>();
    private final Map<String, DatabaseInstancePE> uuidToDbInstanceMap = new HashMap<String, DatabaseInstancePE>();
    private final DatabaseInstancePE homeDatabaseInstance;

    public AuthorizationDataProvider(IAuthorizationDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
        if (daoFactory != null) {
            this.homeDatabaseInstance = daoFactory.getDatabaseInstanceDAO().getHomeInstance();
            for (DatabaseInstancePE instance : daoFactory.getDatabaseInstanceDAO().listDatabaseInstances()) {
                this.codeToDbInstanceMap.put(instance.getCode(), instance);
                this.uuidToDbInstanceMap.put(instance.getUuid(), instance);
            }
        } else {
            this.homeDatabaseInstance = null;
        }
    }

    @Override
    public List<SpacePE> listSpaces() {
        return this.daoFactory.getSpaceDAO().listSpaces();
    }

    @Override
    public SpacePE tryGetSpace(DatabaseInstancePE databaseInstance, String spaceCode) {
        return this.daoFactory.getSpaceDAO().tryFindSpaceByCodeAndDatabaseInstance(spaceCode, this.homeDatabaseInstance);
    }

    @Override
    public ExperimentPE tryGetExperimentByPermId(String permId) {
        return this.daoFactory.getExperimentDAO().tryGetByPermID(permId);
    }

    @Override
    public SamplePE tryGetSampleByPermId(String permId) {
        return this.daoFactory.getSampleDAO().tryToFindByPermID(permId);
    }

    @Override
    public DatabaseInstancePE getHomeDatabaseInstance() {
        return this.homeDatabaseInstance;
    }

    @Override
    public DatabaseInstancePE tryFindDatabaseInstanceByCode(String databaseInstanceCode) {
        return this.codeToDbInstanceMap.get(databaseInstanceCode);
    }

    @Override
    public DatabaseInstancePE tryFindDatabaseInstanceByUUID(String databaseInstanceUUID) {
        return this.uuidToDbInstanceMap.get(databaseInstanceUUID);
    }

    @Override
    public ProjectPE tryGetProjectByPermId(PermId permId) {
        return this.daoFactory.getProjectDAO().tryGetByPermID(permId.getId());
    }

    @Override
    public ProjectPE tryGetProjectByIdentifier(ProjectIdentifier identifier) {
        return this.daoFactory.getProjectDAO().tryFindProject(identifier.getDatabaseInstanceCode(), identifier.getSpaceCode(), identifier.getProjectCode());
    }

    @Override
    public ProjectPE tryGetProjectForDataSet(String dataSetCode) {
        DataPE dataSet = this.daoFactory.getDataDAO().tryToFindDataSetByCode(dataSetCode);
        if (dataSet != null && dataSet.getExperiment() != null) {
            return dataSet.getExperiment().getProject();
        }
        return null;
    }

    @Override
    public DataSetAccessPE tryGetDatasetAccessData(String dataSetCode) {
        Set<DataSetAccessPE> results = this.getDatasetCollectionAccessData(Arrays.asList(dataSetCode));
        if (results.size() < 1) {
            return null;
        }
        return results.iterator().next();
    }

    @Override
    public Set<DataSetAccessPE> getDatasetCollectionAccessData(final List<String> dataSetCodes) {
        Session sess = this.daoFactory.getSessionFactory().getCurrentSession();
        final Query query = sess.getNamedQuery("dataset_access");
        query.setReadOnly(true);
        final HashSet<DataSetAccessPE> fullResults = new HashSet<DataSetAccessPE>();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<String>(){

            @Override
            public void execute(List<String> entities) {
                query.setParameterList("codes", entities);
                List results = AuthorizationDataProvider.cast(query.list());
                fullResults.addAll(results);
            }

            @Override
            public List<String> getAllEntities() {
                return dataSetCodes;
            }

            @Override
            public String getEntityName() {
                return "dataset";
            }

            @Override
            public String getOperationName() {
                return "authorization";
            }
        });
        return fullResults;
    }

    @Override
    public Set<SampleAccessPE> getSampleCollectionAccessData(final List<TechId> sampleTechIds) {
        Session sess = this.daoFactory.getSessionFactory().getCurrentSession();
        final Query querySpaceSamples = sess.getNamedQuery("space_sample_access");
        querySpaceSamples.setReadOnly(true);
        final Query querySharedSamples = sess.getNamedQuery("shared_sample_access");
        querySharedSamples.setReadOnly(true);
        final HashSet<SampleAccessPE> fullResults = new HashSet<SampleAccessPE>();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<TechId>(){

            @Override
            public void execute(List<TechId> entities) {
                querySpaceSamples.setParameterList("ids", TechId.asLongs(entities));
                querySharedSamples.setParameterList("ids", TechId.asLongs(entities));
                List spaceSamples = AuthorizationDataProvider.cast(querySpaceSamples.list());
                List sharedSamples = AuthorizationDataProvider.cast(querySharedSamples.list());
                fullResults.addAll(spaceSamples);
                fullResults.addAll(sharedSamples);
            }

            @Override
            public List<TechId> getAllEntities() {
                return sampleTechIds;
            }

            @Override
            public String getEntityName() {
                return "sample";
            }

            @Override
            public String getOperationName() {
                return "authorization";
            }
        });
        return fullResults;
    }

    @Override
    public Set<DataSetAccessPE> getDeletedDatasetCollectionAccessData(final List<TechId> deletionIds) {
        Session sess = this.daoFactory.getSessionFactory().getCurrentSession();
        final Query query = sess.getNamedQuery("deleted_dataset_access");
        query.setReadOnly(true);
        final HashSet<DataSetAccessPE> fullResults = new HashSet<DataSetAccessPE>();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<TechId>(){

            @Override
            public void execute(List<TechId> entities) {
                query.setParameterList("del_ids", TechId.asLongs(entities));
                List results = AuthorizationDataProvider.cast(query.list());
                fullResults.addAll(results);
            }

            @Override
            public List<TechId> getAllEntities() {
                return deletionIds;
            }

            @Override
            public String getEntityName() {
                return "deletion";
            }

            @Override
            public String getOperationName() {
                return "authorization";
            }
        });
        return fullResults;
    }

    @Override
    public Set<SampleAccessPE> getDeletedSampleCollectionAccessData(final List<TechId> deletionIds) {
        Session sess = this.daoFactory.getSessionFactory().getCurrentSession();
        final Query querySpaceSamples = sess.getNamedQuery("deleted_space_sample_access");
        querySpaceSamples.setReadOnly(true);
        final Query querySharedSamples = sess.getNamedQuery("deleted_shared_sample_access");
        querySharedSamples.setReadOnly(true);
        final HashSet<SampleAccessPE> fullResults = new HashSet<SampleAccessPE>();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<TechId>(){

            @Override
            public void execute(List<TechId> entities) {
                querySpaceSamples.setParameterList("del_ids", TechId.asLongs(entities));
                querySharedSamples.setParameterList("del_ids", TechId.asLongs(entities));
                List spaceSamples = AuthorizationDataProvider.cast(querySpaceSamples.list());
                List sharedSamples = AuthorizationDataProvider.cast(querySharedSamples.list());
                fullResults.addAll(spaceSamples);
                fullResults.addAll(sharedSamples);
            }

            @Override
            public List<TechId> getAllEntities() {
                return deletionIds;
            }

            @Override
            public String getEntityName() {
                return "deletion";
            }

            @Override
            public String getOperationName() {
                return "authorization";
            }
        });
        return fullResults;
    }

    @Override
    public Set<ExperimentAccessPE> getDeletedExperimentCollectionAccessData(final List<TechId> deletionIds) {
        Session sess = this.daoFactory.getSessionFactory().getCurrentSession();
        final Query query = sess.getNamedQuery("deleted_experiment_access");
        query.setReadOnly(true);
        final HashSet<ExperimentAccessPE> fullResults = new HashSet<ExperimentAccessPE>();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<TechId>(){

            @Override
            public void execute(List<TechId> entities) {
                query.setParameterList("del_ids", TechId.asLongs(entities));
                List results = AuthorizationDataProvider.cast(query.list());
                fullResults.addAll(results);
            }

            @Override
            public List<TechId> getAllEntities() {
                return deletionIds;
            }

            @Override
            public String getEntityName() {
                return "deletion";
            }

            @Override
            public String getOperationName() {
                return "authorization";
            }
        });
        return fullResults;
    }

    @Override
    public SpacePE tryGetSpace(SpaceOwnerKind kind, TechId techId) {
        switch (kind) {
            case DATASET: {
                DataPE dataset = (DataPE)this.daoFactory.getDataDAO().getByTechId(techId);
                return dataset.getSpace();
            }
            case EXPERIMENT: {
                ExperimentPE experiment = (ExperimentPE)this.daoFactory.getExperimentDAO().getByTechId(techId);
                return experiment.getProject().getSpace();
            }
            case SPACE: {
                SpacePE space = (SpacePE)this.daoFactory.getSpaceDAO().getByTechId(techId);
                return space;
            }
            case PROJECT: {
                ProjectPE project = (ProjectPE)this.daoFactory.getProjectDAO().getByTechId(techId);
                return project.getSpace();
            }
        }
        return null;
    }

    @Override
    public Set<SpacePE> getDistinctSpacesByEntityIds(SpaceOwnerKind kind, List<TechId> techIds) {
        HashSet<SpacePE> spaces = new HashSet<SpacePE>();
        List<Long> ids = TechId.asLongs(techIds);
        switch (kind) {
            case DATASET: {
                spaces.addAll(this.daoFactory.getDataDAO().listSpacesByDataSetIds(ids));
                break;
            }
            case EXPERIMENT: {
                spaces.addAll(this.daoFactory.getExperimentDAO().listSpacesByExperimentIds(ids));
                break;
            }
            case SPACE: {
                List<SpacePE> allSpaces = this.daoFactory.getSpaceDAO().listSpaces();
                HashSet<Long> idSet = new HashSet<Long>(ids);
                for (SpacePE space : allSpaces) {
                    if (!idSet.contains(space.getId())) continue;
                    spaces.add(space);
                }
                break;
            }
            case PROJECT: {
                List<ProjectPE> projects = this.daoFactory.getProjectDAO().listProjects();
                HashSet<Long> idSet2 = new HashSet<Long>(ids);
                for (ProjectPE project : projects) {
                    if (!idSet2.contains(project.getId())) continue;
                    spaces.add(project.getSpace());
                }
                break;
            }
        }
        return spaces;
    }

    @Override
    public SamplePE getSample(TechId techId) {
        return (SamplePE)this.daoFactory.getSampleDAO().getByTechId(techId);
    }

    @Override
    public GridCustomFilterPE getGridCustomFilter(TechId techId) {
        return (GridCustomFilterPE)this.daoFactory.getGridCustomFilterDAO().getByTechId(techId);
    }

    @Override
    public GridCustomColumnPE getGridCustomColumn(TechId techId) {
        return (GridCustomColumnPE)this.daoFactory.getGridCustomColumnDAO().getByTechId(techId);
    }

    @Override
    public QueryPE getQuery(TechId techId) {
        return (QueryPE)this.daoFactory.getQueryDAO().getByTechId(techId);
    }

    @Override
    public List<DeletionPE> getDeletions(List<TechId> deletionIds) {
        return this.daoFactory.getDeletionDAO().findAllById(TechId.asLongs(deletionIds));
    }

    @Override
    public MetaprojectPE getMetaproject(TechId id) {
        return (MetaprojectPE)this.daoFactory.getMetaprojectDAO().getByTechId(id);
    }

    private static final <T> List<T> cast(List list) {
        return list;
    }
}

