/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.jython.JythonUtils;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICorePluginTable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.IMasterDataScriptRegistrationRunner;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataRegistrationException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.ICorePluginResourceLoader;
import ch.systemsx.cisd.openbis.generic.shared.dto.CorePluginPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.CorePluginTranslator;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class CorePluginTable
extends AbstractBusinessObject
implements ICorePluginTable {
    private final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, this.getClass());
    public static final String INIT_MASTER_DATA_SCRIPT = "initialize-master-data.py";
    private final IMasterDataScriptRegistrationRunner masterDataScriptRunner;

    public CorePluginTable(IDAOFactory daoFactory, Session session, IMasterDataScriptRegistrationRunner masterDataScriptRunner, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
        this.masterDataScriptRunner = masterDataScriptRunner;
    }

    @Override
    public List<CorePlugin> listCorePluginsByName(String name) {
        List<CorePluginPE> pluginPEs = this.getCorePluginDAO().listCorePluginsByName(name);
        return CorePluginTranslator.translate(pluginPEs);
    }

    @Override
    public void registerPlugin(CorePlugin plugin, ICorePluginResourceLoader resourceLoader) {
        assert (plugin != null) : "Unspecified plugin.";
        if (this.isNewVersionDetected(plugin)) {
            this.installNewPluginVersion(plugin, resourceLoader);
        } else {
            this.operationLog.info((Object)("Deployed core plugin detected :" + plugin));
        }
    }

    private boolean isNewVersionDetected(CorePlugin plugin) {
        List<CorePluginPE> installedVersions = this.getCorePluginDAO().listCorePluginsByName(plugin.getName());
        if (installedVersions.isEmpty()) {
            return true;
        }
        CorePluginPE latestVersionInstalled = Collections.max(installedVersions);
        return latestVersionInstalled.getVersion() < plugin.getVersion();
    }

    private void installNewPluginVersion(CorePlugin plugin, ICorePluginResourceLoader resourceLoader) {
        String masterDataScript = resourceLoader.tryLoadToString(plugin, INIT_MASTER_DATA_SCRIPT);
        String masterDataScriptPath = resourceLoader.getPath(plugin, INIT_MASTER_DATA_SCRIPT);
        if (!StringUtils.isEmpty((String)masterDataScript)) {
            String[] jythonPath = JythonUtils.getScriptDirectoryPythonPath(masterDataScriptPath);
            this.runInitializeMasterDataScript(plugin, masterDataScript, jythonPath);
            CorePluginPE pluginPE = CorePluginTranslator.translate(plugin, masterDataScript);
            this.getCorePluginDAO().createCorePlugins(Collections.singletonList(pluginPE));
            this.operationLog.info((Object)(plugin + " installed succesfully."));
        } else {
            this.operationLog.info((Object)String.format("No '%s' script found for '%s'. Skipping..", INIT_MASTER_DATA_SCRIPT, plugin));
        }
    }

    private void runInitializeMasterDataScript(CorePlugin plugin, String masterDataScript, String[] jythonPath) {
        this.operationLog.info((Object)("Executing master data initialization script for plugin '" + plugin + "'..."));
        try {
            this.masterDataScriptRunner.executeScript(masterDataScript, jythonPath);
        }
        catch (MasterDataRegistrationException mdre) {
            Log4jSimpleLogger errorLogger = new Log4jSimpleLogger(this.operationLog);
            errorLogger.log(LogLevel.ERROR, String.format("Failed to commit all transactions in the master data registration script for plugin '%s'.", plugin));
            mdre.logErrors(errorLogger);
            throw ConfigurationFailureException.fromTemplate("Failed to run iniitalization script '%s'", plugin);
        }
    }
}

