/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentTable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewBasicExperiment;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public final class ExperimentTable
extends AbstractBusinessObject
implements IExperimentTable {
    private List<ExperimentPE> experiments;
    private List<List<AttachmentPE>> attachmentListsOrNull;
    private boolean dataChanged = false;
    private IRelationshipService relationshipService;
    static final String ERR_PROJECT_NOT_FOUND = "No project for experiment '%s' could be found in the database.";

    ExperimentTable(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter converter, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, converter, managedPropertyEvaluatorFactory);
    }

    public ExperimentTable(IDAOFactory daoFactory, Session session, IRelationshipService relationshipService, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, EntityKind.EXPERIMENT, managedPropertyEvaluatorFactory);
        this.relationshipService = relationshipService;
    }

    @Override
    public void loadByIds(Collection<Long> experimentIds) {
        this.experiments = this.getExperimentDAO().listByIDs(experimentIds);
    }

    @Override
    public final void load(String experimentTypeCode, ProjectIdentifier projectIdentifier) {
        this.checkNotNull(experimentTypeCode, projectIdentifier);
        this.load(experimentTypeCode, Collections.singletonList(projectIdentifier), false, false);
    }

    @Override
    public final void load(String experimentTypeCode, List<ProjectIdentifier> projectIdentifiers, boolean onlyHavingSamples, boolean onlyHavingDataSets) {
        this.checkNotNull(experimentTypeCode, projectIdentifiers);
        this.fillSpaceIdentifiers(projectIdentifiers);
        List<ProjectPE> projects = this.getProjectDAO().tryFindProjects(projectIdentifiers);
        this.checkNotNull(projectIdentifiers, projects);
        if (EntityType.isAllTypesCode(experimentTypeCode)) {
            this.experiments = this.getExperimentDAO().listExperimentsWithProperties(projects, onlyHavingSamples, onlyHavingDataSets);
        } else {
            EntityTypePE entityType = this.getEntityTypeDAO(EntityKind.EXPERIMENT).tryToFindEntityTypeByCode(experimentTypeCode);
            this.checkNotNull(experimentTypeCode, entityType);
            this.experiments = this.getExperimentDAO().listExperimentsWithProperties((ExperimentTypePE)entityType, projects, null, onlyHavingSamples, onlyHavingDataSets);
        }
        this.attachmentListsOrNull = null;
    }

    @Override
    public final void load(String experimentTypeCode, SpaceIdentifier spaceIdentifier) {
        this.checkNotNull(experimentTypeCode, spaceIdentifier);
        this.fillSpaceIdentifier(spaceIdentifier);
        SpacePE space = this.getSpaceDAO().tryFindSpaceByCodeAndDatabaseInstance(spaceIdentifier.getSpaceCode(), this.getHomeDatabaseInstance());
        this.checkNotNull(spaceIdentifier, space);
        if (EntityType.isAllTypesCode(experimentTypeCode)) {
            this.experiments = this.getExperimentDAO().listExperimentsWithProperties(space);
        } else {
            EntityTypePE entityType = this.getEntityTypeDAO(EntityKind.EXPERIMENT).tryToFindEntityTypeByCode(experimentTypeCode);
            this.checkNotNull(experimentTypeCode, entityType);
            this.experiments = this.getExperimentDAO().listExperimentsWithProperties((ExperimentTypePE)entityType, null, space);
        }
        this.attachmentListsOrNull = null;
    }

    @Override
    public final void load(Collection<ExperimentIdentifier> identifiers) {
        this.checkNotEmpty(identifiers);
        this.experiments = this.listExperimentsByIdentifiers(identifiers);
        this.attachmentListsOrNull = null;
    }

    private void checkNotNull(SpaceIdentifier spaceIdentifier, SpacePE space) {
        if (space == null) {
            throw new UserFailureException("Space '" + spaceIdentifier + "' unknown.");
        }
    }

    private void checkNotNull(List<ProjectIdentifier> projectIdentifiers, List<ProjectPE> projects) {
        HashSet<ProjectIdentifier> unknownProjectIdentifiers = new HashSet<ProjectIdentifier>();
        if (projectIdentifiers != null) {
            for (ProjectIdentifier projectIdentifier : projectIdentifiers) {
                if (projectIdentifier == null) continue;
                unknownProjectIdentifiers.add(IdentifierHelper.createFullProjectIdentifier(projectIdentifier, this.getHomeDatabaseInstance()));
            }
        }
        if (projects != null) {
            for (ProjectPE project : projects) {
                if (project == null) continue;
                unknownProjectIdentifiers.remove(IdentifierHelper.createFullProjectIdentifier(project));
            }
        }
        if (!unknownProjectIdentifiers.isEmpty()) {
            throw new UserFailureException("Projects '" + unknownProjectIdentifiers + "' unknown.");
        }
    }

    private void checkNotNull(String experimentTypeCode, EntityTypePE entityType) {
        if (entityType == null) {
            throw new UserFailureException("Unknown experiment type '" + experimentTypeCode + "'.");
        }
    }

    private void checkNotNull(String experimentTypeCode, SpaceIdentifier projectIdentifier) {
        if (experimentTypeCode == null) {
            throw new UserFailureException("Experiment type not specified.");
        }
        if (projectIdentifier == null) {
            throw new UserFailureException("Project not specified.");
        }
    }

    private void checkNotNull(String experimentTypeCode, List<ProjectIdentifier> projectIdentifiers) {
        if (experimentTypeCode == null) {
            throw new UserFailureException("Experiment type not specified.");
        }
        if (projectIdentifiers == null || projectIdentifiers.isEmpty()) {
            throw new UserFailureException("Projects not specified.");
        }
    }

    private void checkNotEmpty(Collection<ExperimentIdentifier> identifiers) {
        if (identifiers == null || identifiers.isEmpty()) {
            throw new UserFailureException("Experiment identifiers cannot be NULL or empty.");
        }
    }

    @Override
    public final List<ExperimentPE> getExperiments() {
        assert (this.experiments != null) : "Experiments have not been loaded.";
        return this.experiments;
    }

    @Override
    public void add(List<NewBasicExperiment> entities, ExperimentTypePE experimentTypePE) {
        this.experiments = new ArrayList<ExperimentPE>();
        this.attachmentListsOrNull = null;
        this.setBatchUpdateMode(true);
        for (NewBasicExperiment ne : entities) {
            this.experiments.add(this.createExperiment(ne, experimentTypePE));
        }
        this.setBatchUpdateMode(false);
        this.dataChanged = true;
    }

    @Override
    public void prepareForUpdate(List<ExperimentBatchUpdatesDTO> updates) {
        assert (updates != null) : "Unspecified experiments.";
        this.setBatchUpdateMode(true);
        this.experiments = this.loadExperiments(updates);
        this.attachmentListsOrNull = new ArrayList<List<AttachmentPE>>(this.experiments.size());
        HashMap<String, ExperimentPE> experimentsByIdentifier = new HashMap<String, ExperimentPE>();
        for (ExperimentPE experiment : this.experiments) {
            experimentsByIdentifier.put(experiment.getIdentifier(), experiment);
        }
        for (ExperimentBatchUpdatesDTO experimentUpdates : updates) {
            ExperimentPE experiment = (ExperimentPE)experimentsByIdentifier.get(experimentUpdates.getOldExperimentIdentifier().toString());
            ArrayList<AttachmentPE> attachments = new ArrayList<AttachmentPE>();
            this.prepareBatchUpdate(experiment, attachments, experimentUpdates);
            this.attachmentListsOrNull.add(attachments);
        }
        this.dataChanged = true;
        this.setBatchUpdateMode(false);
    }

    private void prepareBatchUpdate(ExperimentPE experiment, List<AttachmentPE> attachments, ExperimentBatchUpdatesDTO updates) {
        if (experiment == null) {
            throw UserFailureException.fromTemplate("No experiment could be found with given identifier '%s'.", updates.getOldExperimentIdentifier());
        }
        experiment.setModifier(this.findPerson());
        experiment.setModificationDate(new Date());
        ExperimentBatchUpdateDetails details = updates.getDetails();
        this.batchUpdateProperties(experiment, updates.getProperties(), details.getPropertiesToUpdate());
        if (updates.isProjectUpdateRequested()) {
            ProjectPE project;
            ProjectPE previousProject = experiment.getProject();
            if (previousProject.equals(project = this.findProject(updates.getProjectIdentifier()))) {
                return;
            }
            this.relationshipService.assignExperimentToProject(this.session, experiment, project);
        }
        this.addAttachments(experiment, updates.getAttachments(), attachments);
    }

    private ProjectPE findProject(ProjectIdentifier newProjectIdentifier) {
        ProjectPE project = this.getProjectDAO().tryFindProject(newProjectIdentifier.getDatabaseInstanceCode(), newProjectIdentifier.getSpaceCode(), newProjectIdentifier.getProjectCode());
        if (project == null) {
            throw UserFailureException.fromTemplate(ERR_PROJECT_NOT_FOUND, newProjectIdentifier);
        }
        return project;
    }

    private void batchUpdateProperties(ExperimentPE experiment, List<IEntityProperty> properties, Set<String> propertiesToUpdate) {
        Set<ExperimentPropertyPE> existingProperties = experiment.getProperties();
        ExperimentTypePE type = experiment.getExperimentType();
        PersonPE registrator = this.findPerson();
        experiment.setProperties(this.entityPropertiesConverter.updateProperties(existingProperties, type, properties, registrator, propertiesToUpdate));
    }

    private List<ExperimentPE> loadExperiments(List<ExperimentBatchUpdatesDTO> updates) {
        ArrayList<ExperimentPE> results = new ArrayList<ExperimentPE>();
        ArrayList<ExperimentIdentifier> identifiers = new ArrayList<ExperimentIdentifier>();
        for (ExperimentBatchUpdatesDTO sampleUpdates : updates) {
            ExperimentIdentifier identifier = sampleUpdates.getOldExperimentIdentifier();
            identifiers.add(identifier);
        }
        results.addAll(this.listExperimentsByIdentifiers(identifiers));
        return results;
    }

    protected List<ExperimentPE> listExperimentsByIdentifiers(Collection<ExperimentIdentifier> experimentIdentifiers) {
        assert (experimentIdentifiers != null) : "Experiment identifiers unspecified.";
        IExperimentDAO experimentDAO = this.getExperimentDAO();
        ArrayList<ExperimentPE> results = new ArrayList<ExperimentPE>();
        List<ExperimentPE> allExperiments = experimentDAO.listExperiments();
        HashSet<String> desiredIds = new HashSet<String>(experimentIdentifiers.size());
        for (ExperimentIdentifier experimentId : experimentIdentifiers) {
            desiredIds.add(experimentId.toString());
        }
        for (ExperimentPE experiment : allExperiments) {
            if (!desiredIds.contains(experiment.getIdentifier())) continue;
            results.add(experiment);
        }
        return results;
    }

    private ExperimentPE createExperiment(NewBasicExperiment newExperiment, ExperimentTypePE experimentTypePE) {
        ExperimentPE result = new ExperimentPE();
        result.setExperimentType(experimentTypePE);
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifierFactory(newExperiment.getIdentifier()).createIdentifier();
        result.setCode(experimentIdentifier.getExperimentCode());
        PersonPE registrator = this.findPerson();
        result.setRegistrator(registrator);
        this.defineExperimentProperties(result, experimentTypePE.getCode(), newExperiment.getProperties(), registrator);
        this.defineExperimentProject(result, experimentIdentifier);
        result.setPermId(this.getOrCreatePermID(newExperiment));
        return result;
    }

    private void defineExperimentProject(ExperimentPE result, ExperimentIdentifier experimentIdentifier) {
        ProjectPE project = this.getProjectDAO().tryFindProject(experimentIdentifier.getDatabaseInstanceCode(), experimentIdentifier.getSpaceCode(), experimentIdentifier.getProjectCode());
        if (project == null) {
            throw UserFailureException.fromTemplate(ERR_PROJECT_NOT_FOUND, experimentIdentifier);
        }
        result.setProject(project);
    }

    private final void defineExperimentProperties(ExperimentPE result, String experimentTypeCode, IEntityProperty[] experimentProperties, PersonPE registrator) {
        List properties = this.entityPropertiesConverter.convertProperties(experimentProperties, experimentTypeCode, registrator);
        for (ExperimentPropertyPE experimentProperty : properties) {
            result.addProperty(experimentProperty);
        }
    }

    @Override
    public void save() {
        assert (this.experiments != null) : "Experiments not loaded.";
        if (this.dataChanged) {
            try {
                this.checkBusinessRules();
                this.getExperimentDAO().createOrUpdateExperiments(this.experiments, this.findPerson());
            }
            catch (DataAccessException ex) {
                ExperimentTable.throwException(ex, String.format("One of experiments", new Object[0]));
            }
            this.dataChanged = false;
        }
        this.saveAttachments(this.experiments, this.attachmentListsOrNull);
    }

    private void checkBusinessRules() {
        HashMap<EntityTypePE, List<EntityTypePropertyTypePE>> cache = new HashMap<EntityTypePE, List<EntityTypePropertyTypePE>>();
        for (ExperimentPE m : this.experiments) {
            this.entityPropertiesConverter.checkMandatoryProperties(m.getProperties(), m.getExperimentType(), cache);
        }
    }
}

