/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="core_plugins", uniqueConstraints={@UniqueConstraint(columnNames={"name", "version"})})
public final class CorePluginPE
implements Comparable<CorePluginPE> {
    private transient Long id;
    private String name;
    private Date registrationDate;
    private int version;
    private String masterDataRegistrationScript;

    @SequenceGenerator(name="CORE_PLUGIN_ID_SEQ", sequenceName="CORE_PLUGIN_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CORE_PLUGIN_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="name")
    @NotNull(message="Name can not be null.")
    public final String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public final Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public final void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @NotNull
    @Column(name="version", updatable=false)
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Column(name="master_reg_script")
    public String getMasterDataRegistrationScript() {
        return this.masterDataRegistrationScript;
    }

    public void setMasterDataRegistrationScript(String masterDataRegistrationScript) {
        this.masterDataRegistrationScript = masterDataRegistrationScript;
    }

    @Override
    public int compareTo(CorePluginPE other) {
        if (this.version != other.version) {
            return this.version - other.version;
        }
        return this.name.compareTo(other.name);
    }
}

