/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property.structured;

import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Element
implements IElement {
    private final String name;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<IElement> children = new ArrayList<IElement>();
    private String data;

    public Element(String name) {
        assert (Pattern.matches("[a-zA-Z][\\w:]*", name)) : "Element names must be non-emtpy strings containing characters from the English alphabet or digits.";
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAttribute(String key) {
        String value = this.attributes.get(key);
        if (value == null) {
            String error = String.format("Attribute '%s' does not exist.", key);
            throw new IllegalArgumentException(error);
        }
        return value;
    }

    @Override
    public String getAttribute(String key, String defaultValue) {
        String value = this.attributes.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public List<IElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public IElement setAttributes(Map<String, String> newAttributes) {
        assert (newAttributes != null) : "Setting null attributes is not allowed.";
        for (Map.Entry<String, String> entry : newAttributes.entrySet()) {
            this.validateAttribute(entry.getKey(), entry.getValue());
        }
        this.attributes.clear();
        this.attributes.putAll(newAttributes);
        return this;
    }

    @Override
    public IElement setChildren(List<IElement> newChildren) {
        assert (newChildren != null) : "Setting null children is not allowed.";
        this.children.clear();
        this.children.addAll(newChildren);
        return this;
    }

    @Override
    public IElement setData(String data) {
        this.data = data;
        return this;
    }

    @Override
    public IElement addChildren(IElement ... newChildren) {
        IElement[] iElementArray = newChildren;
        int n = newChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IElement child = iElementArray[n2];
            this.children.add(child);
            ++n2;
        }
        return this;
    }

    @Override
    public IElement addAttribute(String key, String value) {
        this.validateAttribute(key, value);
        this.attributes.put(key, value);
        return this;
    }

    private void validateAttribute(String key, String value) {
        if (!Pattern.matches("[a-zA-Z][\\w:]*", key)) {
            String error = String.format("Invalid attribute name '%s'. Attribute names must be non-emtpy strings containing characters from the English alphabet.", key);
            throw new IllegalArgumentException(error);
        }
        if (value == null) {
            String error = String.format("Attribute with key '%s' has NULL value.", key);
            throw new IllegalArgumentException(error);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Element other = (Element)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Element [name=" + this.name + ", attributes=" + this.attributes + ", children=" + this.children + ", data=" + this.data + "]";
    }
}

