/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SampleUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.AbstractGenericSampleRegisterEditForm;
import com.extjs.gxt.ui.client.widget.Component;
import java.util.List;
import java.util.Set;

public final class GenericSampleEditForm
extends AbstractGenericSampleRegisterEditForm {
    private Sample originalSample;

    public static DatabaseModificationAwareComponent create(IViewContext<IGenericClientServiceAsync> viewContext, IIdAndCodeHolder identifiable) {
        GenericSampleEditForm form = new GenericSampleEditForm(viewContext, identifiable);
        return new DatabaseModificationAwareComponent((Component)form, (IDatabaseModificationObserver)form);
    }

    private GenericSampleEditForm(IViewContext<IGenericClientServiceAsync> viewContext, IIdAndCodeHolder identifiable) {
        super(viewContext, null, new ActionContext(), identifiable);
        this.setRevertButtonVisible(true);
    }

    @Override
    protected void save() {
        List<IEntityProperty> properties = this.extractProperties();
        List<NewAttachment> attachments = this.attachmentsManager.extractAttachments();
        ExperimentIdentifier experimentIdent = this.experimentField != null ? this.experimentField.tryToGetValue() : null;
        String containerOrNull = StringUtils.trimToNull(this.container.getValue());
        String[] parents = this.getParents();
        SampleUpdates sampleUpdates = new SampleUpdates(this.attachmentsSessionKey, this.techIdOrNull, properties, attachments, experimentIdent, this.originalSample.getVersion(), this.createSampleIdentifier(), containerOrNull, parents);
        sampleUpdates.setMetaprojectsOrNull(this.metaprojectArea.tryGetModifiedMetaprojects());
        ((IGenericClientServiceAsync)this.viewContext.getService()).updateSample(sampleUpdates, this.enrichWithPostRegistration(new UpdateSampleCallback(this.viewContext)));
    }

    public void updateOriginalValues(List<String> parents) {
        this.updatePropertyFieldsOriginalValues();
        this.experimentField.updateOriginalValue();
        this.updateFieldOriginalValue(this.groupSelectionWidget);
        this.container.updateOriginalValue();
        this.parentsArea.setSamples(parents);
        this.updateFieldOriginalValue(this.metaprojectArea);
    }

    private void setOriginalSample(Sample sample) {
        this.originalSample = sample;
        this.sampleType = sample.getSampleType();
    }

    @Override
    protected void initializeFormFields() {
        this.propertiesEditor.initWithProperties(this.originalSample.getSampleType().getAssignedPropertyTypes(), this.originalSample.getProperties());
        this.codeField.setValue(this.originalSample.getCode());
        Experiment experiment = this.originalSample.getExperiment();
        ExperimentIdentifier originalExperiment = experiment == null ? null : ExperimentIdentifier.createIdentifier(experiment);
        this.experimentField.updateValue(originalExperiment);
        this.metaprojectArea.setMetaprojects(this.originalSample.getMetaprojects());
        this.initializeGroup();
        this.initializeContainedInParent();
        this.initializeParents();
    }

    private void initializeGroup() {
        Space spaceOrNull = this.originalSample.getSpace();
        if (spaceOrNull != null) {
            this.groupSelectionWidget.selectSpaceAndUpdateOriginal(spaceOrNull.getCode());
        } else {
            this.groupSelectionWidget.selectSpaceAndUpdateOriginal("(Shared)");
        }
    }

    private void initializeContainedInParent() {
        Sample containerSample = this.originalSample.getContainer();
        if (containerSample != null) {
            this.container.updateValue(containerSample.getIdentifier());
        }
    }

    private void initializeParents() {
        Set<Sample> parents = this.originalSample.getParents();
        this.parentsArea.setSamples(parents);
    }

    @Override
    protected void loadForm() {
        ((IGenericClientServiceAsync)this.viewContext.getService()).getSampleInfo(this.techIdOrNull, new SampleInfoCallback(this.viewContext));
    }

    private final class SampleInfoCallback
    extends AbstractAsyncCallback<Sample> {
        private SampleInfoCallback(IViewContext<IGenericClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(Sample result) {
            GenericSampleEditForm.this.setOriginalSample(result);
            GenericSampleEditForm.this.initGUI();
        }
    }

    private final class UpdateSampleCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<SampleUpdateResult> {
        UpdateSampleCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(SampleUpdateResult result) {
            GenericSampleEditForm.this.originalSample.setVersion(result.getVersion());
            GenericSampleEditForm.this.updateOriginalValues(result.getParents());
            super.process(result);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(SampleUpdateResult result) {
            return "Sample successfully updated";
        }
    }
}

