/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ActionMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ITabActionMenuItemDefinition;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.TabActionMenuItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.WellSearchComponent;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator.GlobalWellSearchLocatorResolver;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ScreeningModule
implements IModule {
    public static final String ID = "openbis_-screening-";
    private final ScreeningViewContext viewContext;

    public ScreeningModule(ScreeningViewContext viewContext) {
        this.viewContext = viewContext;
    }

    @Override
    public List<? extends MenuItem> getMenuItems() {
        ActionMenu globalWellSearch = TabActionMenuItemFactory.createActionMenu(this.viewContext, ID, this.createGlobalWellSearch());
        return Arrays.asList(globalWellSearch);
    }

    private ITabActionMenuItemDefinition<IScreeningClientServiceAsync> createGlobalWellSearch() {
        return new ITabActionMenuItemDefinition<IScreeningClientServiceAsync>(){

            @Override
            public String getName() {
                return "WELLS_SEARCH";
            }

            @Override
            public String getHelpPageTitle() {
                return "Global Well Search";
            }

            @Override
            public DatabaseModificationAwareComponent createComponent(IViewContext<IScreeningClientServiceAsync> context) {
                WellSearchComponent wellSearchTab = new WellSearchComponent(ScreeningModule.this.viewContext, null, true, true);
                return DatabaseModificationAwareComponent.wrapUnaware((Component)wellSearchTab);
            }

            @Override
            public String tryGetLink() {
                return GlobalWellSearchLocatorResolver.createQueryBrowserLink();
            }
        };
    }

    @Override
    public String getName() {
        return this.viewContext.getMessage("SCREENING_MODULE_TITLE", new Object[0]);
    }

    @Override
    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    @Override
    public Collection<? extends TabContent> getSections(IEntityInformationHolderWithIdentifier entity) {
        return Collections.emptyList();
    }
}

