/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ExperimentAnalysisSummaryGrid;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.widget.Component;

public class ExperimentAnalysisSummarySection
extends DisposableTabContent {
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final IEntityInformationHolderWithIdentifier experiment;
    private final IDisposableComponent analysisGridDisposableComponent;

    public ExperimentAnalysisSummarySection(IViewContext<IScreeningClientServiceAsync> screeningViewContext, IEntityInformationHolderWithIdentifier experiment) {
        super(screeningViewContext.getMessage("EXPERIMENT_FEATURE_VECTOR_SUMMARY_SECTION", new Object[0]), screeningViewContext, experiment);
        this.screeningViewContext = screeningViewContext;
        this.experiment = experiment;
        this.setIds(DisplayTypeIDGenerator.EXPERIMENT_FEATURE_VECTOR_SUMMARY_SECTION);
        this.analysisGridDisposableComponent = ExperimentAnalysisSummaryGrid.create(screeningViewContext, experiment, false, null);
    }

    @Override
    protected IDisposableComponent createDisposableContent() {
        return null;
    }

    private AnalysisProcedureChooser.IAnalysisProcedureSelectionListener getGridAsListener() {
        return (AnalysisProcedureChooser.IAnalysisProcedureSelectionListener)this.analysisGridDisposableComponent.getComponent();
    }

    @Override
    protected void showContent() {
        super.showContent();
        this.showAnalysisProcedureChooser();
    }

    private void showAnalysisProcedureChooser() {
        AnalysisProcedureChooser analysisProcedureChooser = this.createAnalysisProcedureChooser();
        this.setHeading("");
        this.getHeader().setVisible(true);
        this.getHeader().addTool((Component)analysisProcedureChooser);
        analysisProcedureChooser.getParent().addStyleName("force-float-left");
        this.replaceContent(this.analysisGridDisposableComponent);
    }

    private AnalysisProcedureChooser createAnalysisProcedureChooser() {
        WellSearchCriteria.ExperimentSearchCriteria experimentCriteria = WellSearchCriteria.ExperimentSearchCriteria.createExperiment(this.experiment);
        WellSearchCriteria.ExperimentSearchCriteriaHolder criteriaHolder = new WellSearchCriteria.ExperimentSearchCriteriaHolder(experimentCriteria);
        return AnalysisProcedureChooser.createHorizontal(this.screeningViewContext, criteriaHolder, WellSearchCriteria.AnalysisProcedureCriteria.createNoProcedures(), this.getGridAsListener(), true);
    }
}

