/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataSourceProvider;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningDAOFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class ScreeningDAOFactory
implements IScreeningDAOFactory {
    private static final String TECHNOLOGY = "screening";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ScreeningDAOFactory.class);
    private final IDataSourceProvider dataSourceProvider;
    private final Map<DataSource, IImagingReadonlyQueryDAO> daos = new HashMap<DataSource, IImagingReadonlyQueryDAO>();

    public ScreeningDAOFactory(IDataSourceProvider dataSourceProvider) {
        this.dataSourceProvider = dataSourceProvider;
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("DAO factory for Screening created. Data source provider: " + dataSourceProvider.getClass().getName()));
        }
    }

    @Override
    public IImagingReadonlyQueryDAO getImagingQueryDAO(String dssCode) {
        DataSource dataSource = this.dataSourceProvider.getDataSourceByDataStoreServerCode(dssCode, TECHNOLOGY);
        IImagingReadonlyQueryDAO dao = this.daos.get(dataSource);
        if (dao == null) {
            dao = (IImagingReadonlyQueryDAO)QueryTool.getQuery((DataSource)dataSource, IImagingReadonlyQueryDAO.class);
            this.daos.put(dataSource, dao);
        }
        return dao;
    }
}

