/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityReference;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.NamedFeatureVector;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellImage;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WellContent
extends WellImage
implements Serializable,
IEntityPropertiesHolder {
    private static final long serialVersionUID = 35L;
    private List<IEntityProperty> wellProperties = new ArrayList<IEntityProperty>(0);
    private List<IEntityProperty> wellPropertiesOfMaterialType;
    private EntityReference plate;
    private DatasetReference featureVectorDatasetOrNull;
    private NamedFeatureVector featureVectorOrNull;

    private WellContent() {
    }

    public WellContent(WellLocation locationOrNull, EntityReference well, EntityReference plate, ExperimentReference experiment) {
        this(locationOrNull, well, plate, experiment, null, null, null, null);
    }

    private WellContent(WellLocation locationOrNull, EntityReference well, EntityReference plate, ExperimentReference experiment, List<IEntityProperty> wellProperties, DatasetImagesReference imagesDatasetOrNull, DatasetReference featureVectorDatasetOrNull, NamedFeatureVector featureVectorOrNull) {
        super(locationOrNull, well, experiment, imagesDatasetOrNull);
        this.plate = plate;
        this.featureVectorDatasetOrNull = featureVectorDatasetOrNull;
        this.featureVectorOrNull = featureVectorOrNull;
        this.wellProperties = wellProperties;
    }

    public EntityReference getPlate() {
        return this.plate;
    }

    public List<IEntityProperty> getMaterialTypeProperties() {
        if (this.wellPropertiesOfMaterialType == null) {
            this.wellPropertiesOfMaterialType = this.filterWellPropertiesOfMaterialType();
        }
        return Collections.unmodifiableList(this.wellPropertiesOfMaterialType);
    }

    private List<IEntityProperty> filterWellPropertiesOfMaterialType() {
        ArrayList<IEntityProperty> materialProps = new ArrayList<IEntityProperty>();
        for (IEntityProperty property : this.getWellProperties()) {
            DataTypeCode propertyDataTypeCode = property.getPropertyType().getDataType().getCode();
            if (propertyDataTypeCode != DataTypeCode.MATERIAL) continue;
            materialProps.add(property);
        }
        return materialProps;
    }

    public List<Material> getMaterialContents() {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (IEntityProperty property : this.getMaterialTypeProperties()) {
            Material materialOrNull = property.getMaterial();
            if (materialOrNull == null) continue;
            materials.add(materialOrNull);
        }
        return materials;
    }

    public DatasetReference tryGetFeatureVectorDataset() {
        return this.featureVectorDatasetOrNull;
    }

    public NamedFeatureVector tryGetFeatureVectorValues() {
        return this.featureVectorOrNull;
    }

    public WellContent cloneWithImageDatasets(DatasetImagesReference newImagesDatasetOrNull, DatasetReference newFeatureVectorDatasetOrNull) {
        return new WellContent(this.locationOrNull, this.well, this.plate, this.experiment, this.wellProperties, newImagesDatasetOrNull, newFeatureVectorDatasetOrNull, this.featureVectorOrNull);
    }

    public WellContent cloneWithFeatureVector(NamedFeatureVector newFeatureVectorOrNull) {
        return new WellContent(this.locationOrNull, this.well, this.plate, this.experiment, this.wellProperties, this.imagesDatasetOrNull, this.featureVectorDatasetOrNull, newFeatureVectorOrNull);
    }

    public String toString() {
        return "location = " + this.locationOrNull + ", experiment = " + this.experiment + ", plate = " + this.plate + ", well = " + this.well;
    }

    public List<IEntityProperty> getWellProperties() {
        if (this.wellProperties == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.wellProperties);
    }

    public void setWellProperties(List<IEntityProperty> properties) {
        this.wellProperties = properties;
    }

    @Override
    public Long getId() {
        return this.well.getId();
    }

    @Override
    public List<IEntityProperty> getProperties() {
        return this.getWellProperties();
    }
}

