/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.PredicateDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransformedPredicate<I, O>
implements Predicate<I>,
PredicateDecorator<I>,
Serializable {
    static final long serialVersionUID = -5596090919668315834L;
    private final Transformer<? super I, ? extends O> iTransformer;
    private final Predicate<? super O> iPredicate;

    public static <I, O> Predicate<I> getInstance(Transformer<? super I, ? extends O> transformer, Predicate<? super O> predicate) {
        if (transformer == null) {
            throw new IllegalArgumentException("The transformer to call must not be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate to call must not be null");
        }
        return new TransformedPredicate<I, O>(transformer, predicate);
    }

    public TransformedPredicate(Transformer<? super I, ? extends O> transformer, Predicate<? super O> predicate) {
        this.iTransformer = transformer;
        this.iPredicate = predicate;
    }

    @Override
    public boolean evaluate(I object) {
        O result = this.iTransformer.transform(object);
        return this.iPredicate.evaluate(result);
    }

    @Override
    public Predicate[] getPredicates() {
        return new Predicate[]{this.iPredicate};
    }

    public Transformer<? super I, ? extends O> getTransformer() {
        return this.iTransformer;
    }
}

