/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client;

import java.io.File;
import org.apache.commons.lang.SystemUtils;

public class ClientConfigurationFiles {
    public static final File USER_CONFIG_DIRECTORY = ClientConfigurationFiles.getCIFEXUserConfigDir();
    public static final File HOST_CONFIG_DIRECTORY = ClientConfigurationFiles.getCIFEXHostConfigDir();
    private static final String USER_PROPERTIES_FILENAME = "properties";
    public static final File USER_PROPERTIES_FILE = new File(USER_CONFIG_DIRECTORY, "properties");
    private static final String SESSION_TOKEN_FILE_NAME = "session-token";
    public static final File SESSION_TOKEN_FILE = new File(USER_CONFIG_DIRECTORY, "session-token");
    private static final String BASE_URL_FILE_NAME = "server";
    public static final File BASE_URL_FILE = new File(HOST_CONFIG_DIRECTORY, "server");
    private static final String KEYSTORE_FILE_NAME = "keystore";
    public static final File KEYSTORE_FILE = new File(HOST_CONFIG_DIRECTORY, "keystore");

    private static File getCIFEXHostConfigDir() {
        File cifexInstallationConfigDir = ClientConfigurationFiles.tryGetCIFEXInstallationConfigDirPath();
        if (cifexInstallationConfigDir != null) {
            return cifexInstallationConfigDir;
        }
        return ClientConfigurationFiles.getCIFEXUserConfigDir();
    }

    private static File getCIFEXUserConfigDir() {
        File cifexUserConfigDir = new File(SystemUtils.getUserHome(), ".cifex");
        cifexUserConfigDir.mkdirs();
        return cifexUserConfigDir;
    }

    private static File tryGetCIFEXInstallationConfigDirPath() {
        String cifexInstallationConfigDirPath = System.getProperty("cifex.config");
        if (cifexInstallationConfigDirPath != null) {
            File cifexInstallationConfigDir = new File(cifexInstallationConfigDirPath);
            cifexInstallationConfigDir.mkdirs();
            return cifexInstallationConfigDir;
        }
        return null;
    }

    private ClientConfigurationFiles() {
    }
}

