/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXDownloader;
import ch.systemsx.cisd.cifex.rpc.client.PersistenceStore;
import ch.systemsx.cisd.cifex.rpc.client.TransmissionSpeedCalculator;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileDownloadClient;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileDownloadOperation;
import ch.systemsx.cisd.cifex.rpc.client.gui.IProgressListener;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FileDownloadClientModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    static final int FILE_DETAILS_COLUMN = 0;
    static final int SENDER_COLUMN = 1;
    static final int COMMENT_COLUMN = 2;
    static final int SENT_DATE_COLUMN = 3;
    static final int EXPIRATION_DATE_COLUMN = 4;
    static final int DOWNLOAD_STATUS_COLUMN = 5;
    private static ExecutorService executor = new NamingThreadPoolExecutor("File download", 1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()).daemonize();
    private final JFrame mainWindow;
    private JTable table;
    private final ICIFEXComponent cifex;
    private final String sessionId;
    private final ICIFEXDownloader downloader;
    private final FileDownloadClient.IDecryptionChecker decryptionChecker;
    private final ITimeProvider timeProvider;
    private final ArrayList<FileDownloadInfo> fileDownloadInfos = new ArrayList();
    private FileDownloadInfo currentlyDownloadingFile;
    private File downloadDirectory;
    private String passphrase = "";
    private boolean deleteEncryptedFileAfterSuccessfulDecryption;
    protected int sortColumnIndex = 0;
    protected boolean sortAscending = true;

    FileDownloadClientModel(FileDownloadClient downloadClient, JFrame mainWindow, ITimeProvider timeProvider) {
        this.cifex = downloadClient.getCifex();
        this.sessionId = downloadClient.getSessionId();
        this.downloader = downloadClient.getDownloader();
        this.decryptionChecker = downloadClient.getDecryptionChecker();
        this.mainWindow = mainWindow;
        this.timeProvider = timeProvider;
        this.downloadDirectory = PersistenceStore.getWorkingDirectory();
        this.addProgessListener();
        this.updateDownloadableFiles();
    }

    public void setTable(JTable table) {
        this.table = table;
        table.getTableHeader().addMouseListener(new ColumnSortingListener());
    }

    public File getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public void setDownloadDirectory(File downloadDirectory) {
        this.downloadDirectory = downloadDirectory;
    }

    public void setPassphraseAndEncryptedFileDeletion(String passphrase, boolean deleteEncryptedFileAfterSuccessfulDecryption) {
        this.passphrase = passphrase;
        this.deleteEncryptedFileAfterSuccessfulDecryption = deleteEncryptedFileAfterSuccessfulDecryption;
        this.fireTableDataChanged();
    }

    public ICIFEXDownloader getDownloader() {
        return this.downloader;
    }

    private void addProgessListener() {
        this.downloader.addProgressListener(new IProgressListener(){

            @Override
            public void start(File file, String operationname, long fileSize, Long fileIdOrNull) {
                FileDownloadClientModel.this.currentlyDownloadingFile = FileDownloadClientModel.this.tryToFindDownloadInfoForFile(fileIdOrNull);
                if (FileDownloadClientModel.this.currentlyDownloadingFile != null) {
                    FileDownloadClientModel.this.currentlyDownloadingFile.updateProgress(0, 0L);
                    FileDownloadClientModel.this.fireChanged(null);
                }
            }

            @Override
            public void reportProgress(int percentage, long numberOfBytes) {
                if (FileDownloadClientModel.this.currentlyDownloadingFile != null) {
                    FileDownloadClientModel.this.currentlyDownloadingFile.updateProgress(percentage, numberOfBytes);
                    FileDownloadClientModel.this.fireChanged(null);
                }
            }

            @Override
            public void finished(boolean successful) {
                if (FileDownloadClientModel.this.currentlyDownloadingFile != null) {
                    if (successful) {
                        FileDownloadClientModel.this.currentlyDownloadingFile.updateProgress(100, FileDownloadClientModel.this.currentlyDownloadingFile.fileInfoDTO.getSize());
                        if (FileDownloadClientModel.this.passphrase.length() > 0) {
                            FileDownloadClientModel.this.currentlyDownloadingFile.setStatus(FileDownloadInfo.Status.DECRYPTING);
                            FileDownloadClientModel.this.fireChanged(FileDownloadInfo.Status.DECRYPTING);
                        } else {
                            FileDownloadClientModel.this.currentlyDownloadingFile.setStatus(FileDownloadInfo.Status.COMPLETED_DOWNLOAD);
                            FileDownloadClientModel.this.fireChanged(FileDownloadInfo.Status.COMPLETED_DOWNLOAD);
                        }
                    } else {
                        FileDownloadClientModel.this.currentlyDownloadingFile.setStatus(FileDownloadInfo.Status.FAILED);
                        FileDownloadClientModel.this.fireChanged(FileDownloadInfo.Status.FAILED);
                    }
                }
            }

            @Override
            public void exceptionOccured(Throwable throwable) {
            }

            @Override
            public void warningOccured(String warningMessage) {
                FileDownloadClientModel.this.currentlyDownloadingFile.setStatus(FileDownloadInfo.Status.STALLED);
            }
        });
    }

    private FileDownloadInfo tryToFindDownloadInfoForFile(Long fileIdOrNull) {
        if (fileIdOrNull == null) {
            return null;
        }
        for (FileDownloadInfo fileDownloadInfo : this.fileDownloadInfos) {
            if (!fileIdOrNull.equals(fileDownloadInfo.fileInfoDTO.getID())) continue;
            return fileDownloadInfo;
        }
        return null;
    }

    void resetCurrentlyDownloadingFile() {
        this.currentlyDownloadingFile = null;
    }

    void fireChanged(Long fileIdOrNull, FileDownloadInfo.Status statusOrNull) {
        this.currentlyDownloadingFile = this.tryToFindDownloadInfoForFile(fileIdOrNull);
        this.fireChanged(statusOrNull);
    }

    void fireChanged(FileDownloadInfo.Status statusOrNull) {
        if (this.currentlyDownloadingFile != null) {
            if (statusOrNull != null) {
                this.currentlyDownloadingFile.setStatus(statusOrNull);
            }
            int index = this.fileDownloadInfos.indexOf(this.currentlyDownloadingFile);
            this.fireTableRowsUpdated(index, index);
        }
    }

    void setSelectedIndices(ArrayList<Integer> selectedIndices) {
    }

    void updateDownloadableFiles() {
        FileInfoDTO[] downloadableFileInfos = this.cifex.listDownloadFiles(this.sessionId);
        this.fileDownloadInfos.clear();
        FileInfoDTO[] fileInfoDTOArray = downloadableFileInfos;
        int n = downloadableFileInfos.length;
        int n2 = 0;
        while (n2 < n) {
            FileInfoDTO fileInfo = fileInfoDTOArray[n2];
            this.fileDownloadInfos.add(new FileDownloadInfo(fileInfo, this.timeProvider));
            ++n2;
        }
        Collections.sort(this.fileDownloadInfos, new FileDownloadInfoComparator());
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.fileDownloadInfos.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String name = "";
        if (columnIndex == this.sortColumnIndex) {
            name = this.sortAscending ? "\u25b2" : "\u25bc";
        }
        switch (columnIndex) {
            case 0: {
                name = String.valueOf(name) + " File";
                break;
            }
            case 1: {
                name = String.valueOf(name) + " From";
                break;
            }
            case 2: {
                name = String.valueOf(name) + " Comment";
                break;
            }
            case 3: {
                name = String.valueOf(name) + " Sent Date";
                break;
            }
            case 4: {
                name = String.valueOf(name) + " Download Before";
                break;
            }
        }
        return name;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FileDownloadInfo fileDownloadInfo = this.fileDownloadInfos.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return fileDownloadInfo.fileInfoDTO;
            }
            case 1: {
                return fileDownloadInfo.fileInfoDTO.getOwner();
            }
            case 2: {
                return fileDownloadInfo.fileInfoDTO.getComment();
            }
            case 3: {
                return fileDownloadInfo.fileInfoDTO.getRegistrationDate();
            }
            case 4: {
                return fileDownloadInfo.fileInfoDTO.getExpirationDate();
            }
            case 5: {
                return fileDownloadInfo;
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Object columnValue = this.getValueAt(0, c);
        if (columnValue == null) {
            return super.getColumnClass(c);
        }
        return columnValue.getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        assert (col == 5);
        FileDownloadInfo fileDownloadInfo = (FileDownloadInfo)value;
        if (fileDownloadInfo == null) {
            return;
        }
        FileDownloadInfo.Status status = fileDownloadInfo.getStatus();
        if (status != FileDownloadInfo.Status.TO_DOWNLOAD && status != FileDownloadInfo.Status.FAILED && status != FileDownloadInfo.Status.COMPLETED_DOWNLOAD) {
            return;
        }
        this.queueDownloadOfFile(fileDownloadInfo);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex != 5) {
            return false;
        }
        FileDownloadInfo fileDownloadInfo = this.fileDownloadInfos.get(rowIndex);
        if (fileDownloadInfo == null) {
            return false;
        }
        FileDownloadInfo.Status status = fileDownloadInfo.getStatus();
        return status == FileDownloadInfo.Status.TO_DOWNLOAD || status == FileDownloadInfo.Status.FAILED || status == FileDownloadInfo.Status.COMPLETED_DOWNLOAD;
    }

    private void queueDownloadOfFile(FileDownloadInfo fileDownloadInfo) {
        if (fileDownloadInfo.getStatus() == FileDownloadInfo.Status.COMPLETED_DOWNLOAD) {
            fileDownloadInfo.setStatus(FileDownloadInfo.Status.QUEUED_FOR_DECRYPTION);
        } else {
            fileDownloadInfo.setStatus(FileDownloadInfo.Status.QUEUED_FOR_DOWNLOAD);
        }
        FileDownloadOperation op = new FileDownloadOperation(this, fileDownloadInfo, this.downloadDirectory, this.passphrase, this.deleteEncryptedFileAfterSuccessfulDecryption);
        executor.submit(op);
    }

    public JFrame getMainWindow() {
        return this.mainWindow;
    }

    public FileDownloadClient.IDecryptionChecker getDecryptionChecker() {
        return this.decryptionChecker;
    }

    class ColumnSortingListener
    extends MouseAdapter {
        ColumnSortingListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int columnModelIndex;
            TableColumnModel colModel = FileDownloadClientModel.this.table.getColumnModel();
            int modelIndex = colModel.getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (FileDownloadClientModel.this.sortColumnIndex == modelIndex) {
                FileDownloadClientModel.this.sortAscending = !FileDownloadClientModel.this.sortAscending;
            } else {
                FileDownloadClientModel.this.sortColumnIndex = modelIndex;
                FileDownloadClientModel.this.sortAscending = true;
            }
            int i = 0;
            while (i < FileDownloadClientModel.this.getColumnCount()) {
                TableColumn column = colModel.getColumn(i);
                column.setHeaderValue(FileDownloadClientModel.this.getColumnName(column.getModelIndex()));
                ++i;
            }
            FileDownloadClientModel.this.table.getTableHeader().repaint();
            Collections.sort(FileDownloadClientModel.this.fileDownloadInfos, new FileDownloadInfoComparator());
            FileDownloadClientModel.this.table.tableChanged(new TableModelEvent(FileDownloadClientModel.this));
            FileDownloadClientModel.this.table.repaint();
        }
    }

    static class FileDownloadInfo {
        private final FileInfoDTO fileInfoDTO;
        private final TransmissionSpeedCalculator transmissionSpeedCalculator;
        private File file;
        private int percentageDownloaded;
        private long numberOfBytesDownloaded;
        private Status status;

        FileDownloadInfo(FileInfoDTO fileInfo, ITimeProvider timeProvider) {
            this.fileInfoDTO = fileInfo;
            this.transmissionSpeedCalculator = new TransmissionSpeedCalculator(timeProvider);
            this.percentageDownloaded = 0;
            this.numberOfBytesDownloaded = 0L;
            this.setStatus(Status.TO_DOWNLOAD);
        }

        public FileInfoDTO getFileInfoDTO() {
            return this.fileInfoDTO;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public int getPercentageDownloaded() {
            return this.percentageDownloaded;
        }

        public long getNumberOfBytesDownloaded() {
            return this.numberOfBytesDownloaded;
        }

        public long getEstimatedTimeOfArrival() {
            float remainingBytes = this.fileInfoDTO.getSize() - this.numberOfBytesDownloaded;
            float bytesPerMillisecond = this.transmissionSpeedCalculator.getEstimatedBytesPerMillisecond();
            if ((double)bytesPerMillisecond < 0.001) {
                return -1L;
            }
            return (long)(remainingBytes / bytesPerMillisecond);
        }

        void updateProgress(int percent, long numberOfBytes) {
            this.setStatus(Status.DOWNLOADING);
            int transmittedSinceLastUpdate = (int)(numberOfBytes - this.numberOfBytesDownloaded);
            this.percentageDownloaded = percent;
            this.numberOfBytesDownloaded = numberOfBytes;
            this.transmissionSpeedCalculator.noteTransmittedBytesSinceLastUpdate(transmittedSinceLastUpdate);
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public Status getStatus() {
            return this.status;
        }

        static enum Status {
            TO_DOWNLOAD,
            QUEUED_FOR_DOWNLOAD,
            QUEUED_FOR_DECRYPTION,
            DOWNLOADING,
            DECRYPTING,
            COMPLETED_DOWNLOAD,
            COMPLETED_DOWNLOAD_AND_DECRYPTION,
            FAILED,
            STALLED;

        }
    }

    class FileDownloadInfoComparator
    implements Comparator<FileDownloadInfo> {
        FileDownloadInfoComparator() {
        }

        @Override
        public int compare(FileDownloadInfo info1, FileDownloadInfo info2) {
            int result = 0;
            switch (FileDownloadClientModel.this.sortColumnIndex) {
                case 0: {
                    result = info1.getFileInfoDTO().getName().compareTo(info2.getFileInfoDTO().getName());
                    break;
                }
                case 1: {
                    result = info1.getFileInfoDTO().getOwner().toString().compareTo(info2.getFileInfoDTO().getOwner().toString());
                    break;
                }
                case 2: {
                    result = info1.getFileInfoDTO().getComment().compareTo(info2.getFileInfoDTO().getComment());
                    break;
                }
                case 3: {
                    result = info1.getFileInfoDTO().getRegistrationDate().compareTo(info2.getFileInfoDTO().getRegistrationDate());
                    break;
                }
                case 4: {
                    result = info1.getFileInfoDTO().getExpirationDate().compareTo(info2.getFileInfoDTO().getExpirationDate());
                    break;
                }
                case 5: {
                    result = info1.getStatus().compareTo(info2.getStatus());
                }
            }
            return FileDownloadClientModel.this.sortAscending ? result : -result;
        }
    }
}

