/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipDir
implements Vfs.Dir {
    final java.util.zip.ZipFile zipFile;
    private String path;

    public ZipDir(URL url) {
        this(url.getPath());
    }

    public ZipDir(String p) {
        this.path = p;
        if (this.path.startsWith("jar:")) {
            this.path = this.path.substring("jar:".length());
        }
        if (this.path.startsWith("file:")) {
            this.path = this.path.substring("file:".length());
        }
        if (this.path.endsWith("!/")) {
            this.path = this.path.substring(0, this.path.lastIndexOf("!/")) + "/";
        }
        try {
            this.zipFile = new java.util.zip.ZipFile(this.path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        return new Iterable<Vfs.File>(){

            @Override
            public Iterator<Vfs.File> iterator() {
                return new AbstractIterator<Vfs.File>(){
                    final Enumeration<? extends ZipEntry> entries;
                    {
                        this.entries = ZipDir.this.zipFile.entries();
                    }

                    protected Vfs.File computeNext() {
                        return this.entries.hasMoreElements() ? new ZipFile(ZipDir.this, this.entries.nextElement()) : (Vfs.File)this.endOfData();
                    }
                };
            }
        };
    }

    @Override
    public void close() {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException("could not close zip file " + this.path, e);
            }
        }
    }

    public String toString() {
        return this.zipFile.getName();
    }
}

