/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.hcs.Geometry;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.hcs.WellGeometry;
import ch.systemsx.cisd.openbis.dss.etl.AcquiredSingleImage;
import ch.systemsx.cisd.openbis.dss.etl.IImageFileExtractor;
import ch.systemsx.cisd.openbis.dss.etl.ImageFileExtractionResult;
import ch.systemsx.cisd.openbis.dss.etl.ImageFileExtractorUtils;
import ch.systemsx.cisd.openbis.dss.etl.RelativeImageReference;
import ch.systemsx.cisd.openbis.dss.etl.TileMapper;
import ch.systemsx.cisd.openbis.dss.etl.dto.RelativeImageFile;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ThumbnailsInfo;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ChannelDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractImageFileExtractor
implements IImageFileExtractor {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractImageFileExtractor.class);
    protected static final String IMAGE_FILE_NOT_STANDARDIZABLE = "Information about the image could not be extracted for the file '%s'.";
    protected static final String IMAGE_FILE_NOT_ENOUGH_ENTITIES = "The name of image file '%s' could not be splitted into enough entities.";
    protected static final String IMAGE_FILE_BELONGS_TO_WRONG_SAMPLE = "Image file '%s' belongs to the wrong sample [expected=%s,found=%s].";
    protected static final String IMAGE_FILE_ACCEPTED = "Image file '%s' was accepted: %s.";
    public static final String TILE_GEOMETRY_PROPERTY = "well_geometry";
    @Deprecated
    public static final String CHANNEL_NAMES = "channel-names";
    public static final String CHANNEL_CODES = "channel-codes";
    public static final String CHANNEL_LABELS = "channel-labels";
    protected static final String EXTRACT_SINGLE_IMAGE_CHANNELS_PROPERTY = "extract-single-image-channels";
    protected static final String TILE_MAPPING_PROPERTY = "tile_mapping";
    protected static final char TOKEN_SEPARATOR = '_';
    private final List<ChannelDescription> channelDescriptionsOrNull;
    private final List<ColorComponent> channelColorComponentsOrNull;
    private final boolean skipChannelsWithoutImages;
    protected final TileMapper tileMapperOrNull;
    protected final Geometry tileGeometry;

    protected abstract ImageFileInfo tryExtractImageInfo(File var1, File var2, SampleIdentifier var3);

    protected AbstractImageFileExtractor(Properties properties, boolean skipChannelsWithoutImages) {
        this(AbstractImageFileExtractor.tryExtractChannelDescriptions(properties), AbstractImageFileExtractor.getWellGeometry(properties), skipChannelsWithoutImages, properties);
    }

    protected AbstractImageFileExtractor(List<ChannelDescription> channelDescriptionsOrNull, Geometry tileGeometry, boolean skipChannelsWithoutImages, Properties properties) {
        assert (tileGeometry != null) : "wel geometry is null";
        this.tileGeometry = tileGeometry;
        this.channelDescriptionsOrNull = channelDescriptionsOrNull;
        this.channelColorComponentsOrNull = AbstractImageFileExtractor.tryGetChannelComponents(properties);
        this.skipChannelsWithoutImages = skipChannelsWithoutImages;
        this.checkChannelsAndColorComponents();
        this.tileMapperOrNull = TileMapper.tryCreate(properties.getProperty(TILE_MAPPING_PROPERTY), tileGeometry);
    }

    protected static final Geometry getMandatoryTileGeometry(Properties properties) {
        String spotGeometryText = PropertyUtils.getMandatoryProperty((Properties)properties, (String)TILE_GEOMETRY_PROPERTY);
        return Geometry.createFromString((String)spotGeometryText);
    }

    private static Geometry getWellGeometry(Properties properties) {
        String property = properties.getProperty(TILE_GEOMETRY_PROPERTY);
        if (property == null) {
            throw new ConfigurationFailureException(String.format("No '%s' property has been specified.", TILE_GEOMETRY_PROPERTY));
        }
        Geometry geometry = WellGeometry.createFromString((String)property);
        if (geometry == null) {
            throw new ConfigurationFailureException(String.format("Could not create a geometry from property value '%s'.", property));
        }
        return geometry;
    }

    protected final Location tryGetTileLocation(int tileNumber) {
        if (this.tileMapperOrNull != null) {
            return this.tileMapperOrNull.tryGetLocation(tileNumber);
        }
        return null;
    }

    private void checkChannelsAndColorComponents() {
        if (!this.skipChannelsWithoutImages && this.channelDescriptionsOrNull == null) {
            throw ConfigurationFailureException.fromTemplate((String)"Expected channels are not specified and extraction of channels from images is switched off!", (Object[])new Object[0]);
        }
        if (this.channelColorComponentsOrNull != null && this.channelDescriptionsOrNull == null) {
            throw ConfigurationFailureException.fromTemplate((String)"Channels are not specified although color components are given!", (Object[])new Object[0]);
        }
        if (this.channelColorComponentsOrNull != null && this.channelDescriptionsOrNull != null && this.channelColorComponentsOrNull.size() != this.channelDescriptionsOrNull.size()) {
            throw ConfigurationFailureException.fromTemplate((String)"There should be exactly one color component for each channel name. Correct the list of values for '%s' property.", (Object[])new Object[]{EXTRACT_SINGLE_IMAGE_CHANNELS_PROPERTY});
        }
    }

    @Override
    public ImageFileExtractionResult extract(File incomingDataSetDirectory, DataSetInformation dataSetInformation) {
        LinkedList<File> invalidFiles = new LinkedList<File>();
        ArrayList<AcquiredSingleImage> acquiredImages = new ArrayList<AcquiredSingleImage>();
        List<File> imageFiles = ImageFileExtractorUtils.listImageFiles(incomingDataSetDirectory);
        for (File imageFile : imageFiles) {
            ImageFileInfo imageInfo;
            InterruptedExceptionUnchecked.check();
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format("Processing image file '%s'", imageFile));
            }
            if ((imageInfo = this.tryExtractImageInfo(imageFile, incomingDataSetDirectory, dataSetInformation.getSampleIdentifier())) != null) {
                List<AcquiredSingleImage> newImages = this.getImages(imageInfo);
                acquiredImages.addAll(newImages);
                if (!operationLog.isDebugEnabled()) continue;
                operationLog.debug((Object)String.format(IMAGE_FILE_ACCEPTED, imageFile, imageInfo));
                continue;
            }
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format(IMAGE_FILE_NOT_STANDARDIZABLE, imageFile));
            }
            invalidFiles.add(imageFile);
        }
        File datasetRelativeImagesFolderPath = new File("original" + File.separator + incomingDataSetDirectory.getName());
        return new ImageFileExtractionResult(acquiredImages, datasetRelativeImagesFolderPath, Collections.unmodifiableList(invalidFiles), this.getAllChannels(acquiredImages), this.tileGeometry, null, null);
    }

    private List<AcquiredSingleImage> getImages(ImageFileInfo imageInfo) {
        this.checkChannelsAndColorComponents();
        if (this.channelColorComponentsOrNull != null && this.channelDescriptionsOrNull != null) {
            ArrayList<AcquiredSingleImage> images = new ArrayList<AcquiredSingleImage>();
            int i = 0;
            while (i < this.channelColorComponentsOrNull.size()) {
                ColorComponent colorComponent = this.channelColorComponentsOrNull.get(i);
                ChannelDescription channelDescription = this.channelDescriptionsOrNull.get(i);
                images.add(AbstractImageFileExtractor.createImage(imageInfo, channelDescription.getCode(), colorComponent, null));
                ++i;
            }
            return images;
        }
        AbstractImageFileExtractor.ensureChannelExist(this.channelDescriptionsOrNull, imageInfo.getChannelCode());
        return AbstractImageFileExtractor.createImagesWithNoColorComponent(imageInfo, null);
    }

    private List<Channel> getAllChannels(List<AcquiredSingleImage> acquiredImages) {
        if (this.channelDescriptionsOrNull != null && !this.skipChannelsWithoutImages) {
            return AbstractImageFileExtractor.createChannels(this.channelDescriptionsOrNull);
        }
        if (this.skipChannelsWithoutImages) {
            return AbstractImageFileExtractor.createChannels(AbstractImageFileExtractor.extractChannelDescriptions(acquiredImages, this.channelDescriptionsOrNull));
        }
        throw new IllegalStateException("extractChannelsFromImages is false, channelDescriptionsOrNull is null");
    }

    private static List<ChannelDescription> extractChannelDescriptions(List<AcquiredSingleImage> acquiredImages, List<ChannelDescription> channelDescriptionsOrNull) {
        Map<String, String> channelCodeToLabel = AbstractImageFileExtractor.createChannelCodeToLabelMap(channelDescriptionsOrNull);
        HashSet<String> channelCodes = new HashSet<String>();
        for (AcquiredSingleImage image : acquiredImages) {
            channelCodes.add(image.getChannelCode());
        }
        ArrayList<ChannelDescription> descs = new ArrayList<ChannelDescription>();
        for (String channelCode : channelCodes) {
            String label = channelCodeToLabel.get(channelCode);
            ChannelDescription desc = label != null ? new ChannelDescription(channelCode, label) : new ChannelDescription(channelCode);
            descs.add(desc);
        }
        return descs;
    }

    private static Map<String, String> createChannelCodeToLabelMap(List<ChannelDescription> channelDescriptionsOrNull) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (channelDescriptionsOrNull == null) {
            return map;
        }
        for (ChannelDescription desc : channelDescriptionsOrNull) {
            map.put(desc.getCode(), desc.getLabel());
        }
        return map;
    }

    protected static final String getRelativeImagePath(File incomingDataSetDirectory, File imageFile) {
        String imageRelativePath = FileUtilities.getRelativeFilePath((File)incomingDataSetDirectory, (File)new File(imageFile.getPath()));
        assert (imageRelativePath != null) : "Image relative path should not be null.";
        return imageRelativePath;
    }

    protected static final List<ColorComponent> tryGetChannelComponents(Properties properties) {
        List componentNames = PropertyUtils.tryGetList((Properties)properties, (String)EXTRACT_SINGLE_IMAGE_CHANNELS_PROPERTY);
        if (componentNames == null) {
            return null;
        }
        ArrayList<ColorComponent> components = new ArrayList<ColorComponent>();
        for (String name : componentNames) {
            components.add(ColorComponent.valueOf(name));
        }
        return components;
    }

    protected static final List<Channel> createChannels(List<ChannelDescription> channelDescriptions) {
        assert (channelDescriptions != null) : "channelDescriptions is null";
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (ChannelDescription channelDescription : channelDescriptions) {
            channels.add(new Channel(channelDescription.getCode(), channelDescription.getLabel()));
        }
        return channels;
    }

    private static final List<ChannelDescription> tryExtractChannelDescriptions(Properties properties) {
        List names = PropertyUtils.tryGetList((Properties)properties, (String)CHANNEL_NAMES);
        List codes = PropertyUtils.tryGetList((Properties)properties, (String)CHANNEL_CODES);
        List<String> labels = AbstractImageFileExtractor.tryGetListOfLabels(properties, CHANNEL_LABELS);
        if (names != null && (codes != null || labels != null)) {
            throw new ConfigurationFailureException(String.format("Configure either '%s' or ('%s','%s') but not both.", CHANNEL_NAMES, CHANNEL_CODES, CHANNEL_LABELS));
        }
        if (names != null) {
            ArrayList<ChannelDescription> descriptions = new ArrayList<ChannelDescription>();
            for (String name : names) {
                descriptions.add(new ChannelDescription(name));
            }
            return descriptions;
        }
        if (codes == null || labels == null) {
            return null;
        }
        if (codes.size() != labels.size()) {
            throw new ConfigurationFailureException(String.format("Number of configured '%s' should be the same as number of '%s'.", CHANNEL_CODES, CHANNEL_LABELS));
        }
        ArrayList<ChannelDescription> descriptions = new ArrayList<ChannelDescription>();
        int i = 0;
        while (i < codes.size()) {
            descriptions.add(new ChannelDescription((String)codes.get(i), labels.get(i)));
            ++i;
        }
        return descriptions;
    }

    private static final List<String> tryGetListOfLabels(Properties properties, String propertyKey) {
        String itemsList = PropertyUtils.getProperty((Properties)properties, (String)propertyKey);
        if (itemsList == null) {
            return null;
        }
        String[] items = itemsList.split(",");
        int i = 0;
        while (i < items.length) {
            items[i] = items[i].trim();
            ++i;
        }
        return Arrays.asList(items);
    }

    protected static final void ensureChannelExist(List<ChannelDescription> channelDescriptionsOrNull, String channelCode) {
        if (channelDescriptionsOrNull == null) {
            return;
        }
        for (ChannelDescription channelDescription : channelDescriptionsOrNull) {
            if (!channelDescription.getCode().equalsIgnoreCase(channelCode)) continue;
            return;
        }
        throw UserFailureException.fromTemplate((String)"Channel '%s' is not one of: %s. Change the configuration.", (Object[])new Object[]{channelCode, channelDescriptionsOrNull});
    }

    public static final List<AcquiredSingleImage> createImagesWithNoColorComponent(ImageFileInfo imageInfo, ThumbnailsInfo thumbnailFilePathsOrNull) {
        ArrayList<AcquiredSingleImage> images = new ArrayList<AcquiredSingleImage>();
        images.add(AbstractImageFileExtractor.createImage(imageInfo, imageInfo.getChannelCode(), null, thumbnailFilePathsOrNull));
        return images;
    }

    public static final AcquiredSingleImage createImage(ImageFileInfo imageInfo, String channelCode, ColorComponent colorComponentOrNull, ThumbnailsInfo thumbnailFilePathsOrNull) {
        RelativeImageReference relativeImageRef = new RelativeImageReference(imageInfo.getImageRelativePath(), imageInfo.tryGetUniqueStringIdentifier(), colorComponentOrNull);
        RelativeImageReference relativeThumbnailRef = null;
        if (thumbnailFilePathsOrNull != null) {
            String relativeThumbnailPath = thumbnailFilePathsOrNull.getThumbnailPath(RelativeImageFile.create(imageInfo), colorComponentOrNull);
            relativeThumbnailRef = new RelativeImageReference(relativeThumbnailPath, null, null);
        }
        Location wellLoc = null;
        if (imageInfo.hasWellLocation()) {
            wellLoc = Location.createLocationFromRowAndColumn((int)imageInfo.tryGetWellRow(), (int)imageInfo.tryGetWellColumn());
        }
        Location tileLoc = Location.createLocationFromRowAndColumn((int)imageInfo.getTileRow(), (int)imageInfo.getTileColumn());
        return new AcquiredSingleImage(wellLoc, tileLoc, channelCode, imageInfo.tryGetTimepoint(), imageInfo.tryGetDepth(), imageInfo.tryGetSeriesNumber(), relativeImageRef, relativeThumbnailRef);
    }

    protected static Integer tryAsInt(String valueOrNull) {
        if (valueOrNull == null) {
            return null;
        }
        try {
            return Integer.parseInt(valueOrNull);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected static Float tryAsFloat(String valueOrNull) {
        if (valueOrNull == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(valueOrNull));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

