/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class TabIdRecord
extends Record {
    public static final short sid = 317;
    public short[] field_1_tabids;

    public TabIdRecord() {
    }

    public TabIdRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 317) {
            throw new RecordFormatException("NOT A TABID RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_tabids = new short[in.remaining() / 2];
        for (int k = 0; k < this.field_1_tabids.length; ++k) {
            this.field_1_tabids[k] = in.readShort();
        }
    }

    public void setTabIdArray(short[] array) {
        this.field_1_tabids = array;
    }

    public short[] getTabIdArray() {
        return this.field_1_tabids;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TABID]\n");
        buffer.append("    .elements        = ").append(this.field_1_tabids.length).append("\n");
        for (int k = 0; k < this.field_1_tabids.length; ++k) {
            buffer.append("    .element_" + k + "       = ").append(this.field_1_tabids[k]).append("\n");
        }
        buffer.append("[/TABID]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        short[] tabids = this.getTabIdArray();
        short length = (short)(tabids.length * 2);
        int byteoffset = 4;
        LittleEndian.putShort(data, 0 + offset, (short)317);
        LittleEndian.putShort(data, 2 + offset, length);
        for (int k = 0; k < length / 2; ++k) {
            LittleEndian.putShort(data, byteoffset + offset, tabids[k]);
            byteoffset += 2;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.getTabIdArray().length * 2;
    }

    public short getSid() {
        return 317;
    }
}

