/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.primitives;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ome.xml.model.primitives.PrimitiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timestamp
extends PrimitiveType<String> {
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private final Date asDate;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public Timestamp(String value) {
        super(value);
        Date date = new Date();
        try {
            date = this.dateFormat.parse(value);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.asDate = date;
    }

    public Timestamp(Date date) {
        this.asDate = date;
        this.value = this.dateFormat.format(date);
    }

    public Timestamp(Calendar calendar) {
        this.asDate = calendar.getTime();
        this.value = this.dateFormat.format(this.asDate);
    }

    public static Timestamp valueOf(String value) {
        return new Timestamp(value);
    }

    public Date asDate() {
        return this.asDate;
    }

    public Calendar asCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.asDate);
        return calendar;
    }

    public java.sql.Date asSqlDate() {
        return new java.sql.Date(this.asDate.getTime());
    }
}

