/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructureData {
    protected StructureMembers members;

    public static StructureData copy(StructureData from) {
        return new StructureDataW(from);
    }

    public StructureData(StructureMembers members) {
        this.members = members;
    }

    public String getName() {
        return this.members.getName();
    }

    public StructureMembers getStructureMembers() {
        return this.members;
    }

    public List<StructureMembers.Member> getMembers() {
        return this.members.getMembers();
    }

    public StructureMembers.Member getMember(int index) {
        return this.members.getMember(index);
    }

    public StructureMembers.Member findMember(String memberName) {
        return this.members.findMember(memberName);
    }

    public abstract Array getArray(StructureMembers.Member var1);

    public Array getArray(String memberName) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getArray(m);
    }

    public Object getScalarObject(StructureMembers.Member m) {
        DataType dataType = m.getDataType();
        if (dataType == DataType.DOUBLE) {
            return this.getScalarDouble(m);
        }
        if (dataType == DataType.FLOAT) {
            return Float.valueOf(this.getScalarFloat(m));
        }
        if (dataType == DataType.BYTE) {
            return this.getScalarByte(m);
        }
        if (dataType == DataType.SHORT) {
            return this.getScalarShort(m);
        }
        if (dataType == DataType.INT) {
            return this.getScalarInt(m);
        }
        if (dataType == DataType.LONG) {
            return this.getScalarLong(m);
        }
        if (dataType == DataType.CHAR) {
            return this.getScalarString(m);
        }
        if (dataType == DataType.STRING) {
            return this.getScalarString(m);
        }
        if (dataType == DataType.STRUCTURE) {
            return this.getScalarStructure(m);
        }
        throw new RuntimeException("Dont have implemenation for " + dataType);
    }

    public double getScalarDouble(String memberName) {
        Array data = this.getArray(memberName);
        return data.getDouble(Array.scalarIndex);
    }

    public abstract double getScalarDouble(StructureMembers.Member var1);

    public abstract double[] getJavaArrayDouble(StructureMembers.Member var1);

    public float getScalarFloat(String memberName) {
        Array data = this.getArray(memberName);
        return data.getFloat(Array.scalarIndex);
    }

    public abstract float getScalarFloat(StructureMembers.Member var1);

    public abstract float[] getJavaArrayFloat(StructureMembers.Member var1);

    public byte getScalarByte(String memberName) {
        Array data = this.getArray(memberName);
        return data.getByte(Array.scalarIndex);
    }

    public abstract byte getScalarByte(StructureMembers.Member var1);

    public abstract byte[] getJavaArrayByte(StructureMembers.Member var1);

    public int getScalarInt(String memberName) {
        Array data = this.getArray(memberName);
        return data.getInt(Array.scalarIndex);
    }

    public abstract int getScalarInt(StructureMembers.Member var1);

    public abstract int[] getJavaArrayInt(StructureMembers.Member var1);

    public short getScalarShort(String memberName) {
        Array data = this.getArray(memberName);
        return data.getShort(Array.scalarIndex);
    }

    public abstract short getScalarShort(StructureMembers.Member var1);

    public abstract short[] getJavaArrayShort(StructureMembers.Member var1);

    public long getScalarLong(String memberName) {
        Array data = this.getArray(memberName);
        return data.getLong(Array.scalarIndex);
    }

    public abstract long getScalarLong(StructureMembers.Member var1);

    public abstract long[] getJavaArrayLong(StructureMembers.Member var1);

    public char getScalarChar(String memberName) {
        Array data = this.getArray(memberName);
        return data.getChar(Array.scalarIndex);
    }

    public abstract char getScalarChar(StructureMembers.Member var1);

    public abstract char[] getJavaArrayChar(StructureMembers.Member var1);

    public String getScalarString(String memberName) {
        StructureMembers.Member m = this.findMember(memberName);
        if (null == m) {
            throw new IllegalArgumentException("Member not found= " + memberName);
        }
        return this.getScalarString(m);
    }

    public abstract String getScalarString(StructureMembers.Member var1);

    public abstract String[] getJavaArrayString(StructureMembers.Member var1);

    public StructureData getScalarStructure(String memberName) {
        StructureMembers.Member m = this.findMember(memberName);
        if (null == m) {
            throw new IllegalArgumentException("Member not found= " + memberName);
        }
        return this.getScalarStructure(m);
    }

    public abstract StructureData getScalarStructure(StructureMembers.Member var1);

    public abstract ArrayStructure getArrayStructure(StructureMembers.Member var1);

    public Array findMemberArray(String memberName) {
        return this.getArray(memberName);
    }

    public Object getObject(StructureMembers.Member m) {
        return this.getScalarObject(m);
    }

    public double[] getArrayDouble(StructureMembers.Member m) {
        return this.getJavaArrayDouble(m);
    }

    public float[] getArrayFloat(StructureMembers.Member m) {
        return this.getJavaArrayFloat(m);
    }

    public byte[] getArrayByte(StructureMembers.Member m) {
        return this.getJavaArrayByte(m);
    }

    public int[] getArrayInt(StructureMembers.Member m) {
        return this.getJavaArrayInt(m);
    }

    public short[] getArrayShort(StructureMembers.Member m) {
        return this.getJavaArrayShort(m);
    }

    public long[] getArrayLong(StructureMembers.Member m) {
        return this.getJavaArrayLong(m);
    }

    public char[] getArrayChar(StructureMembers.Member m) {
        return this.getJavaArrayChar(m);
    }
}

