/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import thredds.catalog.DataType;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.EarthLocation;
import ucar.nc2.dt.EarthLocationImpl;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.VariableSimpleAdapter;
import ucar.nc2.dt.radial.RadialCoordSys;
import ucar.nc2.dt.radial.RadialDatasetSweepAdapter;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class LevelII2Dataset
extends RadialDatasetSweepAdapter
implements TypedDatasetFactoryIF {
    private NetcdfDataset ds;
    double latv;
    double lonv;
    double elev;
    DateFormatter formatter = new DateFormatter();

    public boolean isMine(NetcdfDataset ds) {
        String format;
        String convention = ds.findAttValueIgnoreCase(null, "Conventions", null);
        return null != convention && convention.equals("_Coordinates") && ((format = ds.findAttValueIgnoreCase(null, "Format", null)).equals("ARCHIVE2") || format.equals("AR2V0001") || format.equals("CINRAD-SA"));
    }

    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuffer errlog) throws IOException {
        return new LevelII2Dataset(ncd);
    }

    public DataType getScientificDataType() {
        return DataType.RADIAL;
    }

    public LevelII2Dataset() {
    }

    public LevelII2Dataset(NetcdfDataset ds) {
        super(ds);
        this.ds = ds;
        this.desc = "Nexrad 2 radar dataset";
        this.setEarthLocation();
        this.setTimeUnits();
        this.setStartDate();
        this.setEndDate();
        this.setBoundingBox();
    }

    protected void setEarthLocation() {
        Attribute ga = this.ds.findGlobalAttribute("StationLatitude");
        this.latv = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        ga = this.ds.findGlobalAttribute("StationLongitude");
        this.lonv = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        ga = this.ds.findGlobalAttribute("StationElevationInMeters");
        this.elev = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        this.origin = new EarthLocationImpl(this.latv, this.lonv, this.elev);
    }

    public EarthLocation getCommonOrigin() {
        return this.origin;
    }

    public String getRadarID() {
        Attribute ga = this.ds.findGlobalAttribute("Station");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "XXXX";
    }

    public String getRadarName() {
        Attribute ga = this.ds.findGlobalAttribute("StationName");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "Unknown Station";
    }

    public String getDataFormat() {
        return "Level II";
    }

    public boolean isVolume() {
        return true;
    }

    public boolean isStationary() {
        return true;
    }

    protected void setTimeUnits() {
        List<CoordinateAxis> axes = this.ds.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = axes.get(i);
            if (axis.getAxisType() != AxisType.Time) continue;
            String units = axis.getUnitsString();
            this.dateUnits = (DateUnit)SimpleUnit.factory(units);
            return;
        }
        this.parseInfo.append("*** Time Units not Found\n");
    }

    protected void setStartDate() {
        String start_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_start", null);
        if (start_datetime != null) {
            this.startDate = this.formatter.getISODate(start_datetime);
        } else {
            this.parseInfo.append("*** start_datetime not Found\n");
        }
    }

    protected void setEndDate() {
        String end_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_end", null);
        if (end_datetime != null) {
            this.endDate = this.formatter.getISODate(end_datetime);
        } else {
            this.parseInfo.append("*** end_datetime not Found\n");
        }
    }

    public void clearDatasetMemory() {
        List<VariableSimpleIF> rvars = this.getDataVariables();
        for (RadialDatasetSweep.RadialVariable radialVariable : rvars) {
            radialVariable.clearVariableMemory();
        }
    }

    public void getRadialsNum() {
        Variable rayVars = this.ds.findVariable("numRadialsV");
    }

    protected RadialDatasetSweep.RadialVariable makeRadialVariable(VariableEnhanced varDS, RadialCoordSys gcs) {
        return new LevelII2Variable(varDS, gcs);
    }

    public String getInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("LevelII2Dataset\n");
        sbuff.append(super.getDetailInfo());
        sbuff.append("\n\n");
        sbuff.append(this.parseInfo.toString());
        return sbuff.toString();
    }

    private static void testRadialVariable(RadialDatasetSweep.RadialVariable rv) throws IOException {
        RadialDatasetSweep.Sweep sw;
        int nsweep = rv.getNumSweeps();
        for (int i = 0; i < nsweep; ++i) {
            sw = rv.getSweep(i);
            float mele = sw.getMeanElevation();
            float me = sw.getMeanElevation();
            System.out.println("*** radar Sweep mean elevation of sweep " + i + " is: " + me);
            int nrays = sw.getRadialNumber();
            float[] az = new float[nrays];
            for (int j = 0; j < nrays; ++j) {
                float azi;
                az[j] = azi = sw.getAzimuth(j);
            }
        }
        sw = rv.getSweep(0);
        float[] ddd = sw.readData();
        float[] da = sw.getAzimuth();
        float[] de = sw.getElevation();
        assert (null != ddd);
        int nrays = sw.getRadialNumber();
        float[] az = new float[nrays];
        for (int i = 0; i < nrays; ++i) {
            int ngates = sw.getGateNumber();
            assert (ngates > 0);
            float[] d = sw.readData(i);
            assert (null != d);
            float azi = sw.getAzimuth(i);
            assert (azi > 0.0f);
            az[i] = azi;
            float ele = sw.getElevation(i);
            assert (ele > 0.0f);
            float la = (float)sw.getOrigin(i).getLatitude();
            assert (la > 0.0f);
            float lo = (float)sw.getOrigin(i).getLongitude();
            assert (lo > 0.0f);
            float al = (float)sw.getOrigin(i).getAltitude();
            assert (al > 0.0f);
        }
        assert (0 != nrays);
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "/home/yuanho/dorade/KATX_20040113_0107";
        RadialDatasetSweep rds = (RadialDatasetSweep)TypedDatasetFactory.open(DataType.RADIAL, fileIn, null, new StringBuffer());
        String st = rds.getStartDate().toString();
        String et = rds.getEndDate().toString();
        String id = rds.getRadarID();
        String name = rds.getRadarName();
        if (rds.isStationary()) {
            System.out.println("*** radar is stationary with name and id: " + name + " " + id);
        }
        List<VariableSimpleIF> rvars = rds.getDataVariables();
        RadialDatasetSweep.RadialVariable vDM = (RadialDatasetSweep.RadialVariable)rds.getDataVariable("Reflectivity");
        LevelII2Dataset.testRadialVariable(vDM);
        for (int i = 0; i < rvars.size(); ++i) {
            RadialDatasetSweep.RadialVariable rv = (RadialDatasetSweep.RadialVariable)rvars.get(i);
            LevelII2Dataset.testRadialVariable(rv);
        }
    }

    private class LevelII2Variable
    extends VariableSimpleAdapter
    implements RadialDatasetSweep.RadialVariable {
        protected RadialCoordSys radialCoordsys;
        protected VariableEnhanced ve;
        int nsweeps;
        int nrays;
        int ngates;
        RadialDatasetSweep.Sweep[] sweep;

        private LevelII2Variable(VariableEnhanced v, RadialCoordSys rcys) {
            super(v);
            this.ve = v;
            this.radialCoordsys = rcys;
            int[] shape = v.getShape();
            int count = v.getRank() - 1;
            this.ngates = shape[count];
            this.nrays = shape[--count];
            this.nsweeps = shape[--count];
            this.sweep = new RadialDatasetSweep.Sweep[this.nsweeps];
        }

        public int getNumSweeps() {
            return this.nsweeps;
        }

        public RadialDatasetSweep.Sweep getSweep(int sweepNo) {
            if (this.sweep[sweepNo] == null) {
                this.sweep[sweepNo] = new LevelII2Sweep(sweepNo);
            }
            return this.sweep[sweepNo];
        }

        public int getNumRadials() {
            return this.nsweeps * this.nrays;
        }

        public float[] readAllData() throws IOException {
            Array allData;
            try {
                allData = this.ve.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            return (float[])allData.get1DJavaArray(Float.TYPE);
        }

        public void clearVariableMemory() {
            for (int i = 0; i < this.nsweeps; ++i) {
                if (this.sweep[i] == null) continue;
                this.sweep[i].clearSweepMemory();
            }
        }

        private class LevelII2Sweep
        implements RadialDatasetSweep.Sweep {
            double meanElevation = Double.NaN;
            double meanAzimuth = Double.NaN;
            int sweepno;

            LevelII2Sweep(int sweepno) {
                this.sweepno = sweepno;
            }

            public float[] readData() throws IOException {
                int[] shape = LevelII2Variable.this.ve.getShape();
                int[] origin = new int[3];
                int numRadial = this.getRadialNumber();
                origin[0] = this.sweepno;
                origin[1] = shape[1] - numRadial;
                shape[0] = 1;
                shape[1] = numRadial;
                Array sweepTmp = null;
                try {
                    sweepTmp = LevelII2Variable.this.ve.read(origin, shape).reduce();
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
            }

            public float[] readData(int ray) throws IOException {
                int[] shape = LevelII2Variable.this.ve.getShape();
                int[] origin = new int[3];
                int numRadial = this.getRadialNumber();
                origin[0] = this.sweepno;
                origin[1] = shape[1] - numRadial + ray;
                shape[0] = 1;
                shape[1] = 1;
                Array sweepTmp = null;
                try {
                    sweepTmp = LevelII2Variable.this.ve.read(origin, shape).reduce();
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
            }

            public float getMeanElevation() {
                Array eleData = null;
                int[] shape = LevelII2Variable.this.ve.getShape();
                float sum = 0.0f;
                int sumSize = 0;
                try {
                    Array eleTmp = LevelII2Variable.this.radialCoordsys.getElevationAxisDataCached();
                    int[] eleOrigin = new int[]{this.sweepno, shape[1] - this.getRadialNumber()};
                    int[] eleShape = new int[]{1, this.getRadialNumber()};
                    eleData = eleTmp.section(eleOrigin, eleShape);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
                float[] eleArray = (float[])eleData.get1DJavaArray(Float.TYPE);
                int size = (int)eleData.getSize();
                for (int i = 0; i < size; ++i) {
                    if (Float.isNaN(eleArray[i])) continue;
                    sum += eleArray[i];
                    ++sumSize;
                }
                this.meanElevation = sum / (float)sumSize;
                return (float)this.meanElevation;
            }

            public double meanDouble(Array a) {
                double sum = 0.0;
                int size = 0;
                IndexIterator iterA = a.getIndexIterator();
                while (iterA.hasNext()) {
                    double s = iterA.getDoubleNext();
                    if (Double.isNaN(s)) continue;
                    sum += s;
                    ++size;
                }
                return sum / (double)size;
            }

            public int getGateNumber() {
                return LevelII2Variable.this.ngates;
            }

            public int getRadialNumber() {
                Variable rayVars = null;
                Array aData = null;
                rayVars = LevelII2Variable.this.ve.getName().startsWith("Reflectivity") ? LevelII2Dataset.this.ds.findVariable("numRadialsR") : LevelII2Dataset.this.ds.findVariable("numRadialsV");
                try {
                    aData = rayVars.read();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int[] numR = (int[])aData.get1DJavaArray(Integer.TYPE);
                return numR[this.sweepno];
            }

            public RadialDatasetSweep.Type getType() {
                return null;
            }

            public EarthLocation getOrigin(int ray) {
                return LevelII2Dataset.this.origin;
            }

            public Date getStartingTime() {
                return LevelII2Dataset.this.startDate;
            }

            public Date getEndingTime() {
                return LevelII2Dataset.this.endDate;
            }

            public int getSweepIndex() {
                return this.sweepno;
            }

            public float getMeanAzimuth() {
                if (this.getType() != null) {
                    try {
                        Array data = LevelII2Variable.this.radialCoordsys.getAzimuthAxisDataCached();
                        this.meanAzimuth = MAMath.sumDouble(data) / (double)data.getSize();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.meanAzimuth = 0.0;
                    }
                } else {
                    this.meanAzimuth = 0.0;
                }
                return (float)this.meanAzimuth;
            }

            public boolean isConic() {
                return true;
            }

            public float getElevation(int ray) throws IOException {
                Array eleData = null;
                int[] shape = LevelII2Variable.this.ve.getShape();
                try {
                    Array eleTmp = LevelII2Variable.this.radialCoordsys.getElevationAxisDataCached();
                    int[] eleOrigin = new int[]{this.sweepno, shape[1] - this.getRadialNumber()};
                    int[] eleShape = new int[]{1, this.getRadialNumber()};
                    eleData = eleTmp.section(eleOrigin, eleShape);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
                Index index = eleData.getIndex();
                return eleData.getFloat(index.set(ray));
            }

            public float[] getElevation() throws IOException {
                Array eleData = null;
                int[] shape = LevelII2Variable.this.ve.getShape();
                if (eleData == null) {
                    try {
                        Array eleTmp = LevelII2Variable.this.radialCoordsys.getElevationAxisDataCached();
                        int[] eleOrigin = new int[]{this.sweepno, shape[1] - this.getRadialNumber()};
                        int[] eleShape = new int[]{1, this.getRadialNumber()};
                        eleData = eleTmp.section(eleOrigin, eleShape);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                    }
                }
                return (float[])eleData.get1DJavaArray(Float.TYPE);
            }

            public float[] getAzimuth() throws IOException {
                Array aziData = null;
                int[] shape = LevelII2Variable.this.ve.getShape();
                if (aziData == null) {
                    try {
                        Array aziTmp = LevelII2Variable.this.radialCoordsys.getAzimuthAxisDataCached();
                        int[] aziOrigin = new int[]{this.sweepno, shape[1] - this.getRadialNumber()};
                        int[] aziShape = new int[]{1, this.getRadialNumber()};
                        aziData = aziTmp.section(aziOrigin, aziShape);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                    }
                }
                return (float[])aziData.get1DJavaArray(Float.TYPE);
            }

            public float getAzimuth(int ray) throws IOException {
                Array aziData = null;
                int[] shape = LevelII2Variable.this.ve.getShape();
                if (aziData == null) {
                    try {
                        Array aziTmp = LevelII2Variable.this.radialCoordsys.getAzimuthAxisDataCached();
                        int[] aziOrigin = new int[]{this.sweepno, shape[1] - this.getRadialNumber()};
                        int[] aziShape = new int[]{1, this.getRadialNumber()};
                        aziData = aziTmp.section(aziOrigin, aziShape);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                    }
                }
                Index index = aziData.getIndex();
                return aziData.getFloat(index.set(ray));
            }

            public float getRadialDistance(int gate) throws IOException {
                Array data = LevelII2Variable.this.radialCoordsys.getRadialAxisDataCached();
                Index index = data.getIndex();
                return data.getFloat(index.set(gate));
            }

            public float getTime(int ray) throws IOException {
                Array timeData = LevelII2Variable.this.radialCoordsys.getTimeAxisDataCached();
                Index timeIndex = timeData.getIndex();
                return timeData.getFloat(timeIndex.set(this.sweepno, ray));
            }

            public float getBeamWidth() {
                return 0.95f;
            }

            public float getNyquistFrequency() {
                return 0.0f;
            }

            public float getRangeToFirstGate() {
                return 0.0f;
            }

            public float getGateSize() {
                try {
                    return this.getRadialDistance(1) - this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            public boolean isGateSizeConstant() {
                return true;
            }

            public void clearSweepMemory() {
            }
        }
    }
}

