/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.DirectoryScanningTimerTask;
import ch.systemsx.cisd.common.filesystem.IDirectoryScanningHandler;
import ch.systemsx.cisd.common.filesystem.IStopSignaler;
import ch.systemsx.cisd.common.filesystem.StoreItem;
import ch.systemsx.cisd.common.io.CollectionIO;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public final class FaultyPathDirectoryScanningHandler
implements IDirectoryScanningHandler {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FaultyPathDirectoryScanningHandler.class);
    private final Set<StoreItem> faultyPaths = new HashSet<StoreItem>();
    private final File faultyPathsFile;
    private long faultyPathsLastChanged;
    private IStopSignaler stopSignaler;
    private final IFaultyPathDirectoryScanningHandlerDelegate delegate;

    public FaultyPathDirectoryScanningHandler(File faultyPathDirectory, IStopSignaler stopSignaler) {
        this(faultyPathDirectory, stopSignaler, null);
    }

    public FaultyPathDirectoryScanningHandler(File faultyPathDirectory, IStopSignaler stopSignaler, IFaultyPathDirectoryScanningHandlerDelegate delegate) {
        this.faultyPathsFile = new File(faultyPathDirectory, ".faulty_paths");
        this.stopSignaler = stopSignaler;
        this.delegate = delegate;
    }

    private Set<String> faultyPathsAsStrings(DirectoryScanningTimerTask.IScannedStore scannedStore) {
        HashSet<String> faultyPathStrings = new HashSet<String>(this.faultyPaths.size());
        for (StoreItem item : this.faultyPaths) {
            faultyPathStrings.add(scannedStore.getLocationDescription(item));
        }
        return faultyPathStrings;
    }

    private void setFaultyPathsFromStrings(DirectoryScanningTimerTask.IScannedStore scannedStore, Set<String> faultyPathStrings) {
        this.faultyPaths.clear();
        for (String faultyPath : faultyPathStrings) {
            this.faultyPaths.add(scannedStore.asStoreItem(faultyPath));
        }
    }

    private final void checkForFaultyPathsFileChanged(DirectoryScanningTimerTask.IScannedStore scannedStore) {
        if (this.faultyPathsFile.exists()) {
            if (this.faultyPathsFile.lastModified() > this.faultyPathsLastChanged) {
                HashSet<String> faultyPathStrings = new HashSet<String>();
                CollectionIO.readCollection(this.faultyPathsFile, faultyPathStrings);
                HashSet<StoreItem> faultyPathsCopy = operationLog.isInfoEnabled() ? new HashSet<StoreItem>(this.faultyPaths) : null;
                this.setFaultyPathsFromStrings(scannedStore, faultyPathStrings);
                this.faultyPathsLastChanged = this.faultyPathsFile.lastModified();
                if (operationLog.isInfoEnabled() && !this.faultyPaths.equals(faultyPathsCopy)) {
                    operationLog.info((Object)String.format("Reread faulty paths file '%s'. New entries are '%s'.", FaultyPathDirectoryScanningHandler.getLocationDescription(this.faultyPathsFile), CollectionUtils.abbreviate(this.faultyPaths, 10)));
                }
            }
        } else if (!this.faultyPaths.isEmpty()) {
            this.faultyPaths.clear();
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format("Faulty paths file '%s' has been removed manually.", FaultyPathDirectoryScanningHandler.getLocationDescription(this.faultyPathsFile)));
            }
        }
    }

    private static final String getLocationDescription(File file) {
        return file.getPath();
    }

    private final boolean isFaultyPathsFile(DirectoryScanningTimerTask.IScannedStore scannedStore, StoreItem storeItem) {
        String itemLocation = scannedStore.getLocationDescription(storeItem);
        String faultyPathsLocation = FaultyPathDirectoryScanningHandler.getLocationDescription(this.faultyPathsFile);
        return itemLocation.equals(faultyPathsLocation);
    }

    private final void addToFaultyPaths(DirectoryScanningTimerTask.IScannedStore scannedStore, StoreItem item) {
        if (operationLog.isDebugEnabled()) {
            String path = scannedStore.getLocationDescription(item);
            operationLog.debug((Object)String.format("Path '%s' has been added to faulty paths file '%s'", path, this.faultyPathsFile.getAbsolutePath()));
        }
        this.faultyPaths.add(item);
        this.refreshFaultyPathsFile(scannedStore);
    }

    private final void refreshFaultyPathsFile(DirectoryScanningTimerTask.IScannedStore scannedStore) {
        CollectionIO.writeIterable(this.faultyPathsFile, this.faultyPathsAsStrings(scannedStore));
        this.faultyPathsLastChanged = this.faultyPathsFile.lastModified();
    }

    @Override
    public void init(DirectoryScanningTimerTask.IScannedStore scannedStore) {
        Iterator<StoreItem> it = this.faultyPaths.iterator();
        boolean changedFaultyPaths = false;
        while (it.hasNext()) {
            StoreItem item = it.next();
            if (scannedStore.existsOrError(item)) continue;
            it.remove();
            changedFaultyPaths = true;
        }
        if (changedFaultyPaths) {
            this.refreshFaultyPathsFile(scannedStore);
        }
    }

    @Override
    public final void beforeHandle(DirectoryScanningTimerTask.IScannedStore scannedStore) {
        this.checkForFaultyPathsFileChanged(scannedStore);
    }

    @Override
    public final IDirectoryScanningHandler.HandleInstruction mayHandle(DirectoryScanningTimerTask.IScannedStore scannedStore, StoreItem storeItem) {
        if (this.isFaultyPathsFile(scannedStore, storeItem)) {
            return IDirectoryScanningHandler.HandleInstruction.IGNORE;
        }
        if (this.faultyPaths.contains(storeItem)) {
            return IDirectoryScanningHandler.HandleInstruction.createError("Known bad item '%s'.", storeItem);
        }
        return IDirectoryScanningHandler.HandleInstruction.PROCESS;
    }

    @Override
    public final Status finishItemHandle(DirectoryScanningTimerTask.IScannedStore scannedStore, StoreItem storeItem) {
        if (this.delegate != null && this.delegate.shouldNotAddToFaultyPathsOrNull(scannedStore.asFile(storeItem))) {
            operationLog.info((Object)("File " + storeItem + " not written to faulty paths. It will be reprocessed during the next iteration."));
            return Status.OK;
        }
        if (scannedStore.existsOrError(storeItem) && !this.stopSignaler.isStopped()) {
            this.addToFaultyPaths(scannedStore, storeItem);
            return Status.createError("Failed to move item '%s'.", storeItem);
        }
        return Status.OK;
    }

    public static interface IFaultyPathDirectoryScanningHandlerDelegate {
        public boolean shouldNotAddToFaultyPathsOrNull(File var1);
    }
}

