/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.hdf5;

import ch.systemsx.cisd.openbis.common.hdf5.HDF5ContainerReader;
import ch.systemsx.cisd.openbis.common.hdf5.HDF5ContainerWriter;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerReader;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerWriter;
import java.io.File;

public class HDF5Container {
    private final File hdf5Container;

    public static void disableCaching() {
        HDF5ContainerReader.disableCaching();
    }

    public HDF5Container(File hdf5Container) {
        this.hdf5Container = hdf5Container;
    }

    public File getHDF5File() {
        return this.hdf5Container;
    }

    public IHDF5ContainerReader createSimpleReader() {
        return new HDF5ContainerReader(this.hdf5Container);
    }

    private IHDF5ContainerWriter createSimpleWriter(boolean isContentCompressed) {
        return new HDF5ContainerWriter(this, this.hdf5Container, isContentCompressed);
    }

    public void runWriterClient(boolean isContentCompressed, IHDF5WriterClient client) {
        IHDF5ContainerWriter writer = this.createSimpleWriter(isContentCompressed);
        try {
            client.runWithSimpleWriter(writer);
        }
        finally {
            writer.close();
        }
    }

    public void runReaderClient(IHDF5ReaderClient client) {
        IHDF5ContainerReader reader = this.createSimpleReader();
        try {
            client.runWithSimpleReader(reader);
        }
        finally {
            reader.close();
        }
    }

    public static interface IHDF5ReaderClient {
        public void runWithSimpleReader(IHDF5ContainerReader var1);
    }

    public static interface IHDF5WriterClient {
        public void runWithSimpleWriter(IHDF5ContainerWriter var1);
    }
}

