/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbcp.AbandonedConfig;

public class AbandonedTrace {
    private final AbandonedConfig config;
    private volatile Exception createdBy;
    private final List traceList = new ArrayList();
    private volatile long lastUsed = 0L;

    public AbandonedTrace() {
        this.config = null;
        this.init(null);
    }

    public AbandonedTrace(AbandonedConfig abandonedConfig) {
        this.config = abandonedConfig;
        this.init(null);
    }

    public AbandonedTrace(AbandonedTrace abandonedTrace) {
        this.config = abandonedTrace.getConfig();
        this.init(abandonedTrace);
    }

    private void init(AbandonedTrace abandonedTrace) {
        if (abandonedTrace != null) {
            abandonedTrace.addTrace(this);
        }
        if (this.config == null) {
            return;
        }
        if (this.config.getLogAbandoned()) {
            this.createdBy = new AbandonedObjectException();
        }
    }

    protected AbandonedConfig getConfig() {
        return this.config;
    }

    protected long getLastUsed() {
        return this.lastUsed;
    }

    protected void setLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    protected void setLastUsed(long l) {
        this.lastUsed = l;
    }

    protected void setStackTrace() {
        if (this.config == null) {
            return;
        }
        if (this.config.getLogAbandoned()) {
            this.createdBy = new AbandonedObjectException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTrace(AbandonedTrace abandonedTrace) {
        List list = this.traceList;
        synchronized (list) {
            this.traceList.add(abandonedTrace);
        }
        this.setLastUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTrace() {
        List list = this.traceList;
        synchronized (list) {
            this.traceList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getTrace() {
        List list = this.traceList;
        synchronized (list) {
            return new ArrayList(this.traceList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        if (this.createdBy != null && this.config != null) {
            this.createdBy.printStackTrace(this.config.getLogWriter());
        }
        List list = this.traceList;
        synchronized (list) {
            for (AbandonedTrace abandonedTrace : this.traceList) {
                abandonedTrace.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTrace(AbandonedTrace abandonedTrace) {
        List list = this.traceList;
        synchronized (list) {
            this.traceList.remove(abandonedTrace);
        }
    }

    static class AbandonedObjectException
    extends Exception {
        private static final long serialVersionUID = 7398692158058772916L;
        private static final SimpleDateFormat format = new SimpleDateFormat("'DBCP object created' yyyy-MM-dd HH:mm:ss 'by the following code was never closed:'");
        private final long _createdTime = System.currentTimeMillis();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getMessage() {
            String string;
            SimpleDateFormat simpleDateFormat = format;
            synchronized (simpleDateFormat) {
                string = format.format(new Date(this._createdTime));
            }
            return string;
        }
    }
}

