/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ChainedClosure;
import org.apache.commons.collections.functors.EqualPredicate;
import org.apache.commons.collections.functors.ExceptionClosure;
import org.apache.commons.collections.functors.ForClosure;
import org.apache.commons.collections.functors.IfClosure;
import org.apache.commons.collections.functors.InvokerTransformer;
import org.apache.commons.collections.functors.NOPClosure;
import org.apache.commons.collections.functors.SwitchClosure;
import org.apache.commons.collections.functors.TransformerClosure;
import org.apache.commons.collections.functors.WhileClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureUtils {
    public static Closure exceptionClosure() {
        return ExceptionClosure.INSTANCE;
    }

    public static Closure nopClosure() {
        return NOPClosure.INSTANCE;
    }

    public static <I, O> Closure<I> asClosure(Transformer<I, O> transformer) {
        return TransformerClosure.getInstance(transformer);
    }

    public static <T> Closure<T> forClosure(int count, Closure<T> closure) {
        return ForClosure.getInstance(count, closure);
    }

    public static <T> Closure<T> whileClosure(Predicate<? super T> predicate, Closure<? super T> closure) {
        return WhileClosure.getInstance(predicate, closure, false);
    }

    public static <T> Closure<T> doWhileClosure(Closure<? super T> closure, Predicate<? super T> predicate) {
        return WhileClosure.getInstance(predicate, closure, true);
    }

    public static Closure invokerClosure(String methodName) {
        return ClosureUtils.asClosure(InvokerTransformer.getInstance(methodName));
    }

    public static Closure invokerClosure(String methodName, Class[] paramTypes, Object[] args) {
        return ClosureUtils.asClosure(InvokerTransformer.getInstance(methodName, paramTypes, args));
    }

    public static <T> Closure<T> chainedClosure(Closure<T> closure1, Closure<T> closure2) {
        return ChainedClosure.getInstance(closure1, closure2);
    }

    public static <T> Closure<T> chainedClosure(Closure<T>[] closures) {
        return ChainedClosure.getInstance(closures);
    }

    public static <T> Closure<T> chainedClosure(Collection<T> closures) {
        return ChainedClosure.getInstance(closures);
    }

    public static <T> Closure<T> ifClosure(Predicate<? super T> predicate, Closure<? super T> trueClosure, Closure<? super T> falseClosure) {
        return IfClosure.getInstance(predicate, trueClosure, falseClosure);
    }

    public static <T> Closure<T> switchClosure(Predicate<? super T>[] predicates, Closure<? super T>[] closures) {
        return SwitchClosure.getInstance(predicates, closures, null);
    }

    public static <T> Closure<T> switchClosure(Predicate<? super T>[] predicates, Closure<? super T>[] closures, Closure<? super T> defaultClosure) {
        return SwitchClosure.getInstance(predicates, closures, defaultClosure);
    }

    public static <T> Closure<T> switchClosure(Map<Predicate<? super T>, Closure<? super T>> predicatesAndClosures) {
        return SwitchClosure.getInstance(predicatesAndClosures);
    }

    public static <T> Closure<T> switchMapClosure(Map<T, Closure<T>> objectsAndClosures) {
        Closure[] trs = null;
        Predicate[] preds = null;
        if (objectsAndClosures == null) {
            throw new IllegalArgumentException("The object and closure map must not be null");
        }
        Closure<T> def = objectsAndClosures.remove(null);
        int size = objectsAndClosures.size();
        trs = new Closure[size];
        preds = new Predicate[size];
        int i = 0;
        for (Map.Entry<T, Closure<T>> entry : objectsAndClosures.entrySet()) {
            preds[i] = EqualPredicate.getInstance(entry.getKey());
            trs[i] = entry.getValue();
            ++i;
        }
        return ClosureUtils.switchClosure(preds, trs, def);
    }
}

