/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.control;

import ch.systemsx.cisd.common.filesystem.control.IEventFeed;
import ch.systemsx.cisd.common.filesystem.control.IEventFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ControlDirectoryEventFeed
implements IEventFeed {
    private final File controlDir;

    public ControlDirectoryEventFeed(File controlDir) {
        this.controlDir = controlDir;
    }

    @Override
    public List<String> getNewEvents(IEventFilter filter) {
        ArrayList<String> events = new ArrayList<String>();
        if (!this.controlDir.exists() || !this.controlDir.isDirectory()) {
            return events;
        }
        List<File> files = Arrays.asList(this.controlDir.listFiles());
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
            }
        });
        for (File file : files) {
            String fileName = file.getName();
            if (!file.isFile() || !filter.accepts(fileName)) continue;
            events.add(fileName);
            file.delete();
        }
        return events;
    }
}

