/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.postregistration;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.etlserver.postregistration.ICleanupTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.log4j.Logger;

public class TaskExecutor {
    @Private
    static final String CLEANUP_TASKS_FOLDER_PROPERTY = "cleanup-tasks-folder";
    private static final String DEFAULT_CLEANUP_TASKS_FOLDER = "clean-up-tasks";
    private static final String FILE_TYPE = ".ser";
    private static final FilenameFilter FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(TaskExecutor.FILE_TYPE);
        }
    };
    private final Logger operationLog;
    private final File cleanupTasksFolder;

    public TaskExecutor(Properties properties, Logger operationLog) {
        this.operationLog = operationLog;
        this.cleanupTasksFolder = new File(properties.getProperty(CLEANUP_TASKS_FOLDER_PROPERTY, DEFAULT_CLEANUP_TASKS_FOLDER));
        if (this.cleanupTasksFolder.isFile()) {
            throw new EnvironmentFailureException("Cleanup tasks folder is a file: " + this.cleanupTasksFolder.getAbsolutePath());
        }
        this.cleanupTasksFolder.mkdirs();
    }

    public void execute(IPostRegistrationTask task, String taskName, String dataSetCode, boolean container) throws Throwable {
        ICleanupTask cleanupTask = null;
        File savedCleanupTask = null;
        try {
            try {
                IPostRegistrationTaskExecutor executor = task.createExecutor(dataSetCode, container);
                cleanupTask = executor.createCleanupTask();
                savedCleanupTask = this.saveCleanupTask(dataSetCode, taskName, cleanupTask);
                executor.execute();
            }
            catch (Throwable t) {
                this.cleanUpAndLog(t, cleanupTask, dataSetCode, taskName);
                throw t;
            }
        }
        finally {
            if (savedCleanupTask != null) {
                savedCleanupTask.delete();
            }
        }
    }

    private File saveCleanupTask(String code, String taskName, ICleanupTask cleanupTask) {
        try {
            File file = new File(this.cleanupTasksFolder, String.valueOf(code) + "_" + taskName + FILE_TYPE);
            FileUtils.writeByteArrayToFile((File)file, (byte[])SerializationUtils.serialize((Serializable)cleanupTask));
            return file;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private void cleanUpAndLog(Throwable throwable, ICleanupTask cleanupTaskOrNull, String dataSetCode, String taskName) {
        this.operationLog.error((Object)("Task '" + taskName + "' for data set " + dataSetCode + " failed."), throwable);
        if (cleanupTaskOrNull != null) {
            try {
                cleanupTaskOrNull.cleanup(new Log4jSimpleLogger(this.operationLog));
            }
            catch (Throwable t) {
                this.operationLog.error((Object)("Clean up of failed task '" + taskName + "' for data set " + dataSetCode + " failed, too."), t);
            }
        }
    }

    public void cleanup() {
        Log4jSimpleLogger logger = new Log4jSimpleLogger(this.operationLog);
        File[] files = this.cleanupTasksFolder.listFiles(FILTER);
        if (files != null && files.length > 0) {
            this.operationLog.info((Object)("Perform " + files.length + " clean up task."));
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    ICleanupTask cleanupTask = this.deserializeFromFile(file);
                    cleanupTask.cleanup(logger);
                }
                catch (Exception ex) {
                    this.operationLog.error((Object)("Couldn't performed clean up task " + file), (Throwable)ex);
                }
                file.delete();
                ++n2;
            }
        }
    }

    private ICleanupTask deserializeFromFile(File file) throws IOException {
        byte[] bytes = FileUtils.readFileToByteArray((File)file);
        return (ICleanupTask)SerializationUtils.deserialize((byte[])bytes);
    }
}

