/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.ExceptionWithStatus;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.filesystem.IPathCopier;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetFileOperationsExecutor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class LocalDataSetFileOperationsExcecutor
implements IDataSetFileOperationsExecutor {
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, LocalDataSetFileOperationsExcecutor.class);
    private final IPathCopier copier;
    private final String rsyncModuleNameOrNull;
    private final String rsyncPasswordFileOrNull;
    private final IFileOperations fileOperations;

    public LocalDataSetFileOperationsExcecutor(IFileOperations fileOperations, IPathCopier copier, String rsyncModuleNameOrNull, String rsyncPasswordFileOrNull) {
        this.fileOperations = fileOperations;
        this.copier = copier;
        this.rsyncModuleNameOrNull = rsyncModuleNameOrNull;
        this.rsyncPasswordFileOrNull = rsyncPasswordFileOrNull;
    }

    @Override
    public BooleanStatus checkSame(File dataSet, File destination) {
        if (!this.fileOperations.exists(dataSet)) {
            return BooleanStatus.createFalse("Data set location '" + dataSet + "' doesn't exist");
        }
        if (!this.fileOperations.exists(destination)) {
            return BooleanStatus.createFalse("Destination location '" + destination + "' doesn't exist");
        }
        if (dataSet.isDirectory()) {
            if (destination.isDirectory()) {
                Map<String, Long> destinationFileSizesByPaths;
                FileFilter nullFilter = null;
                List<File> storeFiles = FileUtilities.listFiles(dataSet, nullFilter, true);
                List<File> destFiles = FileUtilities.listFiles(destination, nullFilter, true);
                Map<String, Long> dataSetFileSizesByPaths = FolderFileSizesReportGenerator.extractSizesByPaths(storeFiles, dataSet);
                String inconsistenciesReport = FolderFileSizesReportGenerator.findInconsistencies(dataSetFileSizesByPaths, destinationFileSizesByPaths = FolderFileSizesReportGenerator.extractSizesByPaths(destFiles, destination));
                if (StringUtils.isBlank((String)inconsistenciesReport)) {
                    return BooleanStatus.createTrue();
                }
                return BooleanStatus.createFalse("Inconsistencies:\n" + inconsistenciesReport);
            }
            return BooleanStatus.createFalse("Data set location '" + dataSet + "' is a directory while destination location '" + destination + "' isn't.\n");
        }
        if (destination.isDirectory()) {
            return BooleanStatus.createFalse("Destination location '" + destination + "' is a directory while data set location '" + dataSet + "' isn't.\n");
        }
        if (dataSet.length() != destination.length()) {
            return BooleanStatus.createFalse(FolderFileSizesReportGenerator.createDifferentSizesMsg(dataSet.getPath(), dataSet.length(), destination.length()));
        }
        return BooleanStatus.createTrue();
    }

    @Override
    public BooleanStatus exists(File file) {
        return BooleanStatus.createFromBoolean(this.fileOperations.exists(file));
    }

    @Override
    public void createFolder(File folder) {
        try {
            this.fileOperations.mkdirs(folder);
        }
        catch (Exception ex) {
            operationLog.error((Object)("Creation of '" + folder + "' failed."), (Throwable)ex);
            throw new ExceptionWithStatus(Status.createError("couldn't create directory"));
        }
    }

    @Override
    public void deleteFolder(File folder) {
        try {
            this.fileOperations.deleteRecursively(folder);
        }
        catch (Exception ex) {
            operationLog.error((Object)("Deletion of '" + folder + "' failed."), (Throwable)ex);
            throw new ExceptionWithStatus(Status.createError("couldn't delete"));
        }
    }

    @Override
    public void copyDataSetToDestination(File dataSet, File destination) {
        this.syncDataSetWithDestination(dataSet, destination);
    }

    @Override
    public void syncDataSetWithDestination(File dataSet, File destination) {
        String host = null;
        Status result = this.copier.copyToRemote(dataSet, destination.getPath(), host, this.rsyncModuleNameOrNull, this.rsyncPasswordFileOrNull);
        if (result.isError()) {
            throw new ExceptionWithStatus(result);
        }
    }

    @Override
    public void retrieveDataSetFromDestination(File dataSet, File destination) {
        try {
            if (destination.isFile()) {
                this.fileOperations.copyFileToDirectory(destination, dataSet);
            } else {
                this.fileOperations.copyDirectoryToDirectory(destination, dataSet);
            }
            new File(dataSet, destination.getName()).setLastModified(destination.lastModified());
        }
        catch (Exception ex) {
            operationLog.error((Object)("Couldn't retrieve '" + destination + "' to '" + dataSet + "'"), (Throwable)ex);
            throw new ExceptionWithStatus(Status.createError("retrieve failed"), ex);
        }
    }

    @Override
    public void renameTo(File newFile, File oldFile) {
        boolean result = oldFile.renameTo(newFile);
        if (!result) {
            operationLog.error((Object)("Couldn't rename '" + oldFile + "' to '" + newFile + "'."));
            throw new ExceptionWithStatus(Status.createError("rename failed"));
        }
    }

    @Override
    public void createMarkerFile(File markerFile) {
        try {
            boolean result = markerFile.createNewFile();
            if (!result) {
                throw new IOException("File '" + markerFile + "' already exists.");
            }
        }
        catch (IOException ex) {
            operationLog.error((Object)("Couldn't create marker file '" + markerFile + "'."), (Throwable)ex);
            throw new ExceptionWithStatus(Status.createError("creating a marker file failed"), ex);
        }
    }

    static class FolderFileSizesReportGenerator {
        private static String DESTINATION = "destination";
        private static String STORE = "store";
        private static String DIFFERENT_SIZES_MSG = "'%s' - different file sizes; store: %d, destination: %d\n";
        private static String NOT_EXISTS_MSG = "'%s' - exists in %s but is missing in %s\n";

        FolderFileSizesReportGenerator() {
        }

        private static String createMissingFileMsg(String path, String existsIn, String missingIn) {
            return String.format(NOT_EXISTS_MSG, path, existsIn, missingIn);
        }

        public static String createDifferentSizesMsg(String path, Long storeFileSize, Long destinationFileSize) {
            return String.format(DIFFERENT_SIZES_MSG, path, storeFileSize, destinationFileSize);
        }

        public static Map<String, Long> extractSizesByPaths(List<File> files, File root) {
            LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
            for (File file : files) {
                String relativePath = FileUtilities.getRelativeFilePath(root, file);
                result.put(relativePath, file.length());
            }
            return result;
        }

        public static String findInconsistencies(Map<String, Long> dataSetFileSizesByPaths, Map<String, Long> destinationFileSizesByPaths) {
            ArrayList<String> inconsistencies = new ArrayList<String>();
            for (Map.Entry<String, Long> sizeByPath : dataSetFileSizesByPaths.entrySet()) {
                String path = sizeByPath.getKey();
                Long size = sizeByPath.getValue();
                if (destinationFileSizesByPaths.containsKey(path)) {
                    Long destinationSize = destinationFileSizesByPaths.get(path);
                    if (!size.equals(destinationSize)) {
                        inconsistencies.add(FolderFileSizesReportGenerator.createDifferentSizesMsg(path, size, destinationSize));
                    }
                    destinationFileSizesByPaths.remove(path);
                    continue;
                }
                inconsistencies.add(FolderFileSizesReportGenerator.createMissingFileMsg(path, STORE, DESTINATION));
            }
            for (String remainingDestinationPath : destinationFileSizesByPaths.keySet()) {
                inconsistencies.add(FolderFileSizesReportGenerator.createMissingFileMsg(remainingDestinationPath, DESTINATION, STORE));
            }
            Collections.sort(inconsistencies);
            return StringUtils.join(inconsistencies, null);
        }
    }
}

