/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.proteomics.server.plugins;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;

public class APMSReport
extends AbstractTableModelReportingPlugin
implements IProcessingPluginTask {
    private static final long serialVersionUID = 1L;
    @Private
    static final String PROTEIN_FILE_NAME = "proteins.csv";
    private static final String PROTEIN_PROPERTY_CODE_KEY = "protein-property-code";
    @Private
    static final String DEFAULT_PROTEIN_PROPERTY_CODE = "PROTEIN";
    private static final Template E_MAIL_CONTENT_TEMPLATE = new Template("Dear User\n\nEnclosed you will find the Protein APMS report file for experiment ${experiment-identifier}.\nData Set: ${data-set}");
    private final String proteinPropertyCode;
    private IEncapsulatedOpenBISService service;

    public APMSReport(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        this.proteinPropertyCode = properties.getProperty(PROTEIN_PROPERTY_CODE_KEY, DEFAULT_PROTEIN_PROPERTY_CODE);
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        if (datasets.size() != 1) {
            throw new UserFailureException("Chosen plugin works with exactly one data set. " + datasets.size() + " data sets selected.");
        }
        return this.createTableModel(datasets.get(0), context.getDirectoryProvider());
    }

    @Override
    public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        ProcessingStatus status = new ProcessingStatus();
        for (DatasetDescription datasetDescription : datasets) {
            try {
                this.process(datasetDescription, context);
                status.addDatasetStatus(datasetDescription, Status.OK);
            }
            catch (Exception ex) {
                status.addDatasetStatus(datasetDescription, Status.createError("Exception occured: " + ex));
                operationLog.error((Object)("Exception occured while processing " + datasetDescription), (Throwable)ex);
            }
        }
        return status;
    }

    private void process(DatasetDescription datasetDescription, DataSetProcessingContext context) {
        try {
            TableModel table = this.createTableModel(datasetDescription, context.getDirectoryProvider());
            String tableAsString = APMSReport.convertTableToCsvString(table);
            String experimentIdentifier = String.valueOf(datasetDescription.getSpaceCode()) + '/' + datasetDescription.getProjectCode() + '/' + datasetDescription.getExperimentCode();
            Template template = E_MAIL_CONTENT_TEMPLATE.createFreshCopy();
            template.bind("experiment-identifier", experimentIdentifier);
            template.bind("data-set", datasetDescription.getDataSetCode());
            ByteArrayDataSource dataSource = new ByteArrayDataSource(tableAsString, "text/plain");
            context.getMailClient().sendEmailMessageWithAttachment("Protein APMS Report", template.createText(), String.valueOf(datasetDescription.getExperimentCode()) + "-APMS-report.txt", new DataHandler((DataSource)dataSource), null, null, new EMailAddress(context.getUserEmailOrNull()));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private TableModel createTableModel(DatasetDescription datasetDescription, IDataSetDirectoryProvider directoryProvider) {
        File proteinFile = this.getProteinFile(datasetDescription, directoryProvider);
        Table table = this.readTable(proteinFile);
        this.addHeaderMetaData(table);
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder();
        builder.addHeader("Sample ID");
        builder.addHeader("Bait");
        builder.addHeader("Prey");
        builder.addHeader("freq of obs");
        builder.addHeader("avg MS1 intensities (normalized for the bait)");
        builder.addHeader("STDV MS1 intensity");
        List<Map.Entry<String, List<Header>>> groups = this.calculateAbundanceColumnGroups(table);
        List<Row> rows = table.getRows();
        int i = 0;
        while (i < rows.size()) {
            Row row = rows.get(i);
            this.addRowsTo(builder, row, i, groups);
            ++i;
        }
        return builder.getTableModel();
    }

    private List<Map.Entry<String, List<Header>>> calculateAbundanceColumnGroups(Table table) {
        List<Header> headers = table.getHeaders();
        HashMap<String, ArrayList<Header>> abundanceColumnHeaders = new HashMap<String, ArrayList<Header>>();
        for (Header header : headers) {
            if (!header.isAbundanceHeader()) continue;
            String biologicalSample = header.getBiologicalSample();
            ArrayList<Header> list = (ArrayList<Header>)abundanceColumnHeaders.get(biologicalSample);
            if (list == null) {
                list = new ArrayList<Header>();
                abundanceColumnHeaders.put(biologicalSample, list);
            }
            list.add(header);
        }
        Set entrySet = abundanceColumnHeaders.entrySet();
        ArrayList<Map.Entry<String, List<Header>>> entryList = new ArrayList<Map.Entry<String, List<Header>>>(entrySet);
        Collections.sort(entryList, new Comparator<Map.Entry<String, List<Header>>>(){

            @Override
            public int compare(Map.Entry<String, List<Header>> e1, Map.Entry<String, List<Header>> e2) {
                String key1 = e1.getKey();
                String key2 = e2.getKey();
                if (key1 != null && key2 != null) {
                    return key1.compareTo(key2);
                }
                return key1 == null ? (key2 == null ? 0 : 1) : -1;
            }
        });
        return entryList;
    }

    private void addRowsTo(SimpleTableModelBuilder builder, Row row, int i, List<Map.Entry<String, List<Header>>> groups) {
        String identifiedProtein = row.getValue("protein");
        for (Map.Entry<String, List<Header>> group : groups) {
            String biologicalSample = group.getKey();
            List<Header> headers = group.getValue();
            String protein = null;
            double countNonZeroAbundances = 0.0;
            double sum = 0.0;
            double sum2 = 0.0;
            for (Header header : headers) {
                if (biologicalSample != null && protein == null) {
                    protein = header.getProtein();
                }
                String value = row.getValue(header.getHeader());
                try {
                    double abundance = Double.parseDouble(value);
                    sum += abundance;
                    sum2 += abundance * abundance;
                    if (!(abundance > 0.0)) continue;
                    countNonZeroAbundances += 1.0;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UserFailureException(String.valueOf(i + 5) + ". row has an invalid value (" + value + ") for column " + header.getHeader() + ": " + row);
                }
            }
            double averagedAbundance = sum / (double)headers.size();
            double abundanceStandardDeviation = Math.sqrt(Math.max(0.0, sum2 / (double)headers.size() - averagedAbundance * averagedAbundance));
            double frequencyOfObservation = countNonZeroAbundances / (double)headers.size();
            StringTableCell biologicalSampleCell = StringTableCell.wrap(biologicalSample);
            StringTableCell proteinCell = StringTableCell.wrap(protein);
            StringTableCell identifiedProteinCell = new StringTableCell(identifiedProtein);
            DoubleTableCell freqOfObsvCell = new DoubleTableCell(frequencyOfObservation);
            DoubleTableCell abundanceCell = new DoubleTableCell(averagedAbundance);
            DoubleTableCell abundanceStdvCell = new DoubleTableCell(abundanceStandardDeviation);
            builder.addRow(Arrays.asList(biologicalSampleCell, proteinCell, identifiedProteinCell, freqOfObsvCell, abundanceCell, abundanceStdvCell));
        }
    }

    private void addHeaderMetaData(Table table) {
        List<Header> headers = table.getHeaders();
        for (Header header : headers) {
            if (!header.isAbundanceHeader()) continue;
            SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse("/MS_DATA/" + header.getHeader().toUpperCase());
            Sample sample = this.getService().tryGetSampleWithExperiment(sampleIdentifier);
            if (sample == null) {
                throw new UserFailureException("Unknown sample: " + sampleIdentifier);
            }
            List<Sample> parents = this.getService().listSamples(ListSampleCriteria.createForChild(new TechId(sample.getId())));
            if (parents.size() != 1) {
                throw new UserFailureException("Exactly one parent sample expected for " + sample.getIdentifier() + " instead of " + parents.size());
            }
            Sample biologicalSample = parents.get(0);
            header.setBiologicalSample(biologicalSample.getCode());
            String protein = this.tryToFindProteinProperty(biologicalSample);
            if (protein == null) continue;
            header.setProtein(protein);
        }
    }

    private String tryToFindProteinProperty(Sample sample) {
        List<IEntityProperty> sampleProperties = sample.getProperties();
        for (IEntityProperty property : sampleProperties) {
            if (!property.getPropertyType().getCode().equalsIgnoreCase(this.proteinPropertyCode)) continue;
            Material material = property.getMaterial();
            if (material != null) {
                return material.getCode();
            }
            return property.tryGetAsString();
        }
        List<Sample> parents = this.getService().listSamples(ListSampleCriteria.createForChild(new TechId(sample.getId())));
        for (Sample parent : parents) {
            String proteinProperty = this.tryToFindProteinProperty(parent);
            if (proteinProperty == null) continue;
            return proteinProperty;
        }
        return null;
    }

    private Table readTable(File file) {
        Table table;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            CsvReader csvReader = new CsvReader((Reader)reader);
            csvReader.readRecord();
            csvReader.readRecord();
            csvReader.readRecord();
            Map<String, String> map = this.createAbundanceColumnMap(csvReader.getRawRecord());
            csvReader.readRecord();
            String[] columnHeaders = csvReader.getValues();
            ArrayList<Header> headers = new ArrayList<Header>();
            int i = 0;
            while (i < columnHeaders.length) {
                String header = columnHeaders[i];
                String newHeader = map.get(header);
                headers.add(new Header(header, newHeader));
                ++i;
            }
            Table table2 = new Table(headers);
            while (csvReader.readRecord()) {
                table2.add(csvReader.getValues());
            }
            table = table2;
        }
        catch (IOException ex) {
            try {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return table;
    }

    private Map<String, String> createAbundanceColumnMap(String abundanceColumnMappingDescription) {
        int indexOfFirstColon = abundanceColumnMappingDescription.indexOf(58);
        if (indexOfFirstColon < 0) {
            throw new UserFailureException("Missing ':' in third line: " + abundanceColumnMappingDescription);
        }
        String[] terms = abundanceColumnMappingDescription.substring(indexOfFirstColon + 1).split(",");
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            int lastIndexOfDot;
            String term = stringArray[n2];
            int indexOfColon = term.indexOf(58);
            if (indexOfColon < 0) {
                throw new UserFailureException("Missing ':' in mapping definition: " + term);
            }
            String abundanceColumn = "abundance_" + term.substring(0, indexOfColon).trim();
            String fileName = term.substring(indexOfColon + 1).trim();
            int lastIndexOfSlash = fileName.lastIndexOf(47);
            if (lastIndexOfSlash >= 0) {
                fileName = fileName.substring(lastIndexOfSlash + 1);
            }
            if ((lastIndexOfDot = fileName.lastIndexOf(46)) >= 0) {
                fileName = fileName.substring(0, lastIndexOfDot);
            }
            map.put(abundanceColumn, fileName);
            ++n2;
        }
        return map;
    }

    private File getProteinFile(DatasetDescription datasetDescription, IDataSetDirectoryProvider directoryProvider) {
        File dataSetDir = this.getDataSubDir(directoryProvider, datasetDescription);
        if (!dataSetDir.isDirectory()) {
            throw new EnvironmentFailureException("Data set folder is not a directory: " + dataSetDir);
        }
        File[] files = dataSetDir.listFiles();
        if (files.length == 0) {
            throw new EnvironmentFailureException("Empty data set folder: " + dataSetDir);
        }
        File proteinFile = new File(files[0], PROTEIN_FILE_NAME);
        if (!proteinFile.exists()) {
            throw new UserFailureException("File proteins.csv missing.");
        }
        if (!proteinFile.isFile()) {
            throw new UserFailureException("File proteins.csv is a directory.");
        }
        return proteinFile;
    }

    private IEncapsulatedOpenBISService getService() {
        if (this.service == null) {
            this.service = ServiceProvider.getOpenBISService();
        }
        return this.service;
    }

    void setService(IEncapsulatedOpenBISService service) {
        this.service = service;
    }

    private static final class Header {
        private final boolean abundanceHeader;
        private final String header;
        private String biologicalSample;
        private String protein;

        Header(String header, String newHeader) {
            this.abundanceHeader = newHeader != null;
            this.header = this.abundanceHeader ? newHeader : header;
        }

        public final String getBiologicalSample() {
            return this.biologicalSample;
        }

        public final void setBiologicalSample(String biologicalSample) {
            this.biologicalSample = biologicalSample;
        }

        public final String getProtein() {
            return this.protein;
        }

        public final void setProtein(String protein) {
            this.protein = protein;
        }

        public final String getHeader() {
            return this.header;
        }

        public final boolean isAbundanceHeader() {
            return this.abundanceHeader;
        }

        public String toString() {
            return this.abundanceHeader ? String.valueOf(this.header) + " [" + this.biologicalSample + ", " + this.protein + ']' : this.header;
        }
    }

    private static final class Row {
        private final String[] values;
        private final Map<String, Integer> columnIndexMap;

        Row(String[] values, Map<String, Integer> columnIndexMap) {
            this.values = values;
            this.columnIndexMap = columnIndexMap;
        }

        public String getValue(String column) {
            Integer index = this.columnIndexMap.get(column);
            return index == null ? "" : this.values[index];
        }

        public String toString() {
            return Arrays.asList(this.values).toString();
        }
    }

    private static final class Table {
        private final List<Header> headers;
        private final Map<String, Integer> columnIndexMap = new HashMap<String, Integer>();
        private final List<Row> rows = new ArrayList<Row>();

        Table(List<Header> headers) {
            this.headers = headers;
            int i = 0;
            while (i < headers.size()) {
                this.columnIndexMap.put(headers.get(i).getHeader(), i);
                ++i;
            }
        }

        void add(String[] row) {
            this.rows.add(new Row(row, this.columnIndexMap));
        }

        public final List<Header> getHeaders() {
            return this.headers;
        }

        public final List<Row> getRows() {
            return this.rows;
        }
    }
}

