/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.etlserver.IDataSetUploader;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.etlserver.proteomics.ProtXMLLoader;
import ch.systemsx.cisd.openbis.etlserver.proteomics.ResultDataSetUploader;
import ch.systemsx.cisd.openbis.etlserver.proteomics.Util;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinSummary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class ProtXMLUploader
implements IDataSetUploader {
    private static final String VALIDATING_XML = "validating-xml";
    private static final String ASSUMING_EXTENDED_PROT_XML = "assuming-extended-prot-xml";
    private static final String MS_INJECTION_SAMPLE_DELIMITER = "delimiter_for_sample_resolving";
    private static final String RESTRICTED_SAMPLE_RESOLVING = "restricted_sample_resolving";
    private static final String DATABASE_ENGINE = "database.engine";
    private static final String DATABASE_URL_HOST_PART = "database.url-host-part";
    private static final String DATABASE_BASIC_NAME = "database.basic-name";
    private static final String DATABASE_KIND = "database.kind";
    private static final String DATABASE_OWNER = "database.owner";
    private static final String DATABASE_PASSWORD = "database.password";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ProtXMLUploader.class);
    private final ProtXMLLoader loader;
    private final IEncapsulatedOpenBISService openbisService;
    private final DataSource dataSource;
    private final boolean assumingExtendedProtXML;
    private final String msInjectionSampleDelimiter;
    private final boolean restrictedSampleResolving;
    private ResultDataSetUploader currentResultDataSetUploader;

    private static DataSource createDataSource(Properties properties) {
        DatabaseConfigurationContext context = new DatabaseConfigurationContext();
        context.setDatabaseEngineCode(properties.getProperty(DATABASE_ENGINE, "postgresql"));
        context.setUrlHostPart(properties.getProperty(DATABASE_URL_HOST_PART, ""));
        context.setBasicDatabaseName(properties.getProperty(DATABASE_BASIC_NAME, "proteomics"));
        context.setDatabaseKind(PropertyUtils.getMandatoryProperty(properties, DATABASE_KIND));
        context.setOwner(properties.getProperty(DATABASE_OWNER, ""));
        context.setPassword(properties.getProperty(DATABASE_PASSWORD, ""));
        return context.getDataSource();
    }

    public ProtXMLUploader(Properties properties, IEncapsulatedOpenBISService openbisService) {
        this.dataSource = ProtXMLUploader.createDataSource(properties);
        this.openbisService = openbisService;
        this.assumingExtendedProtXML = PropertyUtils.getBoolean(properties, ASSUMING_EXTENDED_PROT_XML, false);
        this.msInjectionSampleDelimiter = properties.getProperty(MS_INJECTION_SAMPLE_DELIMITER, "~");
        this.restrictedSampleResolving = PropertyUtils.getBoolean(properties, RESTRICTED_SAMPLE_RESOLVING, true);
        this.loader = new ProtXMLLoader(PropertyUtils.getBoolean(properties, VALIDATING_XML, false));
    }

    @Override
    public void upload(File dataSet, DataSetInformation dataSetInformation) {
        Experiment experiment = dataSetInformation.tryToGetExperiment();
        if (experiment != null) {
            List<IEntityProperty> properties = experiment.getProperties();
            for (IEntityProperty property : properties) {
                if (!property.getPropertyType().getCode().equals("NOT_PROCESSED")) continue;
                return;
            }
        }
        long time = System.currentTimeMillis();
        File protXMLFile = Util.tryGetProtXMLFile(dataSet);
        ProteinSummary summary = this.loader.readProtXML(protXMLFile);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)(String.valueOf(summary.getProteinGroups().size()) + " protein groups are successfully read from '" + protXMLFile + "' in " + (System.currentTimeMillis() - time) + " msec"));
        }
        time = System.currentTimeMillis();
        if (this.currentResultDataSetUploader != null) {
            throw new IllegalStateException("The previous transaction has been neither commited nor rollbacked.");
        }
        this.currentResultDataSetUploader = this.createUploader();
        this.currentResultDataSetUploader.upload(dataSetInformation, summary);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Feeding result database took " + (System.currentTimeMillis() - time) + " msec."));
        }
    }

    @Override
    public void commit() {
        try {
            if (this.currentResultDataSetUploader != null) {
                this.currentResultDataSetUploader.commit();
            }
        }
        finally {
            this.currentResultDataSetUploader = null;
        }
    }

    @Override
    public void rollback() {
        try {
            if (this.currentResultDataSetUploader != null) {
                this.currentResultDataSetUploader.rollback();
            }
        }
        finally {
            this.currentResultDataSetUploader = null;
        }
    }

    protected ResultDataSetUploader createUploader() {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        return new ResultDataSetUploader(connection, this.openbisService, this.assumingExtendedProtXML, this.msInjectionSampleDelimiter, this.restrictedSampleResolving);
    }
}

