/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.BasicFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImport;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FormEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;

public class CustomImportForm
extends AbstractRegistrationForm {
    private static final String FIELD_LABEL_TEMPLATE = "File";
    private static final int NUMBER_OF_FIELDS = 1;
    private final String sessionKey;
    private final CustomImport customImport;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final BasicFileFieldManager fileFieldsManager;

    public CustomImportForm(IViewContext<ICommonClientServiceAsync> viewContext, String id, CustomImport customImport) {
        super(viewContext, id);
        this.saveButton.setText(this.messageProvider.getMessage("button_upload", new Object[0]));
        this.setResetButtonVisible(true);
        this.setDirtyCheckEnabled(false);
        this.sessionKey = String.valueOf(id) + "-" + customImport.getCode();
        this.customImport = customImport;
        this.viewContext = viewContext;
        if (this.isTemplateAvailable()) {
            MultiField multifield = new MultiField("", new Field[]{this.createTemplateField(), this.createEntityWithTemplateField()});
            multifield.setLabelSeparator("");
            this.formPanel.add((Widget)multifield);
        }
        this.fileFieldsManager = new BasicFileFieldManager(this.sessionKey, 1, FIELD_LABEL_TEMPLATE);
        this.fileFieldsManager.setMandatory();
        for (FileUploadField field : this.fileFieldsManager.getFields()) {
            this.formPanel.add((Widget)DatabaseModificationAwareField.wrapUnaware(field).get());
        }
        this.addUploadFeatures(this.sessionKey);
        this.formPanel.addListener(Events.BeforeSubmit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent be) {
                CustomImportForm.this.infoBox.displayProgress(CustomImportForm.this.messageProvider.getMessage("progress_uploading", new Object[0]));
            }
        });
        this.formPanel.addListener(Events.Submit, new FormPanelListener(this.infoBox){

            @Override
            protected void setUploadEnabled() {
                CustomImportForm.this.setUploadEnabled(true);
            }

            @Override
            protected void onSuccessfullUpload() {
                CustomImportForm.this.infoBox.displayProgress(CustomImportForm.this.messageProvider.getMessage("progress_processing", new Object[0]));
                CustomImportForm.this.viewContext.getCommonService().performCustomImport(CustomImportForm.this.sessionKey, CustomImportForm.this.customImport.getCode(), (AsyncCallback<String>)new AbstractRegistrationForm.AbstractRegistrationCallback<String>((AbstractRegistrationForm)CustomImportForm.this, CustomImportForm.this.viewContext){

                    @Override
                    protected void process(String result) {
                        super.process(result);
                        CustomImportForm.this.resetPanel();
                    }

                    @Override
                    protected String createSuccessfullRegistrationInfo(String result) {
                        return String.valueOf(result) + " succesfully uploaded to the datastore server.";
                    }

                    @Override
                    public void finishOnFailure(Throwable caught) {
                        super.finishOnFailure(caught);
                        CustomImportForm.this.resetPanel();
                    }
                });
            }
        });
    }

    @Override
    protected void submitValidForm() {
        this.setUploadEnabled(false);
        this.formPanel.submit();
    }

    private boolean isTemplateAvailable() {
        return this.getTemplateEntityKind() != null && this.getTemplateEntityPermId() != null && this.getTemplateAttachmentName() != null;
    }

    private Field<?> createTemplateField() {
        LabelField linkToTemplate = new LabelField(LinkRenderer.renderAsLink(this.viewContext.getMessage("file_template_label", new Object[0])));
        linkToTemplate.sinkEvents(1);
        linkToTemplate.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                CustomImportForm.this.onLinkToTemplateClick();
            }
        });
        return linkToTemplate;
    }

    private Field<?> createEntityWithTemplateField() {
        LabelField linkToEntityWithTemplate = new LabelField(LinkRenderer.renderAsLink(this.viewContext.getMessage("entity_with_file_template_label", new Object[0])));
        linkToEntityWithTemplate.sinkEvents(1);
        linkToEntityWithTemplate.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                CustomImportForm.this.onLinkToEntityWithTemplateClick();
            }
        });
        linkToEntityWithTemplate.addStyleName("entityWithTemplateField");
        return linkToEntityWithTemplate;
    }

    private void onLinkToTemplateClick() {
        if (AttachmentHolderKind.PROJECT.equals(this.getTemplateEntityKind())) {
            this.viewContext.getService().getProjectInfoByPermId(this.getTemplateEntityPermId(), new LinkToProjectTemplateCallback(this.viewContext));
        } else {
            this.openUrl(PermlinkUtilities.createAttachmentPermlinkURL(GWTUtils.getBaseIndexURL(), this.getTemplateAttachmentName(), null, this.getTemplateEntityKind(), this.getTemplateEntityPermId()));
        }
    }

    private void onLinkToEntityWithTemplateClick() {
        if (AttachmentHolderKind.PROJECT.equals(this.getTemplateEntityKind())) {
            this.viewContext.getService().getProjectInfoByPermId(this.getTemplateEntityPermId(), new LinkToEntityWithProjectTemplateCallback(this.viewContext));
        } else {
            this.openUrl(PermlinkUtilities.createPermlinkURL(GWTUtils.getBaseIndexURL(), EntityKind.valueOf(this.getTemplateEntityKind().name()), this.getTemplateEntityPermId()));
        }
    }

    private AttachmentHolderKind getTemplateEntityKind() {
        String str = this.customImport.getProperty(CustomImport.PropertyNames.TEMPLATE_ENTITY_KIND.getName());
        if (str == null) {
            return null;
        }
        try {
            return AttachmentHolderKind.valueOf(str);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private String getTemplateEntityPermId() {
        return this.customImport.getProperty(CustomImport.PropertyNames.TEMPLATE_ENTITY_PERMID.getName());
    }

    private String getTemplateAttachmentName() {
        return this.customImport.getProperty(CustomImport.PropertyNames.TEMPLATE_ATTACHMENT_NAME.getName());
    }

    @Override
    protected void setUploadEnabled(boolean enabled) {
        super.setUploadEnabled(enabled);
        this.infoBoxResetListener.setEnabled(enabled);
    }

    private void openUrl(String url) {
        Window.open((String)url, (String)"_blank", (String)"");
    }

    private class LinkToEntityWithProjectTemplateCallback
    extends AbstractAsyncCallback<Project> {
        public LinkToEntityWithProjectTemplateCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Project project) {
            CustomImportForm.this.openUrl(PermlinkUtilities.createProjectPermlinkURL(GWTUtils.getBaseIndexURL(), project.getCode(), project.getSpace().getCode()));
        }
    }

    private class LinkToProjectTemplateCallback
    extends AbstractAsyncCallback<Project> {
        public LinkToProjectTemplateCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Project project) {
            CustomImportForm.this.openUrl(PermlinkUtilities.createProjectAttachmentPermlinkURL(GWTUtils.getBaseIndexURL(), CustomImportForm.this.getTemplateAttachmentName(), null, project.getCode(), project.getSpace().getCode()));
        }
    }
}

