/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.IColumnDefinitionUI;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ILinkGenerator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableGridColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import java.io.Serializable;

public class TypedTableGridColumnDefinitionUI<T extends Serializable>
extends TypedTableGridColumnDefinition<T>
implements IColumnDefinitionUI<TableModelRowWithObject<T>> {
    private final transient ILinkGenerator<T> linkGeneratorOrNull;
    private boolean hidden;

    public TypedTableGridColumnDefinitionUI(TableModelColumnHeader header, String title, String downloadURL, String sessionID, ILinkGenerator<T> linkGeneratorOrNull) {
        super(header, title, downloadURL, sessionID);
        this.linkGeneratorOrNull = linkGeneratorOrNull;
        if (header != null) {
            this.hidden = header.isHidden();
        }
    }

    private TypedTableGridColumnDefinitionUI() {
        this(null, null, null, null, null);
    }

    @Override
    public int getWidth() {
        return this.header.getDefaultColumnWidth();
    }

    public final void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isEditable() {
        return this.header.isEditable();
    }

    @Override
    public boolean isDynamicProperty() {
        return this.header.isDynamicProperty();
    }

    public boolean isLink() {
        return false;
    }

    @Override
    public String tryGetLink(TableModelRowWithObject<T> entity) {
        if (this.linkGeneratorOrNull == null) {
            return null;
        }
        ISerializableComparable value = entity.getValues().get(this.header.getIndex());
        T objectOrNull = entity.getObjectOrNull();
        return objectOrNull == null ? null : this.linkGeneratorOrNull.tryGetLink(objectOrNull, value);
    }

    @Override
    public boolean isNumeric() {
        DataTypeCode type = this.header.getDataType();
        return type == DataTypeCode.INTEGER || type == DataTypeCode.REAL;
    }

    @Override
    public boolean isVocabulary() {
        DataTypeCode type = this.header.getDataType();
        return type == DataTypeCode.CONTROLLEDVOCABULARY;
    }

    @Override
    public Vocabulary tryGetVocabulary() {
        return this.header.tryGetVocabulary();
    }

    @Override
    public boolean isCustom() {
        return false;
    }
}

